/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.ui;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.SelectionManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.locationtech.jts.geom.Geometry;

public abstract class AbstractSelection {
    private Map<Layer, Map<Feature, Set<Integer>>> layerMap = new LinkedHashMap<Layer, Map<Feature, Set<Integer>>>();
    private AbstractSelection child;
    private AbstractSelection parent;
    private final SelectionManager selectionManager;

    public abstract String getRendererContentID();

    public AbstractSelection(SelectionManager selectionManager) {
        this.selectionManager = selectionManager;
    }

    public abstract List<Geometry> items(Geometry var1);

    public List<Geometry> items(Geometry geometry, Collection<Integer> indices) {
        List<Geometry> allItems = this.items(geometry);
        ArrayList<Geometry> items = new ArrayList<Geometry>(1);
        for (Integer index : indices) {
            items.add(allItems.get(index));
        }
        return items;
    }

    public Map<Feature, Set<Integer>> getFeatureToSelectedItemIndexCollectionMap(Layer layer) {
        if (!this.layerMap.containsKey(layer)) {
            return new LinkedHashMap<Feature, Set<Integer>>();
        }
        return this.layerMap.get(layer);
    }

    public Set<Integer> getSelectedItemIndices(Layer layer, Feature feature) {
        Set<Integer> indices = this.getFeatureToSelectedItemIndexCollectionMap(layer).get(feature);
        return indices == null ? Collections.emptySet() : indices;
    }

    public Map<Feature, List<Geometry>> getFeatureToSelectedItemCollectionMap(Layer layer) {
        LinkedHashMap<Feature, List<Geometry>> collectionMap = new LinkedHashMap<Feature, List<Geometry>>();
        for (Feature feature : this.getFeatureToSelectedItemIndexCollectionMap(layer).keySet()) {
            Set<Integer> set = this.getSelectedItemIndices(layer, feature);
            if (set == null) continue;
            collectionMap.put(feature, this.items(feature.getGeometry(), set));
        }
        return collectionMap;
    }

    public Collection<Layer> getLayersWithSelectedItems() {
        ArrayList<Layer> layersWithSelectedItems = new ArrayList<Layer>();
        for (Layer layer : this.layerMap.keySet()) {
            if (this.getFeaturesWithSelectedItems(layer).isEmpty()) continue;
            layersWithSelectedItems.add(layer);
        }
        return layersWithSelectedItems;
    }

    public Collection<Feature> getFeaturesWithSelectedItems() {
        ArrayList<Feature> featuresWithSelectedItems = new ArrayList<Feature>();
        for (Layer layer : this.layerMap.keySet()) {
            featuresWithSelectedItems.addAll(this.getFeaturesWithSelectedItems(layer));
        }
        return featuresWithSelectedItems;
    }

    public Collection<Feature> getFeaturesWithSelectedItems(Layer layer) {
        ArrayList<Feature> featuresWithSelectedItems = new ArrayList<Feature>();
        for (Feature feature : this.getFeatureToSelectedItemIndexCollectionMap(layer).keySet()) {
            if (this.getFeatureToSelectedItemIndexCollectionMap(layer).get(feature).isEmpty()) continue;
            featuresWithSelectedItems.add(feature);
        }
        return featuresWithSelectedItems;
    }

    public Collection<Geometry> getSelectedItems() {
        ArrayList<Geometry> selectedItems = new ArrayList<Geometry>(1);
        for (Layer layer : this.layerMap.keySet()) {
            selectedItems.addAll(this.getSelectedItems(layer));
        }
        return selectedItems;
    }

    public Collection<Geometry> getSelectedItems(Layer layer) {
        ArrayList<Geometry> selectedItems = new ArrayList<Geometry>(1);
        for (Feature feature : this.getFeatureToSelectedItemIndexCollectionMap(layer).keySet()) {
            selectedItems.addAll(this.getSelectedItems(layer, feature));
        }
        return selectedItems;
    }

    public Collection<Geometry> getSelectedItems(Layer layer, Feature feature) {
        return this.getSelectedItems(layer, feature, feature.getGeometry());
    }

    public Collection<Geometry> getSelectedItems(Layer layer, Feature feature, Geometry geometry) {
        if (this.layerMap.get(layer) != null) {
            Set<Integer> indices = this.getFeatureToSelectedItemIndexCollectionMap(layer).get(feature);
            if (indices == null) {
                indices = Collections.emptySet();
            }
            return this.items(geometry, indices);
        }
        return Collections.emptySet();
    }

    public Set<Integer> indices(Geometry geometry, Collection<Geometry> items) {
        List<Geometry> allItems = this.items(geometry);
        LinkedHashSet<Integer> indices = new LinkedHashSet<Integer>(1);
        for (Geometry item : items) {
            indices.add(allItems.indexOf(item));
        }
        return indices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unselectItems(Layer layer, Map<Feature, List<Geometry>> featureToItemCollectionMap) {
        boolean originalPanelUpdatesEnabled = this.selectionManager.arePanelUpdatesEnabled();
        this.selectionManager.setPanelUpdatesEnabled(false);
        try {
            for (Feature feature : featureToItemCollectionMap.keySet()) {
                List<Geometry> items = featureToItemCollectionMap.get(feature);
                if (items != null) {
                    this.unselectItems(layer, feature, items);
                }
                if (this.layerMap.get(layer) != null && !this.layerMap.get(layer).isEmpty()) continue;
                this.layerMap.remove(layer);
            }
        }
        finally {
            this.selectionManager.setPanelUpdatesEnabled(originalPanelUpdatesEnabled);
        }
        this.updatePanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectItems(Layer layer, Map<Feature, List<Geometry>> featureToItemCollectionMap) {
        if (!featureToItemCollectionMap.isEmpty()) {
            boolean originalPanelUpdatesEnabled = this.selectionManager.arePanelUpdatesEnabled();
            this.selectionManager.setPanelUpdatesEnabled(false);
            try {
                for (Feature feature : featureToItemCollectionMap.keySet()) {
                    List<Geometry> items = featureToItemCollectionMap.get(feature);
                    if (items == null) continue;
                    this.selectItems(layer, feature, items);
                }
            }
            finally {
                this.selectionManager.setPanelUpdatesEnabled(originalPanelUpdatesEnabled);
            }
            this.updatePanel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectItems(Layer layer, Feature feature, Collection<Geometry> items) {
        Collection<Geometry> itemsToSelect = this.itemsNotSelectedInAncestors(layer, feature, items);
        boolean originalPanelUpdatesEnabled = this.selectionManager.arePanelUpdatesEnabled();
        this.selectionManager.setPanelUpdatesEnabled(false);
        try {
            Set<Integer> itemIndices;
            if (this.layerMap.get(layer) == null && feature != null && items != null && !items.isEmpty()) {
                this.layerMap.put(layer, new LinkedHashMap());
            }
            this.unselectInDescendants(layer, feature, itemsToSelect);
            Set<Integer> featureIndices = this.getFeatureToSelectedItemIndexCollectionMap(layer).get(feature);
            if (featureIndices == null) {
                featureIndices = new LinkedHashSet<Integer>(1);
                this.getFeatureToSelectedItemIndexCollectionMap(layer).put(feature, featureIndices);
            }
            if ((itemIndices = this.indices(feature.getGeometry(), itemsToSelect)) != null) {
                featureIndices.addAll(itemIndices);
            }
        }
        finally {
            if (this.layerMap.get(layer) == null || this.layerMap.get(layer).isEmpty()) {
                this.layerMap.remove(layer);
            }
            this.selectionManager.setPanelUpdatesEnabled(originalPanelUpdatesEnabled);
        }
        this.updatePanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unselectItems(Layer layer, Feature feature, Collection<Geometry> items) {
        boolean originalPanelUpdatesEnabled = this.selectionManager.arePanelUpdatesEnabled();
        this.selectionManager.setPanelUpdatesEnabled(false);
        try {
            Set<Integer> itemsIndices = this.indices(feature.getGeometry(), items);
            Set<Integer> featureIndices = this.getFeatureToSelectedItemIndexCollectionMap(layer).get(feature);
            if (featureIndices != null && itemsIndices != null) {
                featureIndices.removeAll(itemsIndices);
                if (featureIndices.isEmpty()) {
                    this.getFeatureToSelectedItemIndexCollectionMap(layer).remove(feature);
                }
            }
        }
        finally {
            if (this.layerMap.get(layer) == null || this.layerMap.get(layer).isEmpty()) {
                this.layerMap.remove(layer);
            }
            this.selectionManager.setPanelUpdatesEnabled(originalPanelUpdatesEnabled);
        }
        this.updatePanel();
    }

    public Collection<Geometry> itemsNotSelectedInAncestors(Layer layer, Feature feature, Collection<Geometry> items) {
        ArrayList<Geometry> itemsNotSelectedInAncestors = new ArrayList<Geometry>(1);
        if (layer.isSelectable()) {
            for (Geometry item : items) {
                if (this.selectedInAncestors(layer, feature, item)) continue;
                itemsNotSelectedInAncestors.add(item);
            }
        }
        return itemsNotSelectedInAncestors;
    }

    protected abstract boolean selectedInAncestors(Layer var1, Feature var2, Geometry var3);

    protected abstract void unselectInDescendants(Layer var1, Feature var2, Collection<Geometry> var3);

    public void selectItems(Layer layer, Feature feature) {
        this.selectItems(layer, feature, this.items(feature.getGeometry()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void selectItems(Layer layer, Collection features) {
        boolean originalPanelUpdatesEnabled = this.selectionManager.arePanelUpdatesEnabled();
        this.selectionManager.setPanelUpdatesEnabled(false);
        try {
            for (Object object : features) {
                Feature feature = (Feature)object;
                this.selectItems(layer, feature);
            }
        }
        finally {
            this.selectionManager.setPanelUpdatesEnabled(originalPanelUpdatesEnabled);
        }
        this.updatePanel();
    }

    public void unselectFromFeaturesWithModifiedItemCounts(Layer layer, Collection<Feature> features, Collection<Feature> oldFeatureClones) {
        ArrayList<Feature> featuresToUnselect = new ArrayList<Feature>(1);
        Iterator<Feature> j = oldFeatureClones.iterator();
        j.hasNext();
        for (Feature feature : features) {
            Feature oldFeatureClone = j.next();
            if (this.items(feature.getGeometry()).size() == this.items(oldFeatureClone.getGeometry()).size()) continue;
            featuresToUnselect.add(feature);
        }
        this.unselectItems(layer, featuresToUnselect);
    }

    public void unselectItems() {
        this.layerMap.clear();
        this.updatePanel();
    }

    public void unselectItems(Layer layer) {
        this.layerMap.remove(layer);
        this.updatePanel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unselectItems(Layer layer, Collection features) {
        boolean originalPanelUpdatesEnabled = this.selectionManager.arePanelUpdatesEnabled();
        this.selectionManager.setPanelUpdatesEnabled(false);
        try {
            for (Object object : features) {
                this.unselectItems(layer, (Feature)object);
            }
        }
        finally {
            this.selectionManager.setPanelUpdatesEnabled(originalPanelUpdatesEnabled);
        }
        this.updatePanel();
    }

    public void unselectItems(Layer layer, Feature feature) {
        this.getFeatureToSelectedItemIndexCollectionMap(layer).remove(feature);
        if (this.layerMap.get(layer) == null || this.layerMap.get(layer).isEmpty()) {
            this.layerMap.remove(layer);
        }
    }

    public void unselectItem(Layer layer, Feature feature, int selectedItemIndex) {
        Set<Integer> indices = this.getFeatureToSelectedItemIndexCollectionMap(layer).get(feature);
        if (indices != null) {
            indices.remove(selectedItemIndex);
            if (indices.isEmpty()) {
                this.getFeatureToSelectedItemIndexCollectionMap(layer).remove(feature);
            }
        }
        if (this.layerMap.get(layer) == null || this.layerMap.get(layer).isEmpty()) {
            this.layerMap.remove(layer);
        }
    }

    private void updatePanel() {
        this.selectionManager.updatePanel();
    }

    public void setChild(AbstractSelection child) {
        this.child = child;
    }

    public void setParent(AbstractSelection parent) {
        this.parent = parent;
    }

    protected AbstractSelection getChild() {
        return this.child;
    }

    protected AbstractSelection getParent() {
        return this.parent;
    }
}

