/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.model;

import com.vividsolutions.jump.workbench.model.Layer;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEdit;

public abstract class UndoableCommand {
    private String name;
    private Layer layer;
    private boolean canceled = false;
    public static final UndoableCommand DUMMY = new UndoableCommand("Dummy"){

        @Override
        public void execute() {
        }

        @Override
        public void unexecute() {
        }
    };

    public UndoableCommand(String name) {
        this.name = name;
    }

    public UndoableCommand(String name, Layer layer) {
        this(name);
        this.setLayer(layer);
    }

    public void setLayer(Layer layer) {
        this.layer = layer;
    }

    public Layer getLayer() {
        return this.layer;
    }

    protected void dispose() {
        this.layer = null;
        this.canceled = true;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public abstract void execute();

    public abstract void unexecute();

    public UndoableEdit toUndoableEdit() {
        return new AbstractUndoableEdit(){

            @Override
            public String getPresentationName() {
                return UndoableCommand.this.name;
            }

            @Override
            public void redo() {
                if (UndoableCommand.this.isCanceled()) {
                    return;
                }
                UndoableCommand.this.execute();
                super.redo();
            }

            @Override
            public void die() {
                UndoableCommand.this.dispose();
                super.die();
            }

            @Override
            public void undo() {
                if (UndoableCommand.this.isCanceled()) {
                    return;
                }
                super.undo();
                UndoableCommand.this.unexecute();
            }

            @Override
            public boolean isSignificant() {
                return !UndoableCommand.this.isCanceled();
            }
        };
    }

    public String getName() {
        return this.name;
    }
}

