/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.datasource;

import com.vividsolutions.jump.io.datasource.DataSourceQuery;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datasource.AbstractSaveDatasetAsPlugIn;
import com.vividsolutions.jump.workbench.datasource.DataSourceQueryChooserDialog;
import com.vividsolutions.jump.workbench.datasource.DataSourceQueryChooserManager;
import com.vividsolutions.jump.workbench.datasource.FileDataSourceQueryChooser;
import com.vividsolutions.jump.workbench.datasource.SaveFileDataSourceQueryChooser;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.io.File;
import java.util.Collection;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;

public class SaveDatasetAsPlugIn
extends AbstractSaveDatasetAsPlugIn {
    public static final ImageIcon ICON = IconLoader.icon("disk_dots.png");

    public SaveDatasetAsPlugIn() {
        this.setShortcutKeys(83);
        this.setShortcutModifiers(9);
    }

    @Override
    protected Collection<DataSourceQuery> showDialog(WorkbenchContext context) {
        GUIUtil.centreOnWindow(this.getDialog());
        FileDataSourceQueryChooser.FileChooserPanel fcp = (FileDataSourceQueryChooser.FileChooserPanel)context.getBlackboard().get(SaveFileDataSourceQueryChooser.FILE_CHOOSER_PANEL_KEY);
        if (fcp != null) {
            JFileChooser jfc = fcp.getChooser();
            jfc.setSelectedFile(new File(jfc.getCurrentDirectory(), context.getLayerableNamePanel().getSelectedLayers()[0].getName().replaceAll("[/:\\\\><\\|]", "_")));
        }
        this.getDialog().setVisible(true);
        return this.getDialog().wasOKPressed() ? this.getDialog().getCurrentChooser().getDataSourceQueries() : null;
    }

    @Override
    protected void setSelectedFormat(String format) {
        this.getDialog().setSelectedFormat(format);
    }

    @Override
    protected String getSelectedFormat() {
        return this.getDialog().getSelectedFormat();
    }

    private DataSourceQueryChooserDialog getDialog() {
        String KEY = this.getClass().getName() + " - DIALOG";
        WorkbenchContext context = this.getContext().getWorkbenchContext();
        if (null == context.getBlackboard().get(KEY)) {
            context.getBlackboard().put(KEY, new DataSourceQueryChooserDialog(DataSourceQueryChooserManager.get(context.getWorkbench().getBlackboard()).getSaveDataSourceQueryChoosers(), context.getWorkbench().getFrame(), this.getName(), true));
        }
        DataSourceQueryChooserDialog dialog = (DataSourceQueryChooserDialog)context.getWorkbench().getBlackboard().get(KEY);
        dialog.setDialogTask(DataSourceQueryChooserDialog.SAVEDIALOG);
        return dialog;
    }
}

