/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.workbench.datasource;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.io.FMEGMLReader;
import com.vividsolutions.jump.io.FMEGMLWriter;
import com.vividsolutions.jump.io.JMLReader;
import com.vividsolutions.jump.io.JMLWriter;
import com.vividsolutions.jump.io.JUMPReader;
import com.vividsolutions.jump.io.JUMPWriter;
import com.vividsolutions.jump.io.ShapefileReader;
import com.vividsolutions.jump.io.ShapefileWriter;
import com.vividsolutions.jump.io.WKTReader;
import com.vividsolutions.jump.io.WKTWriter;
import com.vividsolutions.jump.io.datasource.StandardReaderWriterFileDataSource;
import com.vividsolutions.jump.io.geojson.GeoJSONReader;
import com.vividsolutions.jump.io.geojson.GeoJSONWriter;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datasource.DataSourceQueryChooserManager;
import com.vividsolutions.jump.workbench.datasource.GMLDataSourceQueryChooserInstaller;
import com.vividsolutions.jump.workbench.datasource.LoadFileDataSourceQueryChooser;
import com.vividsolutions.jump.workbench.datasource.SaveFileDataSourceQueryChooser;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import java.awt.Component;
import java.io.File;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import org.locationtech.jts.util.Assert;
import org.openjump.core.ccordsys.srid.SRIDStyle;
import org.openjump.core.ui.DatasetOptionsPanel;
import org.openjump.core.ui.swing.ComboBoxComponentPanel;
import org.openjump.core.ui.swing.factory.field.ComboBoxFieldComponentFactory;

public class InstallStandardDataSourceQueryChoosersPlugIn
extends AbstractPlugIn {
    private void addFileDataSourceQueryChoosers(JUMPReader reader, JUMPWriter writer, final String description, final WorkbenchContext context, Class readerWriterDataSourceClass) {
        DataSourceQueryChooserManager chooserManager = DataSourceQueryChooserManager.get(context.getBlackboard());
        chooserManager.addLoadDataSourceQueryChooser(new LoadFileDataSourceQueryChooser(readerWriterDataSourceClass, description, InstallStandardDataSourceQueryChoosersPlugIn.extensions(readerWriterDataSourceClass), context){

            @Override
            protected void addFileFilters(JFileChooser chooser) {
                super.addFileFilters(chooser);
                InstallStandardDataSourceQueryChoosersPlugIn.addCompressedFileFilter(description, chooser);
            }
        });
        if (writer != null) {
            if (readerWriterDataSourceClass != StandardReaderWriterFileDataSource.Shapefile.class) {
                chooserManager.addSaveDataSourceQueryChooser(new SaveFileDataSourceQueryChooser(readerWriterDataSourceClass, description, InstallStandardDataSourceQueryChoosersPlugIn.extensions(readerWriterDataSourceClass), context));
            } else {
                chooserManager.addSaveDataSourceQueryChooser(new SaveFileDataSourceQueryChooser(readerWriterDataSourceClass, description, InstallStandardDataSourceQueryChoosersPlugIn.extensions(readerWriterDataSourceClass), context){
                    private JComponent comboboxFieldComponent;

                    @Override
                    protected Map<String, Object> toProperties(File file) {
                        HashMap<String, Object> properties = new HashMap<String, Object>(super.toProperties(file));
                        String charsetName = Charset.defaultCharset().name();
                        if (this.comboboxFieldComponent instanceof ComboBoxComponentPanel) {
                            charsetName = (String)((ComboBoxComponentPanel)this.comboboxFieldComponent).getSelectedItem();
                        }
                        properties.put("charset", charsetName);
                        for (Layer layer : context.getLayerableNamePanel().getSelectedLayers()) {
                            SRIDStyle sridStyle = (SRIDStyle)layer.getStyle(SRIDStyle.class);
                            if (null == sridStyle) continue;
                            properties.put("SrsRegistry", "EPSG");
                            properties.put("SrsCode", sridStyle.getSRID());
                        }
                        return properties;
                    }

                    @Override
                    protected Component getSouthComponent1() {
                        boolean showCharsetSelection = false;
                        Object showCharsetSelectionObject = PersistentBlackboardPlugIn.get(context.getBlackboard()).get(DatasetOptionsPanel.BB_DATASET_OPTIONS_SHOW_CHARSET_SELECTION);
                        if (showCharsetSelectionObject instanceof Boolean) {
                            showCharsetSelection = (Boolean)showCharsetSelectionObject;
                        }
                        if (showCharsetSelection) {
                            ComboBoxFieldComponentFactory fieldComponentFactory = new ComboBoxFieldComponentFactory(context, I18N.getInstance().get("org.openjump.core.ui.io.file.DataSourceFileLayerLoader.charset") + ":", Charset.availableCharsets().keySet().toArray());
                            this.comboboxFieldComponent = fieldComponentFactory.createComponent();
                            fieldComponentFactory.setValue(this.comboboxFieldComponent, Charset.defaultCharset().name());
                            return this.comboboxFieldComponent;
                        }
                        return new Component(){};
                    }
                });
            }
        }
    }

    public static String[] extensions(Class readerWriterDataSourceClass) {
        String[] exts = null;
        try {
            exts = ((StandardReaderWriterFileDataSource)readerWriterDataSourceClass.newInstance()).getExtensions();
        }
        catch (Exception e) {
            Assert.shouldNeverReachHere((String)e.toString());
        }
        return exts;
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        this.addFileDataSourceQueryChoosers(new JMLReader(), new JMLWriter(), "JUMP GML", context.getWorkbenchContext(), StandardReaderWriterFileDataSource.JML.class);
        new GMLDataSourceQueryChooserInstaller().addLoadGMLFileDataSourceQueryChooser(context);
        new GMLDataSourceQueryChooserInstaller().addSaveGMLFileDataSourceQueryChooser(context);
        this.addFileDataSourceQueryChoosers(new FMEGMLReader(), new FMEGMLWriter(), "FME GML", context.getWorkbenchContext(), StandardReaderWriterFileDataSource.FMEGML.class);
        this.addFileDataSourceQueryChoosers(new WKTReader(), new WKTWriter(), "WKT", context.getWorkbenchContext(), StandardReaderWriterFileDataSource.WKT.class);
        this.addFileDataSourceQueryChoosers(new ShapefileReader(), new ShapefileWriter(), "ESRI Shapefile", context.getWorkbenchContext(), StandardReaderWriterFileDataSource.Shapefile.class);
        this.addFileDataSourceQueryChoosers(new GeoJSONReader(), new GeoJSONWriter(), "GeoJSON", context.getWorkbenchContext(), StandardReaderWriterFileDataSource.GeoJSON.class);
    }

    @Deprecated
    public static void addCompressedFileFilter(String description, JFileChooser chooser) {
    }
}

