/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.warp;

import com.vividsolutions.jump.JUMPException;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateFilter;
import org.locationtech.jts.geom.Geometry;

public abstract class CoordinateTransform {
    private CoordinateFilter coordinateFilter = new CoordinateFilter(){

        public void filter(Coordinate coordinate) {
            coordinate.setCoordinate(CoordinateTransform.this.transform(coordinate));
        }
    };

    public abstract Coordinate transform(Coordinate var1);

    public FeatureCollection transform(FeatureCollection featureCollection) throws JUMPException {
        FeatureDataset newCollection = new FeatureDataset(featureCollection.getFeatureSchema());
        for (Feature feature : featureCollection) {
            Geometry newGeometry = this.transform(feature.getGeometry());
            Feature newFeature = feature.clone(false);
            newFeature.setGeometry(newGeometry);
            newCollection.add(newFeature);
        }
        return newCollection;
    }

    public Geometry transform(Geometry oldGeometry) {
        Geometry newGeometry = oldGeometry.copy();
        newGeometry.apply(this.coordinateFilter);
        newGeometry.geometryChanged();
        return newGeometry;
    }
}

