/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.util;

import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Random;

public class SuggestTree {
    private final Random random = new Random();
    private final int k;
    private Node root;
    private int size;

    public SuggestTree(int k) {
        if (k < 1) {
            throw new IllegalArgumentException();
        }
        this.k = k;
        this.root = null;
        this.size = 0;
    }

    public Node getAutocompleteSuggestions(String prefix) {
        return this.search(prefix);
    }

    public Entry getEntry(String term) {
        Node n = this.search(term);
        if (n == null || n.charEnd > term.length()) {
            return null;
        }
        return n.entry;
    }

    public Iterator iterator() {
        return new Iterator();
    }

    public int size() {
        return this.size;
    }

    public void put(String term, int weight) {
        if (term.isEmpty() || term.length() > Short.MAX_VALUE) {
            throw new IllegalArgumentException();
        }
        if (this.root == null) {
            this.root = new Node(term, weight, 0, null);
            this.finishInsertion(this.root);
            return;
        }
        short i = 0;
        Node n = this.root;
        while (true) {
            if (term.charAt(i) < n.firstChar) {
                if (n.left == null) {
                    n.left = new Node(term, weight, i, n);
                    this.finishInsertion(n.left);
                    return;
                }
                n = n.left;
                continue;
            }
            if (term.charAt(i) > n.firstChar) {
                if (n.right == null) {
                    n.right = new Node(term, weight, i, n);
                    this.finishInsertion(n.right);
                    return;
                }
                n = n.right;
                continue;
            }
            while (++i < n.charEnd) {
                if (i != term.length() && term.charAt(i) == n.charAt(i)) continue;
                n = this.split(n, i);
                break;
            }
            if (i >= term.length()) break;
            if (n.mid == null) {
                n.mid = new Node(term, weight, i, n);
                this.finishInsertion(n.mid);
                return;
            }
            n = n.mid;
        }
        if (n.entry == null) {
            n.entry = new Entry(term, weight);
            this.finishInsertion(n);
        } else if (n.entry.weight < weight) {
            this.increaseWeight(n, weight);
        } else if (n.entry.weight > weight) {
            this.reduceWeight(n, weight);
        }
    }

    public void remove(String term) {
        Node p;
        Node n = this.search(term);
        if (n == null || n.entry == null || n.charEnd > term.length()) {
            return;
        }
        this.randomizeDeletion(n);
        Entry e = n.entry;
        n.entry = null;
        if (n.mid == null) {
            p = this.parent(n);
            this.delete(n);
            n = p;
        }
        if (n != null && n.entry == null && n.mid.left == null && n.mid.right == null) {
            p = this.parent(n);
            this.merge(n, n.mid);
            n = p;
        }
        this.removeFromLists(e, n);
        --this.size;
    }

    private Node search(String s) {
        if (s.isEmpty()) {
            throw new IllegalArgumentException();
        }
        short i = 0;
        Node n = this.root;
        while (n != null) {
            if (s.charAt(i) < n.firstChar) {
                n = n.left;
                continue;
            }
            if (s.charAt(i) > n.firstChar) {
                n = n.right;
                continue;
            }
            while (++i < n.charEnd) {
                if (i == s.length()) {
                    return n;
                }
                if (s.charAt(i) == n.charAt(i)) continue;
                return null;
            }
            if (i == s.length()) {
                return n;
            }
            n = n.mid;
        }
        return null;
    }

    private Node split(Node n, int position) {
        Node s = new Node(n, position);
        if (n.list.length == this.k) {
            Node.access$1202(s, Arrays.copyOf(n.list, this.k));
        } else {
            Node.access$1202(s, n.list);
        }
        if (n.left != null) {
            n.left.up = s;
        }
        if (n.right != null) {
            n.right.up = s;
        }
        if (n == this.root) {
            this.root = s;
        } else if (n == n.up.left) {
            n.up.left = s;
        } else if (n == n.up.right) {
            n.up.right = s;
        } else {
            n.up.mid = s;
        }
        n.firstChar = n.charAt(position);
        n.left = (n.right = null);
        n.up = s;
        return s;
    }

    private void merge(Node n, Node m) {
        m.firstChar = n.firstChar;
        m.left = n.left;
        m.right = n.right;
        m.up = n.up;
        if (n.left != null) {
            n.left.up = m;
        }
        if (n.right != null) {
            n.right.up = m;
        }
        if (n == this.root) {
            this.root = m;
        } else if (n == n.up.left) {
            n.up.left = m;
        } else if (n == n.up.right) {
            n.up.right = m;
        } else {
            n.up.mid = m;
        }
    }

    private void delete(Node n) {
        if (n == this.root) {
            this.root = null;
        } else if (n == n.up.left) {
            n.up.left = null;
        } else if (n == n.up.right) {
            n.up.right = null;
        } else {
            n.up.mid = null;
        }
    }

    private void finishInsertion(Node n) {
        this.randomizeInsertion(n);
        this.insertIntoLists(n);
        ++this.size;
    }

    private void randomizeInsertion(Node n) {
        n.entry.priority = this.random.nextInt();
        n.priority = this.higherPriority(n.entry, n.mid);
        while (n != this.root && n.up.priority < n.priority) {
            if (n == n.up.left) {
                this.rotateRight(n.up);
                continue;
            }
            if (n == n.up.right) {
                this.rotateLeft(n.up);
                continue;
            }
            n.up.priority = n.priority;
            n = n.up;
        }
    }

    private void randomizeDeletion(Node n) {
        int p = n.entry.priority;
        n.entry.priority = Integer.MIN_VALUE;
        while (n != null && n.priority == p) {
            n.priority = this.higherPriority(n.entry, n.mid);
            Node h = this.higherPriorityNode(n.left, n.right);
            while (h != null && h.priority >= n.priority) {
                if (h == n.left) {
                    this.rotateRight(n);
                } else {
                    this.rotateLeft(n);
                }
                h = this.higherPriorityNode(n.left, n.right);
            }
            n = this.parent(n);
        }
    }

    private int higherPriority(Entry e, Node n) {
        if (e == null) {
            return n.priority;
        }
        if (n == null) {
            return e.priority;
        }
        if (e.priority < n.priority) {
            return n.priority;
        }
        return e.priority;
    }

    private Node higherPriorityNode(Node n, Node m) {
        if (n == null) {
            return m;
        }
        if (m == null) {
            return n;
        }
        if (n.priority < m.priority) {
            return m;
        }
        return n;
    }

    private void rotateLeft(Node n) {
        Node r = n.right;
        n.right = r.left;
        if (r.left != null) {
            r.left.up = n;
        }
        r.up = n.up;
        if (n == this.root) {
            this.root = r;
        } else if (n == n.up.left) {
            n.up.left = r;
        } else if (n == n.up.right) {
            n.up.right = r;
        } else {
            n.up.mid = r;
        }
        r.left = n;
        n.up = r;
    }

    private void rotateRight(Node n) {
        Node l = n.left;
        n.left = l.right;
        if (l.right != null) {
            l.right.up = n;
        }
        l.up = n.up;
        if (n == this.root) {
            this.root = l;
        } else if (n == n.up.left) {
            n.up.left = l;
        } else if (n == n.up.right) {
            n.up.right = l;
        } else {
            n.up.mid = l;
        }
        l.right = n;
        n.up = l;
    }

    private void insertIntoLists(Node n) {
        Entry e = n.entry;
        while (n != null) {
            if (n.mid == null) {
                Node.access$1202(n, new Entry[1]);
            } else if (n.list.length < this.k) {
                Node.access$1202(n, Arrays.copyOf(n.list, n.list.length + 1));
            } else if (e.weight <= n.list[this.k - 1].weight) {
                return;
            }
            for (int i = n.list.length - 1; i > 0 && e.weight > n.list[i - 1].weight; --i) {
                ((Node)n).list[i] = n.list[i - 1];
            }
            ((Node)n).list[i] = e;
            n = this.parent(n);
        }
    }

    private void increaseWeight(Node n, int newWeight) {
        Entry e = n.entry;
        e.weight = newWeight;
        while (n != null) {
            int i = n.listIndexOf(e);
            if (i == -1) {
                if (e.weight <= n.list[this.k - 1].weight) {
                    return;
                }
                i = this.k - 1;
            }
            while (i > 0 && e.weight > n.list[i - 1].weight) {
                ((Node)n).list[i] = n.list[i - 1];
                --i;
            }
            ((Node)n).list[i] = e;
            n = this.parent(n);
        }
    }

    private void reduceWeight(Node n, int newWeight) {
        Entry e = n.entry;
        e.weight = newWeight;
        while (n != null) {
            Entry t;
            int i = n.listIndexOf(e);
            if (i == -1) {
                return;
            }
            while (i < n.list.length - 1 && e.weight < n.list[i + 1].weight) {
                ((Node)n).list[i] = n.list[i + 1];
                ++i;
            }
            ((Node)n).list[i] = e;
            if (i == this.k - 1 && (t = this.topUnlistedTerm(n)) != null && t.weight > e.weight) {
                ((Node)n).list[i] = t;
            }
            n = this.parent(n);
        }
    }

    private void removeFromLists(Entry e, Node n) {
        while (n != null) {
            int i = n.listIndexOf(e);
            if (i == -1) {
                return;
            }
            while (i < n.list.length - 1) {
                ((Node)n).list[i] = n.list[i + 1];
                ++i;
            }
            ((Node)n).list[i] = e;
            if (n.list.length < this.k) {
                Node.access$1202(n, Arrays.copyOf(n.list, n.list.length - 1));
            } else {
                Entry t = this.topUnlistedTerm(n);
                if (t == null) {
                    Node.access$1202(n, Arrays.copyOf(n.list, this.k - 1));
                } else {
                    ((Node)n).list[i] = t;
                }
            }
            n = this.parent(n);
        }
    }

    private Entry topUnlistedTerm(Node n) {
        Entry t = null;
        if (n.entry != null && n.listIndexOf(n.entry) == -1) {
            t = n.entry;
        }
        Node c = this.leftmostChild(n);
        while (c != null) {
            for (Entry e : c.list) {
                if (n.listIndexOf(e) != -1) continue;
                if (t != null && t.weight >= e.weight) break;
                t = e;
                break;
            }
            c = this.rightSibling(c);
        }
        return t;
    }

    private Node leftmostChild(Node n) {
        if ((n = n.mid) != null) {
            while (n.left != null) {
                n = n.left;
            }
        }
        return n;
    }

    private Node rightSibling(Node n) {
        if (n.right != null) {
            n = n.right;
            while (n.left != null) {
                n = n.left;
            }
            return n;
        }
        while (n == n.up.right) {
            n = n.up;
        }
        if (n == n.up.left) {
            return n.up;
        }
        return null;
    }

    private Node parent(Node n) {
        while (n != this.root && n != n.up.mid) {
            n = n.up;
        }
        return n.up;
    }

    public static class Entry {
        private final String term;
        private int weight;
        private int priority;

        private Entry(String term, int weight) {
            this.term = term;
            this.weight = weight;
        }

        public String getTerm() {
            return this.term;
        }

        public int getWeight() {
            return this.weight;
        }
    }

    public static class Node {
        private Entry[] list;
        private Entry entry;
        private char firstChar;
        private short charEnd;
        private int priority;
        private Node left;
        private Node mid;
        private Node right;
        private Node up;

        private Node(String term, int weight, int charStart, Node up) {
            this.entry = new Entry(term, weight);
            this.firstChar = term.charAt(charStart);
            this.charEnd = (short)term.length();
            this.right = null;
            this.mid = null;
            this.left = null;
            this.up = up;
        }

        private Node(Node n, int charEnd) {
            this.entry = null;
            this.firstChar = n.firstChar;
            this.charEnd = (short)charEnd;
            this.priority = n.priority;
            this.left = n.left;
            this.mid = n;
            this.right = n.right;
            this.up = n.up;
        }

        public Entry getSuggestion(int index) {
            return this.list[index];
        }

        public int listLength() {
            return this.list.length;
        }

        private char charAt(int index) {
            if (this.entry != null) {
                return this.entry.term.charAt(index);
            }
            return this.list[0].term.charAt(index);
        }

        private int listIndexOf(Entry e) {
            for (int i = 0; i < this.list.length; ++i) {
                if (this.list[i] != e) continue;
                return i;
            }
            return -1;
        }

        static /* synthetic */ Entry[] access$1202(Node x0, Entry[] x1) {
            x0.list = x1;
            return x1;
        }
    }

    public class Iterator {
        private Node next;

        private Iterator() {
            this.next = SuggestTree.this.root == null ? null : this.firstEntry(SuggestTree.this.root);
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Entry next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Entry e = this.next.entry;
            this.next = this.nextEntry(this.next);
            return e;
        }

        private Node firstEntry(Node n) {
            while (true) {
                if (n.left != null) {
                    n = n.left;
                    continue;
                }
                if (n.entry != null) break;
                n = n.mid;
            }
            return n;
        }

        private Node nextEntry(Node n) {
            if (n.mid != null) {
                return this.firstEntry(n.mid);
            }
            if (n.right != null) {
                return this.firstEntry(n.right);
            }
            while (n.up != null) {
                if (n == n.up.left) {
                    if (n.up.entry != null) {
                        return n.up;
                    }
                    return this.firstEntry(n.up.mid);
                }
                if (n == n.up.mid && n.up.right != null) {
                    return this.firstEntry(n.up.right);
                }
                n = n.up;
            }
            return null;
        }
    }
}

