/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.tools;

import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.locationtech.jts.util.Assert;

public class AttributeMapping {
    private List<String> aAttributeNames;
    private List<String> bAttributeNames;
    private List<String> aNewAttributeNames;
    private List<String> bNewAttributeNames;
    private FeatureSchema aSchema;
    private FeatureSchema bSchema;

    protected AttributeMapping() {
    }

    public AttributeMapping(FeatureSchema a, FeatureSchema b) {
        this.init(a, this.nonSpatialAttributeNames(a, null, null), this.nonSpatialAttributeNames(a, b, "_1"), b, this.nonSpatialAttributeNames(b, null, null), this.nonSpatialAttributeNames(b, a, "_2"));
    }

    public AttributeMapping(FeatureSchema aSchema, List<String> aAttributeNames, List<String> aNewAttributeNames, FeatureSchema bSchema, List<String> bAttributeNames, List<String> bNewAttributeNames) {
        this.init(aSchema, aAttributeNames, aNewAttributeNames, bSchema, bAttributeNames, bNewAttributeNames);
    }

    private List<String> nonSpatialAttributeNames(FeatureSchema schema, FeatureSchema other, String postfix) {
        ArrayList<String> attributeNames = new ArrayList<String>();
        for (int i = 0; i < schema.getAttributeCount(); ++i) {
            if (schema.getAttributeType(i) == AttributeType.GEOMETRY) continue;
            String attributeName = schema.getAttributeName(i);
            if (other != null && other.hasAttribute(attributeName)) {
                attributeName = attributeName + postfix;
            }
            attributeNames.add(attributeName);
        }
        return attributeNames;
    }

    private void init(FeatureSchema aSchema, List<String> aAttributeNames, List<String> aNewAttributeNames, FeatureSchema bSchema, List<String> bAttributeNames, List<String> bNewAttributeNames) {
        Assert.isTrue((boolean)this.isDisjoint(aNewAttributeNames, bNewAttributeNames));
        Assert.isTrue((aAttributeNames.size() == aNewAttributeNames.size() ? 1 : 0) != 0);
        Assert.isTrue((bAttributeNames.size() == bNewAttributeNames.size() ? 1 : 0) != 0);
        this.aSchema = aSchema;
        this.bSchema = bSchema;
        this.aAttributeNames = new ArrayList<String>(aAttributeNames);
        this.bAttributeNames = new ArrayList<String>(bAttributeNames);
        this.aNewAttributeNames = new ArrayList<String>(aNewAttributeNames);
        this.bNewAttributeNames = new ArrayList<String>(bNewAttributeNames);
    }

    public CombinedSchema createSchema(String geometryName) {
        CombinedSchema newSchema = new CombinedSchema();
        this.addAttributes(newSchema, this.aSchema, this.aAttributeNames, this.aNewAttributeNames, newSchema.aNewToOldAttributeIndexMap);
        newSchema.lastNewAttributeIndexForA = newSchema.getAttributeCount() - 1;
        this.addAttributes(newSchema, this.bSchema, this.bAttributeNames, this.bNewAttributeNames, newSchema.bNewToOldAttributeIndexMap);
        newSchema.addAttribute(geometryName, AttributeType.GEOMETRY);
        return newSchema;
    }

    private void addAttributes(FeatureSchema newSchema, FeatureSchema sourceSchema, List<String> attributeNames, List<String> newAttributeNames, Map<Integer, Integer> newToOldAttributeIndexMap) {
        for (int i = 0; i < attributeNames.size(); ++i) {
            String attributeName = attributeNames.get(i);
            String newAttributeName = newAttributeNames.get(i);
            AttributeType type = sourceSchema.getAttributeType(attributeName);
            if (type == AttributeType.GEOMETRY) continue;
            newSchema.addAttribute(newAttributeName, type);
            newToOldAttributeIndexMap.put(newSchema.getAttributeCount() - 1, i);
        }
    }

    protected boolean isDisjoint(Collection<String> a, Collection<String> b) {
        HashSet<String> c = new HashSet<String>();
        c.addAll(a);
        c.addAll(b);
        return c.size() == a.size() + b.size();
    }

    public void transferAttributes(Feature aFeature, Feature bFeature, Feature cFeature) {
        if (aFeature != null && cFeature != null) {
            this.transferAttributes(aFeature, cFeature, this.aAttributeNames, this.aNewAttributeNames);
        }
        if (bFeature != null && cFeature != null) {
            this.transferAttributes(bFeature, cFeature, this.bAttributeNames, this.bNewAttributeNames);
        }
    }

    private void transferAttributes(Feature source, Feature dest, List<String> attributeNames, List<String> newAttributeNames) {
        for (int i = 0; i < attributeNames.size(); ++i) {
            String attributeName = attributeNames.get(i);
            String newAttributeName = newAttributeNames.get(i);
            Assert.isTrue((source.getSchema().getAttributeType(attributeName) != AttributeType.GEOMETRY ? 1 : 0) != 0);
            dest.setAttribute(newAttributeName, source.getAttribute(attributeName));
        }
    }

    public static class CombinedSchema
    extends FeatureSchema {
        private static final long serialVersionUID = -8627306219650589202L;
        private Map<Integer, Integer> aNewToOldAttributeIndexMap = new HashMap<Integer, Integer>();
        private Map<Integer, Integer> bNewToOldAttributeIndexMap = new HashMap<Integer, Integer>();
        private int lastNewAttributeIndexForA;

        public int toAOldAttributeIndex(int newAttributeIndex) {
            return this.aNewToOldAttributeIndexMap.get(newAttributeIndex);
        }

        public int toBOldAttributeIndex(int newAttributeIndex) {
            return this.bNewToOldAttributeIndexMap.get(newAttributeIndex);
        }

        public boolean isFromA(int newAttributeIndex) {
            return newAttributeIndex <= this.lastNewAttributeIndexForA;
        }
    }
}

