/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.qa.diff;

import com.vividsolutions.jump.qa.diff.DiffGeometryMatcher;
import com.vividsolutions.jump.workbench.Logger;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.simplify.DouglasPeuckerSimplifier;

public class BufferGeometryMatcher
implements DiffGeometryMatcher {
    public static final double ERROR_TOLERANCE = 0.1;
    private static final boolean checkBoundary = false;
    private double tolerance;
    private Geometry queryGeom;
    private Geometry queryBuffer;
    private Geometry queryBoundary = null;
    private Geometry queryBoundaryBuffer = null;

    public static boolean isMatch(Geometry g1, Geometry g2, double tolerance) {
        BufferGeometryMatcher matcher = new BufferGeometryMatcher(tolerance);
        matcher.setQueryGeometry(g1);
        return matcher.isMatch(g2);
    }

    public static double maxOrthogonalDistance(Envelope env1, Envelope env2) {
        double deltaMaxY;
        double deltaMinY;
        double deltaMinX;
        double maxDist = deltaMinX = Math.abs(env1.getMinX() - env2.getMinX());
        double deltaMaxX = Math.abs(env1.getMaxX() - env2.getMaxX());
        if (deltaMaxX > maxDist) {
            maxDist = deltaMaxX;
        }
        if ((deltaMinY = Math.abs(env1.getMinY() - env2.getMinY())) > maxDist) {
            maxDist = deltaMinY;
        }
        if ((deltaMaxY = Math.abs(env1.getMaxY() - env2.getMaxY())) > maxDist) {
            maxDist = deltaMaxY;
        }
        return maxDist;
    }

    public BufferGeometryMatcher(double tolerance) {
        this.tolerance = tolerance;
    }

    @Override
    public void setQueryGeometry(Geometry geom) {
        this.queryGeom = geom;
        this.queryBuffer = this.checkedBuffer(geom);
    }

    @Override
    public Geometry getQueryGeometry() {
        return this.queryBuffer;
    }

    @Override
    public boolean isMatch(Geometry geom) {
        if (geom.getClass() != this.queryGeom.getClass()) {
            return false;
        }
        if (!this.isEnvelopeMatch(geom)) {
            return false;
        }
        boolean buffersMatch = this.isBufferMatch(geom);
        return buffersMatch;
    }

    private boolean isBufferMatch(Geometry geom) {
        Geometry buf = this.checkedBuffer(geom);
        boolean queryContains = this.queryBuffer.contains(geom);
        boolean queryIsContained = buf.contains(this.queryGeom);
        return queryContains && queryIsContained;
    }

    private boolean isBoundaryBufferMatch(Geometry geom) {
        Geometry boundary = geom.getBoundary();
        Geometry bndBuf = this.getBoundaryBuffer(geom);
        boolean queryContains = this.queryBoundaryBuffer.contains(boundary);
        boolean queryIsContained = bndBuf.contains(this.queryBoundary);
        return queryContains && queryIsContained;
    }

    private Geometry checkedBuffer(Geometry geom) {
        Geometry buf;
        try {
            buf = geom.buffer(this.tolerance);
        }
        catch (RuntimeException ex) {
            Logger.debug("Buffer error for geometry " + geom);
            buf = geom;
        }
        return buf;
    }

    private Geometry getBoundaryBuffer(Geometry geom) {
        double scaleFactor = 1.0 / (this.tolerance * 0.1);
        Geometry boundary = DouglasPeuckerSimplifier.simplify((Geometry)geom.getBoundary(), (double)scaleFactor);
        Geometry buf = this.checkedBuffer(boundary);
        if (buf.isEmpty()) {
            Logger.debug("Empty boundary buffer found");
            Logger.debug("geom: " + geom);
            Logger.debug("boundary: " + boundary);
        }
        return buf;
    }

    private boolean isEnvelopeMatch(Geometry geom) {
        double envDist = BufferGeometryMatcher.maxOrthogonalDistance(this.queryGeom.getEnvelopeInternal(), geom.getEnvelopeInternal());
        return envDist <= this.tolerance;
    }
}

