/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.io.geojson;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.coordsys.CoordinateSystem;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.io.AbstractJUMPReader;
import com.vividsolutions.jump.io.CompressedFile;
import com.vividsolutions.jump.io.DriverProperties;
import com.vividsolutions.jump.io.IllegalParametersException;
import com.vividsolutions.jump.io.geojson.GeoJSONFeatureCollectionWrapper;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.task.TaskMonitorUtil;
import com.vividsolutions.jump.util.FileUtil;
import com.vividsolutions.jump.util.Timer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.simple.JSONObject;
import org.json.simple.parser.ContentHandler;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class GeoJSONReader
extends AbstractJUMPReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FeatureCollection read(DriverProperties dp) throws Exception {
        GeoJSONFeatureCollectionWrapper fcwrap;
        block6: {
            String inputUri = dp.getProperty("Uri");
            if (inputUri == null) {
                throw new IllegalParametersException("call to GeoJSONReader.read() has DataProperties w/o an InputUri specified");
            }
            InputStream in = null;
            InputStreamReader inReader = null;
            BufferedReader bufReader = null;
            fcwrap = new GeoJSONFeatureCollectionWrapper();
            try {
                URI uri = new URI(inputUri);
                in = CompressedFile.openFile(uri);
                inReader = new InputStreamReader(in, "UTF-8");
                bufReader = new BufferedReader(inReader);
                Transformer t = new Transformer(fcwrap);
                new JSONParser().parse((Reader)bufReader, (ContentHandler)t);
                FileUtil.close(bufReader);
            }
            catch (Exception e) {
                this.addException(e);
                break block6;
            }
            finally {
                FileUtil.close(bufReader);
                FileUtil.close(inReader);
                FileUtil.close(in);
            }
            FileUtil.close(inReader);
            FileUtil.close(in);
        }
        return TaskMonitorUtil.isCancelRequested(this.getTaskMonitor()) ? null : fcwrap.getFeatureCollection();
    }

    class Transformer
    implements ContentHandler {
        private final GeoJSONFeatureCollectionWrapper fcwrap;
        private Stack valueStack;
        private Object featsId = null;
        private Object crsId = null;
        private long milliSeconds = 0L;
        final Pattern crsPattern = Pattern.compile(".*EPSG::?(\\d++).*");

        public Transformer(GeoJSONFeatureCollectionWrapper fcwrap) {
            this.fcwrap = fcwrap;
        }

        public Stack getResult() {
            if (this.valueStack == null || this.valueStack.size() == 0) {
                return null;
            }
            return this.valueStack;
        }

        private boolean notCancelled() {
            return !GeoJSONReader.this.getTaskMonitor().isCancelRequested();
        }

        private void addFeatures(List<Map> featureMapList) {
            TaskMonitor monitor = GeoJSONReader.this.getTaskMonitor();
            for (Map featureMap : featureMapList) {
                try {
                    this.fcwrap.add(featureMap);
                    long now = Timer.milliSecondsSince(0L);
                    if (now - 500L < this.milliSeconds) continue;
                    this.milliSeconds = now;
                    TaskMonitorUtil.report(monitor, I18N.getInstance().get("Reader.parsed-{0}-features", String.format("%,10d", this.fcwrap.size())));
                }
                catch (Exception e) {
                    GeoJSONReader.this.addException(new IOException(JSONObject.toJSONString((Map)featureMap), e));
                }
            }
        }

        private void trackBack() {
            if (this.valueStack.size() > 1) {
                Object value = this.valueStack.pop();
                Object prev = this.valueStack.peek();
                if (prev instanceof String) {
                    this.valueStack.push(value);
                }
            }
        }

        private void consumeValue(Object value) {
            if (this.valueStack.size() == 0) {
                this.valueStack.push(value);
            } else {
                Object prev = this.valueStack.peek();
                if (prev instanceof List) {
                    List array = (List)prev;
                    array.add(value);
                } else {
                    this.valueStack.push(value);
                }
            }
        }

        public boolean primitive(Object value) throws ParseException, IOException {
            this.consumeValue(value);
            return this.notCancelled();
        }

        public boolean startArray() throws ParseException, IOException {
            LinkedList array = new LinkedList();
            this.consumeValue(array);
            this.valueStack.push(array);
            return this.notCancelled();
        }

        public boolean endArray() throws ParseException, IOException {
            this.trackBack();
            return this.notCancelled();
        }

        public void startJSON() throws ParseException, IOException {
            this.milliSeconds = Timer.milliSecondsSince(0L);
            this.valueStack = new Stack();
        }

        public void endJSON() throws ParseException, IOException {
            for (Object object : this.valueStack) {
                List featureList = (List)((Map)object).get("features");
                this.addFeatures(featureList);
                featureList.clear();
            }
        }

        public boolean startObject() throws ParseException, IOException {
            if (this.crsId == null && this.valueStack.size() > 0 && this.valueStack.elementAt(this.valueStack.size() - 1).equals("crs")) {
                this.crsId = "crs";
            } else if (this.featsId == null && this.valueStack.size() > 2 && this.valueStack.elementAt(this.valueStack.size() - 3).equals("features")) {
                this.featsId = this.valueStack.elementAt(this.valueStack.size() - 3);
            }
            LinkedHashMap object = new LinkedHashMap();
            this.consumeValue(object);
            this.valueStack.push(object);
            return this.notCancelled();
        }

        public boolean endObject() throws ParseException, IOException {
            List featureList;
            Map crsObject;
            this.trackBack();
            if (this.crsId != null && this.valueStack.size() > 1 && this.valueStack.elementAt(this.valueStack.size() - 2).equals("crs") && (crsObject = (Map)this.valueStack.elementAt(this.valueStack.size() - 1)) != null) {
                int srid;
                Matcher m;
                String crsName;
                Map crsProperties = (Map)crsObject.get("properties");
                if (crsProperties != null && (crsName = (String)crsProperties.get("name")) != null && (m = this.crsPattern.matcher(crsName)).matches() && (srid = Integer.parseInt(m.group(1))) != 0) {
                    this.fcwrap.getFeatureCollection().getFeatureSchema().setCoordinateSystem(new CoordinateSystem(crsName, srid, null));
                }
                this.crsId = null;
            }
            if (this.featsId != null && this.valueStack.size() > 2 && this.valueStack.elementAt(this.valueStack.size() - 3) == this.featsId && (featureList = (List)this.valueStack.elementAt(this.valueStack.size() - 2)).size() >= 10) {
                this.addFeatures(featureList);
                featureList.clear();
            }
            return this.notCancelled();
        }

        public boolean startObjectEntry(String key) throws ParseException, IOException {
            this.valueStack.push(key);
            return this.notCancelled();
        }

        public boolean endObjectEntry() throws ParseException, IOException {
            Object value = this.valueStack.pop();
            Object key = this.valueStack.pop();
            Map parent = (Map)this.valueStack.peek();
            parent.put(key, value);
            return this.notCancelled();
        }
    }
}

