/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.io.datasource;

import com.vividsolutions.jump.coordsys.CoordinateSystem;
import com.vividsolutions.jump.coordsys.CoordinateSystemRegistry;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.io.datasource.Connection;
import java.util.HashMap;
import java.util.Map;

public abstract class DataSource {
    private Map<String, Object> properties;
    private boolean isDisabled = false;
    @Deprecated
    public static final String FILE_KEY = "File";
    public static final String URI_KEY = "Uri";
    public static final String COMPRESSED_KEY = "CompressedFile";
    public static final String CHARSET_KEY = "charset";
    public static final String COORDINATE_SYSTEM_REGISTRY = "SrsRegistry";
    public static final String COORDINATE_SYSTEM_CODE = "SrsCode";
    public static final String COORDINATE_SYSTEM_KEY = "Coordinate System";

    public void setProperties(Map<String, Object> properties) {
        this.properties = new HashMap<String, Object>(properties);
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public abstract Connection getConnection();

    public boolean isReadable() {
        return true;
    }

    public boolean isWritable() {
        return true;
    }

    public boolean isDisabled() {
        return this.isDisabled;
    }

    public void setDisabled(boolean onOff) {
        this.isDisabled = onOff;
    }

    public FeatureCollection installCoordinateSystem(FeatureCollection queryResult, CoordinateSystemRegistry registry) {
        String coordinateSystemName;
        if (queryResult == null) {
            return null;
        }
        try {
            coordinateSystemName = (String)this.getProperties().get(COORDINATE_SYSTEM_KEY);
        }
        catch (NullPointerException e) {
            return queryResult;
        }
        if (coordinateSystemName == null) {
            return queryResult;
        }
        CoordinateSystem coordinateSystem = registry.get(coordinateSystemName);
        if (coordinateSystem == null) {
            return queryResult;
        }
        queryResult.getFeatureSchema().setCoordinateSystem(coordinateSystem);
        return queryResult;
    }
}

