/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.feature;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.coordsys.CoordinateSystem;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Operation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.locationtech.jts.util.Assert;

public class FeatureSchema
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -8627306219650589202L;
    protected CoordinateSystem coordinateSystem = CoordinateSystem.UNSPECIFIED;
    protected Map<String, Integer> attributeNameToIndexMap = new HashMap<String, Integer>();
    protected int geometryIndex = -1;
    protected int externalPKIndex = -1;
    protected int attributeCount = 0;
    protected List<String> attributeNames = new ArrayList<String>();
    protected List<AttributeType> attributeTypes = new ArrayList<AttributeType>();
    protected List<Boolean> attributeReadOnly = new ArrayList<Boolean>();
    protected ArrayList<Operation> operations = new ArrayList();

    public FeatureSchema() {
    }

    public FeatureSchema(FeatureSchema fsIn) {
        FeatureSchema.cloneFromTo(fsIn, this);
    }

    public static void cloneFromTo(FeatureSchema fsIn, FeatureSchema fsOut) {
        for (int i = 0; i < fsIn.attributeCount; ++i) {
            AttributeType at = fsIn.attributeTypes.get(i);
            String aname = fsIn.attributeNames.get(i);
            fsOut.addAttribute(aname, at);
            fsOut.setAttributeReadOnly(i, fsIn.isAttributeReadOnly(i));
            fsOut.setOperation(i, fsIn.getOperation(i));
        }
        fsOut.setCoordinateSystem(fsIn.coordinateSystem);
    }

    public FeatureSchema clone() {
        FeatureSchema fsOut = new FeatureSchema();
        FeatureSchema.cloneFromTo(this, fsOut);
        return fsOut;
    }

    public int getAttributeIndex(String attributeName) {
        Integer index = this.attributeNameToIndexMap.get(attributeName);
        if (index == null) {
            throw new IllegalArgumentException(I18N.getInstance().get("feature.FeatureSchema.unrecognized-attribute-name") + " " + attributeName);
        }
        return index;
    }

    public boolean hasAttribute(String attributeName) {
        return this.attributeNameToIndexMap.get(attributeName) != null;
    }

    public int getGeometryIndex() {
        return this.geometryIndex;
    }

    public String getAttributeName(int attributeIndex) {
        return this.attributeNames.get(attributeIndex);
    }

    public AttributeType getAttributeType(int attributeIndex) {
        return this.attributeTypes.get(attributeIndex);
    }

    public AttributeType getAttributeType(String attributeName) {
        return this.getAttributeType(this.getAttributeIndex(attributeName));
    }

    public int getAttributeCount() {
        return this.attributeCount;
    }

    public List<String> getAttributeNames() {
        return Collections.unmodifiableList(this.attributeNames);
    }

    public void addAttribute(String attributeName, AttributeType attributeType) {
        if (AttributeType.GEOMETRY == attributeType) {
            if (this.geometryIndex != -1) {
                throw new IllegalArgumentException(I18N.getInstance().get("feature.FeatureSchema.only-one-geometry-is-authorized"));
            }
            this.geometryIndex = this.attributeCount;
        }
        if (this.attributeNames.contains(attributeName)) {
            throw new IllegalArgumentException(I18N.getInstance().get("feature.FeatureSchema.attribute-already-exists", attributeName));
        }
        this.attributeNames.add(attributeName);
        this.attributeNameToIndexMap.put(attributeName, this.attributeCount);
        this.attributeTypes.add(attributeType);
        this.attributeReadOnly.add(false);
        this.operations.add(null);
        ++this.attributeCount;
    }

    public void addDynamicAttribute(String attributeName, AttributeType attributeType, Operation operation) {
        Assert.isTrue((attributeType != AttributeType.GEOMETRY ? 1 : 0) != 0);
        this.attributeNames.add(attributeName);
        this.attributeNameToIndexMap.put(attributeName, this.attributeCount);
        this.attributeTypes.add(attributeType);
        this.attributeReadOnly.add(true);
        this.operations.add(operation);
        ++this.attributeCount;
    }

    public boolean equals(Object other) {
        return other instanceof FeatureSchema && this.equals(other, false);
    }

    public boolean equals(Object other, boolean orderMatters) {
        if (!(other instanceof FeatureSchema)) {
            return false;
        }
        FeatureSchema otherFeatureSchema = (FeatureSchema)other;
        if (this.attributeNames.size() != otherFeatureSchema.attributeNames.size()) {
            return false;
        }
        for (int i = 0; i < this.attributeNames.size(); ++i) {
            String attributeName = this.attributeNames.get(i);
            if (!otherFeatureSchema.attributeNames.contains(attributeName)) {
                return false;
            }
            if (orderMatters && !otherFeatureSchema.attributeNames.get(i).equals(attributeName)) {
                return false;
            }
            if (this.getAttributeType(attributeName) == otherFeatureSchema.getAttributeType(attributeName)) continue;
            return false;
        }
        return true;
    }

    public FeatureSchema setCoordinateSystem(CoordinateSystem coordinateSystem) {
        this.coordinateSystem = coordinateSystem;
        return this;
    }

    public CoordinateSystem getCoordinateSystem() {
        return this.coordinateSystem;
    }

    public boolean isAttributeReadOnly(int attributeIndex) {
        return this.attributeReadOnly.get(attributeIndex);
    }

    public void setAttributeReadOnly(int attributeIndex, boolean isReadOnly) {
        this.attributeReadOnly.set(attributeIndex, isReadOnly);
    }

    public boolean isOperation(int attributeIndex) {
        return attributeIndex >= 0 && this.operations.get(attributeIndex) != null;
    }

    public void setOperation(int attributeIndex, Operation operation) {
        this.operations.set(attributeIndex, operation);
    }

    public Operation getOperation(int attributeIndex) {
        return this.operations.get(attributeIndex);
    }

    public int getExternalPrimaryKeyIndex() {
        return this.externalPKIndex;
    }

    public void setExternalPrimaryKeyIndex(int index) {
        assert (index < this.getAttributeCount());
        AttributeType attributeType = this.getAttributeType(index);
        if (attributeType != AttributeType.INTEGER && attributeType != AttributeType.LONG && attributeType != AttributeType.STRING && attributeType != AttributeType.OBJECT) {
            throw new IllegalArgumentException("Primary Key must be of type String, Integer or Object");
        }
        this.externalPKIndex = index;
        this.setAttributeReadOnly(index, true);
    }

    public void removeExternalPrimaryKey() {
        this.externalPKIndex = -1;
    }

    public void addExternalPrimaryKey(String attributeName, AttributeType attributeType) {
        if (attributeType != AttributeType.INTEGER && attributeType != AttributeType.STRING && attributeType != AttributeType.OBJECT) {
            throw new IllegalArgumentException("Primary Key must be of type String, Integer or Object");
        }
        this.addAttribute(attributeName, attributeType);
        this.setAttributeReadOnly(this.getAttributeIndex(attributeName), true);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("FeatureSchema (").append(this.getCoordinateSystem()).append(")");
        for (int i = 0; i < this.getAttributeCount(); ++i) {
            if (this.geometryIndex == i) {
                sb.append("\n\tGeometry: ");
            } else if (this.externalPKIndex == i) {
                sb.append("\n\tExternalId: ");
            } else {
                sb.append("\n\t");
            }
            sb.append(this.getAttributeName(i)).append(" ").append(this.attributeTypes.get(i));
            if (this.operations.get(i) != null) {
                sb.append(" [operation]");
                continue;
            }
            if (!this.attributeReadOnly.get(i).booleanValue()) continue;
            sb.append(" [read only]");
        }
        return sb.toString();
    }
}

