/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.datastore.spatialdatabases;

import com.vividsolutions.jump.datastore.spatialdatabases.SpatialDatabasesResultSetConverter;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.io.BaseFeatureInputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class SpatialDatabasesFeatureInputStream
extends BaseFeatureInputStream {
    protected FeatureSchema featureSchema;
    protected Connection conn;
    protected String queryString;
    private boolean initialized = false;
    private Exception savedException;
    private Statement stmt = null;
    private ResultSet rs = null;
    private SpatialDatabasesResultSetConverter mapper;
    String externalIdentifier = null;

    public SpatialDatabasesFeatureInputStream(Connection conn, String queryString) {
        this(conn, queryString, null);
    }

    public SpatialDatabasesFeatureInputStream(Connection conn, String queryString, String externalIdentifier) {
        this.conn = conn;
        this.queryString = queryString;
        this.externalIdentifier = externalIdentifier;
    }

    public Connection getConnection() {
        return this.conn;
    }

    public String getQueryString() {
        return this.queryString;
    }

    protected SpatialDatabasesResultSetConverter getResultSetConverter(ResultSet rs) {
        return new SpatialDatabasesResultSetConverter(this.conn, rs);
    }

    public Statement getStatement() {
        return this.stmt;
    }

    private void init() throws SQLException {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.stmt = this.conn.createStatement();
        String parsedQuery = this.queryString;
        try {
            this.rs = this.stmt.executeQuery(parsedQuery);
        }
        catch (SQLException e) {
            e.setNextException(new SQLException("Invalid query: " + this.queryString));
            throw e;
        }
        this.mapper = this.getResultSetConverter(this.rs);
        this.featureSchema = this.mapper.getFeatureSchema();
        if (this.externalIdentifier != null) {
            this.featureSchema.setExternalPrimaryKeyIndex(this.featureSchema.getAttributeIndex(this.externalIdentifier));
        }
    }

    @Override
    protected Feature readNext() throws Exception {
        if (this.savedException != null) {
            throw this.savedException;
        }
        if (!this.initialized) {
            this.init();
        }
        if (this.rs == null) {
            return null;
        }
        if (!this.rs.next()) {
            return null;
        }
        return this.getFeature();
    }

    private Feature getFeature() throws Exception {
        return this.mapper.getFeature();
    }

    @Override
    public void close() throws SQLException {
        if (this.rs != null) {
            this.rs.close();
        }
        if (this.stmt != null) {
            this.stmt.close();
        }
    }

    @Override
    public FeatureSchema getFeatureSchema() {
        if (this.featureSchema != null) {
            return this.featureSchema;
        }
        try {
            this.init();
        }
        catch (SQLException ex) {
            String message = ex.getLocalizedMessage();
            SQLException nextT = ex.getNextException();
            if (nextT != null) {
                message = message + "\n" + nextT.getLocalizedMessage();
            }
            throw new Error(message, ex);
        }
        if (this.featureSchema == null) {
            this.featureSchema = new FeatureSchema();
        }
        return this.featureSchema;
    }
}

