/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.datastore.spatialdatabases;

import com.vividsolutions.jump.JUMPException;
import com.vividsolutions.jump.datastore.DataStoreConnection;
import com.vividsolutions.jump.datastore.DataStoreDriver;
import com.vividsolutions.jump.datastore.jdbc.DelegatingDriver;
import com.vividsolutions.jump.parameter.ParameterList;
import com.vividsolutions.jump.parameter.ParameterListSchema;
import com.vividsolutions.jump.workbench.Logger;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;

public abstract class AbstractSpatialDatabasesDSDriver
implements DataStoreDriver {
    public static final String PARAM_Server = "Server";
    public static final String PARAM_Port = "Port";
    public static final String PARAM_Instance = "Database";
    public static final String PARAM_User = "User";
    public static final String PARAM_Password = "Password";
    public static final String PARAM_DB_File = "DB file";
    protected String driverName = null;
    protected String jdbcClass = null;
    protected Driver jdbcDriver = null;
    protected String urlPrefix = null;
    protected String[] paramNames = new String[]{"Server", "Port", "Database", "User", "Password"};
    protected Class[] paramClasses = new Class[]{String.class, Integer.class, String.class, String.class, String.class};
    protected ParameterListSchema schema = new ParameterListSchema(this.paramNames, this.paramClasses);

    @Override
    public Driver getJdbcDriver() {
        if (this.jdbcDriver == null) {
            try {
                this.initializeJdbcDriver();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.jdbcDriver;
    }

    @Override
    public String getJdbcDriverVersion() {
        if (this.jdbcDriver == null) {
            try {
                this.initializeJdbcDriver();
            }
            catch (Exception e) {
                return "";
            }
        }
        return this.jdbcDriver.getMajorVersion() + "." + this.jdbcDriver.getMinorVersion();
    }

    public String getJdbcClass() {
        return this.jdbcClass;
    }

    public String getUrlPrefix() {
        return this.urlPrefix;
    }

    public String[] getParamNames() {
        return this.paramNames;
    }

    public Class[] getParamClasses() {
        return this.paramClasses;
    }

    public ParameterListSchema getSchema() {
        return this.schema;
    }

    @Override
    public String getName() {
        return this.driverName;
    }

    @Override
    public String getVersion() {
        return this.getJdbcClass() + " v" + this.getJdbcDriverVersion();
    }

    @Override
    public ParameterListSchema getParameterListSchema() {
        return this.schema;
    }

    protected void initializeJdbcDriver() throws SQLException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        this.jdbcDriver = (Driver)Class.forName(this.getJdbcClass()).newInstance();
        DriverManager.registerDriver(new DelegatingDriver(this.jdbcDriver));
    }

    protected String createJdbcUrl(ParameterList params) {
        String url;
        if (params.containsParameter(PARAM_DB_File)) {
            String database = params.getParameter(PARAM_DB_File).toString();
            url = String.valueOf(new StringBuffer(this.getUrlPrefix()).append(database));
        } else {
            String host = params.getParameterString(PARAM_Server);
            int port = params.getParameterInt(PARAM_Port);
            String database = params.getParameterString(PARAM_Instance);
            url = String.valueOf(new StringBuffer(this.getUrlPrefix()).append(host).append(":").append(port).append("/").append(database));
        }
        return url;
    }

    protected Connection createJdbcConnection(ParameterList params) throws Exception {
        return this.createJdbcConnection(params, null);
    }

    protected Connection createJdbcConnection(ParameterList params, Properties connProps) throws Exception {
        String url = this.createJdbcUrl(params);
        Logger.debug("Target database URL : " + url);
        if (this.jdbcDriver == null) {
            this.initializeJdbcDriver();
        }
        Driver driver = null;
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver d = drivers.nextElement();
            if (d instanceof DelegatingDriver) {
                d = ((DelegatingDriver)d).getDriver();
            }
            if (!d.getClass().getName().equals(this.getJdbcClass())) continue;
            driver = d;
            break;
        }
        if (driver == null) {
            throw new JUMPException(this.getJdbcClass() + " is not registered with driver manager.");
        }
        String user = params.getParameterString(PARAM_User);
        String password = params.getParameterString(PARAM_Password);
        Properties info = (Properties)connProps.clone();
        if (user != null) {
            info.put("user", user);
        }
        if (password != null) {
            info.put("password", password);
        }
        Logger.debug("java.net.preferIPv4Stack=" + System.getProperty("java.net.preferIPv4Stack"));
        Logger.debug("java.net.preferIPv6Addresses=" + System.getProperty("java.net.preferIPv6Addresses"));
        Connection conn = driver.connect(url, info);
        return conn;
    }

    @Override
    public abstract DataStoreConnection createConnection(ParameterList var1) throws Exception;

    @Override
    public boolean isAdHocQuerySupported() {
        return true;
    }
}

