/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.datastore.mariadb;

import com.vividsolutions.jump.datastore.DataStoreLayer;
import com.vividsolutions.jump.datastore.FilterQuery;
import com.vividsolutions.jump.datastore.SpatialReferenceSystemID;
import com.vividsolutions.jump.datastore.spatialdatabases.SpatialDatabasesDSMetadata;
import com.vividsolutions.jump.datastore.spatialdatabases.SpatialDatabasesSQLBuilder;
import org.locationtech.jts.geom.Envelope;

public class MariadbSQLBuilder
extends SpatialDatabasesSQLBuilder {
    public MariadbSQLBuilder(SpatialDatabasesDSMetadata dsMetadata, SpatialReferenceSystemID defaultSRID, String[] colNames) {
        super(dsMetadata, defaultSRID, colNames);
    }

    @Override
    public String getSQL(FilterQuery query) {
        int limit;
        StringBuilder qs = new StringBuilder();
        qs.append("SELECT ");
        qs.append(this.getColumnListSpecifier(this.colNames, query.getGeometryAttributeName()));
        qs.append(" FROM ").append(query.getDatasetName()).append("");
        qs.append(" t WHERE ");
        qs.append(this.buildBoxFilter(query));
        String whereCond = query.getCondition();
        if (whereCond != null) {
            qs.append(" AND ");
            qs.append(whereCond);
        }
        if ((limit = query.getLimit()) != 0 && limit != Integer.MAX_VALUE) {
            qs.append(" LIMIT ").append(limit);
        }
        return qs.toString();
    }

    @Override
    public String getCheckSQL(DataStoreLayer dsLayer) {
        String s = "select * FROM %s %s LIMIT 0";
        String wc = dsLayer.getWhereClause();
        wc = wc != null && !wc.isEmpty() ? " WHERE " + wc : "";
        return String.format(s, dsLayer.getFullName(), wc);
    }

    @Override
    protected String getColumnListSpecifier(String[] colNames, String geomColName) {
        StringBuilder buf = new StringBuilder();
        buf.append(geomColName);
        for (String colName : colNames) {
            if (geomColName.equalsIgnoreCase(colName)) continue;
            buf.append(",").append(colName).append("");
        }
        return buf.toString();
    }

    @Override
    protected String buildBoxFilter(FilterQuery query) {
        Envelope env = query.getFilterGeometry().getEnvelopeInternal();
        String s = this.defaultSRID == null ? "0" : this.defaultSRID.getString();
        StringBuilder buf = new StringBuilder();
        buf.append("st_intersects(").append(query.getGeometryAttributeName()).append(", st_polygonFromText('POLYGON((");
        buf.append(env.getMinX()).append(" ").append(env.getMinY()).append(",").append(env.getMaxX()).append(" ").append(env.getMinY()).append(",").append(env.getMaxX()).append(" ").append(env.getMaxY()).append(",").append(env.getMinX()).append(" ").append(env.getMaxY()).append(",").append(env.getMinX()).append(" ").append(env.getMinY());
        buf.append("))', ").append(s).append("))");
        return buf.toString();
    }
}

