/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.datastore.mariadb;

import com.vividsolutions.jump.datastore.DataStoreConnection;
import com.vividsolutions.jump.datastore.GeometryColumn;
import com.vividsolutions.jump.datastore.SQLUtil;
import com.vividsolutions.jump.datastore.mariadb.GeometryColumnsLayout;
import com.vividsolutions.jump.datastore.spatialdatabases.SpatialDatabasesDSMetadata;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.List;

public class MariadbDSMetadata
extends SpatialDatabasesDSMetadata {
    public static String GC_COLUMN_NAME = "geometry_columns";
    private String geoColumnsQuery2;
    private String sridQuery2;
    private GeometryColumnsLayout geometryColumnsLayout;

    public MariadbDSMetadata(DataStoreConnection con) {
        this.conn = con;
        this.setGeoColLayout();
        this.defaultSchemaName = "";
        this.datasetNameQuery = "SELECT DISTINCT '' as f_table_schema, f_table_name FROM geometry_columns";
        if (this.geometryColumnsLayout == GeometryColumnsLayout.NO_LAYOUT) {
            this.datasetNameQuery = "select distinct t.TABLE_SCHEMA, t.TABLE_NAME \nfrom information_schema.TABLES t join information_schema.COLUMNS C \n  on t.TABLE_NAME = c.TABLE_NAME and t.TABLE_SCHEMA = c.TABLE_SCHEMA\nwhere t.TABLE_TYPE not in ('SYSTEM VIEW')\nand c.COLUMN_TYPE = 'geometry'";
        }
        this.spatialDbName = "MariaDB/MySQL";
        this.spatialExtentQuery2 = this.spatialExtentQuery1 = "select st_asbinary(st_geomfromtext(concat('POLYGON((', minx, ' ', miny, ', ',\n              maxx, ' ', miny, ', ',\n              maxx, ' ', maxy, ', ',\n              minx, ' ', maxy, ', ',\n              minx, ' ', miny, '))'))) as geom\nfrom (\n  SELECT\n    min(st_x(st_pointN(geom, 1))) AS minx,\n    min(st_y(st_pointN(geom, 1))) AS miny,\n    max(st_x(st_pointN(geom, 3))) AS maxx,\n    max(st_y(st_pointN(geom, 3))) AS maxy\n  FROM (\n         SELECT st_ExteriorRing(st_envelope(%s)) AS geom\n         FROM %s.%s\n       ) AS t\n) as t2";
        this.geoColumnsQuery = "SELECT f_geometry_column, coord_dimension, srid, type FROM geometry_columns where f_table_name = '%s'";
        if (this.geometryColumnsLayout == GeometryColumnsLayout.NO_LAYOUT) {
            this.geoColumnsQuery = "select c.COLUMN_NAME, 2, 0, 'geometry' \nfrom information_schema.TABLES t join information_schema.COLUMNS C \n  on t.TABLE_NAME = c.TABLE_NAME and t.TABLE_SCHEMA = c.TABLE_SCHEMA\nwhere t.TABLE_TYPE not in ('SYSTEM VIEW')\nand t.TABLE_SCHEMA = '%s' and t.TABLE_NAME = '%s'\nand c.COLUMN_TYPE = 'geometry'";
        }
        this.sridQuery = "SELECT srid FROM geometry_columns where f_table_name = '%s' and f_geometry_column = '%s'";
        if (this.geometryColumnsLayout == GeometryColumnsLayout.NO_LAYOUT) {
            this.sridQuery2 = "select case when min(st_srid(%s)) <> max(st_srid(%s)) then 0 else min(st_srid(%s)) end as srid\nfrom `%s`.`%s`";
        }
        this.coordDimQuery = "SELECT coord_dimension FROM geometry_columns where f_table_name = '%s' and f_geometry_column = '%s'";
        if (this.geometryColumnsLayout == GeometryColumnsLayout.NO_LAYOUT) {
            this.coordDimQuery = "select 2 as coord_dimension";
        }
        this.datasetInfoQuery = "SELECT '' as f_table_schema, f_table_name, f_geometry_column, coord_dimension, srid, type FROM geometry_columns";
        if (this.geometryColumnsLayout == GeometryColumnsLayout.NO_LAYOUT) {
            this.datasetInfoQuery = "select t.TABLE_SCHEMA, t.TABLE_NAME, c.COLUMN_NAME, 2, 0, 'geometry' \nfrom information_schema.TABLES t join information_schema.COLUMNS C \n  on t.TABLE_NAME = c.TABLE_NAME and t.TABLE_SCHEMA = c.TABLE_SCHEMA\nwhere t.TABLE_TYPE not in ('SYSTEM VIEW')\nand c.COLUMN_TYPE = 'geometry'";
        }
    }

    @Override
    public String getSpatialExtentQuery1(String schema, String table, String attributeName) {
        return String.format(this.spatialExtentQuery1, attributeName, schema, table);
    }

    @Override
    public String getSpatialExtentQuery2(String schema, String table, String attributeName) {
        return String.format(this.spatialExtentQuery2, attributeName, schema, table);
    }

    @Override
    public String getGeoColumnsQuery(String datasetName) {
        return String.format(this.geoColumnsQuery, SQLUtil.escapeSingleQuote(this.getTableName(datasetName)));
    }

    public String getGeoColumnsQuery2(String datasetName) {
        return String.format(this.geoColumnsQuery2, this.getSchemaName(datasetName), this.getTableName(datasetName));
    }

    @Override
    public String getSridQuery(String schemaName, String tableName, String colName) {
        return String.format(this.sridQuery, SQLUtil.escapeSingleQuote(tableName), colName);
    }

    public String getSridQuery2(String schemaName, String tableName, String colName) {
        return String.format(this.sridQuery2, colName, colName, colName, SQLUtil.escapeSingleQuote(schemaName), SQLUtil.escapeSingleQuote(tableName));
    }

    @Override
    public List<GeometryColumn> getGeometryAttributes(String datasetName) {
        String sql = this.getGeoColumnsQuery(datasetName);
        return this.getGeometryAttributes(sql, datasetName);
    }

    private void setGeoColLayout() {
        try {
            DatabaseMetaData dbMd = this.conn.getJdbcConnection().getMetaData();
            ResultSet rs = dbMd.getTables(null, null, GC_COLUMN_NAME, null);
            if (rs.next()) {
                this.geometryColumnsLayout = GeometryColumnsLayout.OGC_LAYOUT;
                rs.close();
            } else {
                this.geometryColumnsLayout = GeometryColumnsLayout.NO_LAYOUT;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

