/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.datastore;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.datastore.GeometryColumn;

public class DataStoreLayer {
    private String fullName;
    private String name;
    private GeometryColumn geoCol;
    private String where;
    private String schema;
    private int limit;
    private Boolean caching;

    public DataStoreLayer(String fName, GeometryColumn geoCol) {
        this.fullName = fName;
        this.geoCol = geoCol;
        this.limit = 0;
        this.caching = true;
        this.where = "";
        this.schema = I18N.getInstance().get("jump.workbench.ui.plugin.datastore.AddDatastoreLayerPanel.Default");
        String[] a = this.fullName.split("\\.");
        if (a.length == 1) {
            this.name = this.fullName;
        } else {
            this.schema = a[0];
            this.name = a[1];
        }
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.fullName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public GeometryColumn getGeoCol() {
        return this.geoCol;
    }

    public void setGeoCol(GeometryColumn geoCol) {
        this.geoCol = geoCol;
    }

    public String getWhere() {
        return this.where;
    }

    public String getWhereClause() {
        return this.where.trim().toLowerCase().startsWith("where") ? this.where.trim().substring("where".length()).trim() : this.where.trim();
    }

    public void setWhere(String where) {
        this.where = where;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public Boolean isCaching() {
        return this.caching;
    }

    public void setCaching(Boolean caching) {
        this.caching = caching;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String toString() {
        return this.getFullName();
    }
}

