/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jump.coordsys.impl;

import com.vividsolutions.jump.coordsys.Geographic;
import com.vividsolutions.jump.coordsys.Planar;
import com.vividsolutions.jump.coordsys.Projection;
import com.vividsolutions.jump.coordsys.Spheroid;
import com.vividsolutions.jump.coordsys.impl.TransverseMercator;
import org.locationtech.jts.util.Assert;

public class UniversalTransverseMercator
extends Projection {
    private static final double SCALE_FACTOR = 0.9996;
    private static final double FALSE_EASTING = 500000.0;
    private static final double FALSE_NORTHING = 0.0;
    private TransverseMercator transverseMercator = new TransverseMercator();
    private int zone = -1;

    public void setParameters(int zone) {
        Assert.isTrue((zone >= 7 ? 1 : 0) != 0, (String)("UTM zone " + zone + " not supported"));
        Assert.isTrue((zone <= 11 ? 1 : 0) != 0, (String)("UTM zone " + zone + " not supported"));
        switch (zone) {
            case 7: {
                this.transverseMercator.setParameters(-141.0);
                break;
            }
            case 8: {
                this.transverseMercator.setParameters(-135.0);
                break;
            }
            case 9: {
                this.transverseMercator.setParameters(-129.0);
                break;
            }
            case 10: {
                this.transverseMercator.setParameters(-123.0);
                break;
            }
            case 11: {
                this.transverseMercator.setParameters(-117.0);
                break;
            }
            case 12: {
                this.transverseMercator.setParameters(-111.0);
                break;
            }
            default: {
                Assert.shouldNeverReachHere();
            }
        }
        this.zone = zone;
    }

    @Override
    public void setSpheroid(Spheroid s) {
        this.transverseMercator.setSpheroid(s);
    }

    @Override
    public Geographic asGeographic(Planar p, Geographic q) {
        Assert.isTrue((this.zone != -1 ? 1 : 0) != 0, (String)"Call #setParameters first");
        p.x = (p.x - 500000.0) / 0.9996;
        p.y = (p.y - 0.0) / 0.9996;
        this.transverseMercator.asGeographic(p, q);
        return q;
    }

    @Override
    public Planar asPlanar(Geographic q0, Planar p) {
        Assert.isTrue((this.zone != -1 ? 1 : 0) != 0, (String)"Call #setParameters first");
        this.transverseMercator.asPlanar(q0, p);
        p.x = 0.9996 * p.x + 500000.0;
        p.y = 0.9996 * p.y + 0.0;
        return p;
    }
}

