/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.util;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.ui.network.ProxySettingsOptionsPanel;
import com.vividsolutions.wms.WMSException;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.apache.commons.codec.binary.Base64;
import org.openjump.util.UriUtil;

public class URLConnectionProvider {
    public static String KEY = URLConnectionProvider.class.getName() + " - UNCERTIFIED_AUTHORIZED_URL";
    private static Set<URL> trustedURLs = new HashSet<URL>();
    public static URLConnectionProvider instance;
    private TrustManager trm = new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    };

    private URLConnectionProvider() {
    }

    public static URLConnectionProvider getInstance() {
        if (instance == null) {
            instance = new URLConnectionProvider();
        }
        return instance;
    }

    public HttpURLConnection getHttpConnection(URL url, boolean followRedirects) throws IOException {
        HttpURLConnection connection = this.getHttpConnection(url);
        connection.setInstanceFollowRedirects(false);
        int numRedirects = 0;
        URL prev = null;
        URL next = connection.getURL();
        block3: while (followRedirects && !next.equals(prev)) {
            if (++numRedirects >= 20) {
                throw new WMSException("To many redirects (" + numRedirects + ") for Url: " + url);
            }
            connection = this.getHttpConnection(next);
            connection.setInstanceFollowRedirects(false);
            switch (connection.getResponseCode()) {
                case 301: 
                case 302: {
                    String location = connection.getHeaderField("Location");
                    location = URLDecoder.decode(location, "UTF-8");
                    prev = connection.getURL();
                    next = new URL(prev, location);
                    Logger.warn("Follow http redirect to: " + next);
                    continue block3;
                }
            }
            break;
        }
        return connection;
    }

    @Deprecated
    public URLConnection getConnection(URL url) throws IOException {
        return this.getHttpConnection(url, true);
    }

    public HttpURLConnection getHttpConnection(URL url) throws IOException {
        String protocol = url.getProtocol();
        if (!protocol.matches("^(?i:https?)$")) {
            throw new IOException("Please provide an http(s):// url.");
        }
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection = this.applyParametersAndSettings(connection);
        URL baseURL = new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getPath());
        try {
            this.setTrustOption(false, baseURL);
            connection.connect();
            return connection;
        }
        catch (GeneralSecurityException | SSLException e) {
            if (this.isTrusted(baseURL) || this.askIfUserAllowsInvalidCertificate(baseURL)) {
                try {
                    this.setTrustOption(true, baseURL);
                    connection = (HttpURLConnection)url.openConnection();
                    connection = this.applyParametersAndSettings(connection);
                    return connection;
                }
                catch (GeneralSecurityException ex2) {
                    throw new IOException(ex2);
                }
            }
            throw new IOException(e);
        }
    }

    private HttpURLConnection applyParametersAndSettings(HttpURLConnection connection) {
        String userInfo = connection.getURL().getUserInfo();
        if (userInfo != null) {
            byte[] userInfoBytes = UriUtil.urlDecode(userInfo).getBytes(StandardCharsets.UTF_8);
            String auth = Base64.encodeBase64String((byte[])userInfoBytes);
            connection.setRequestProperty("Authorization", "Basic " + auth);
            Logger.trace("Added auth header 'Authorization: Basic " + auth + "'");
        }
        connection.setConnectTimeout(Integer.parseInt(ProxySettingsOptionsPanel.getInstance().getSetting(ProxySettingsOptionsPanel.OPEN_TIMEOUT_KEY).toString()));
        connection.setReadTimeout(Integer.parseInt(ProxySettingsOptionsPanel.getInstance().getSetting(ProxySettingsOptionsPanel.READ_TIMEOUT_KEY).toString()));
        return connection;
    }

    private boolean askIfUserAllowsInvalidCertificate(URL url) {
        String text = I18N.getInstance().get("com.vididsolutions.wms.WMService.UnverifiedCertificate", UriUtil.urlStripPassword(url.toString()));
        final JEditorPane textPane = new JEditorPane("text/plain", text){

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return true;
            }
        };
        textPane.setSize(new Dimension(400, 10));
        textPane.setPreferredSize(new Dimension(400, textPane.getPreferredSize().height));
        textPane.setBackground(new JOptionPane().getBackground());
        textPane.setBorder(null);
        JScrollPane scrollPane = new JScrollPane(textPane);
        scrollPane.setBorder(null);
        textPane.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                Window window = SwingUtilities.getWindowAncestor(textPane);
                if (window instanceof Dialog) {
                    Dialog dialog = (Dialog)window;
                    if (!dialog.isResizable()) {
                        dialog.setResizable(true);
                    }
                    BufferedImage img = new BufferedImage(1, 1, 3);
                    dialog.setIconImage(img);
                    dialog.pack();
                }
            }
        });
        int r = JOptionPane.showConfirmDialog(null, scrollPane, "Confirmation dialog", 0, 2);
        return r == 0;
    }

    private void setTrustOption(boolean trust, URL url) throws GeneralSecurityException {
        String host;
        SSLContext sc = SSLContext.getInstance("SSL");
        String string = host = url != null ? url.getHost() : "";
        if (trust || url != null && trustedURLs.contains(url)) {
            Logger.info("Certificate verification for trusted host '" + host + "' is disabled'");
            sc.init(null, new TrustManager[]{this.trm}, null);
            trustedURLs.add(url);
        } else {
            Logger.debug("Using the system trust manager to verify certificate for host '" + host + "'.");
            sc.init(null, null, null);
        }
        HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
    }

    private boolean isTrusted(URL url) {
        return trustedURLs.contains(url);
    }
}

