/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.util;

import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEventType;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import it.betastudio.adbtoolbox.libs.FileOperations;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.swing.JFileChooser;
import org.openjump.core.ui.io.file.FileNameExtensionFilter;

public class FeatureSchemaUtils {
    static final String EXTENSION = "schema";
    public static String GetSavedFileName;

    public static boolean saveSchema(Layer layer) throws Exception {
        String schemaString = "";
        GUIUtil.FileChooserWithOverwritePrompting chooser = new GUIUtil.FileChooserWithOverwritePrompting();
        chooser.setFileSelectionMode(0);
        chooser.setDialogType(1);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Layer schema", EXTENSION);
        chooser.setFileFilter(filter);
        File file = null;
        String ext = EXTENSION;
        int ret = chooser.showSaveDialog(JUMPWorkbench.getInstance().getFrame());
        if (ret == 0) {
            file = ((JFileChooser)chooser).getSelectedFile();
            String fileName = file.getAbsolutePath();
            if (!fileName.endsWith(".schema")) {
                fileName = fileName + "." + EXTENSION;
            }
            FileOperations.setFile(file);
            File filePrintfFormateStats = new File(fileName);
            GetSavedFileName = filePrintfFormateStats.getAbsolutePath();
            PrintWriter pWriter = new PrintWriter(new FileOutputStream(filePrintfFormateStats));
            FeatureSchema featureSchema = layer.getFeatureCollectionWrapper().getFeatureSchema();
            int numAttributes = featureSchema.getAttributeCount();
            for (int index = 0; index < numAttributes; ++index) {
                String name = featureSchema.getAttributeName(index);
                AttributeType type = featureSchema.getAttributeType(index);
                schemaString = name + "\t" + type;
                pWriter.println(schemaString.trim());
            }
            pWriter.close();
        }
        return true;
    }

    private static String readFile(String filePath) {
        StringBuilder contentBuilder = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new FileReader(filePath));){
            String sCurrentLine;
            while ((sCurrentLine = br.readLine()) != null) {
                contentBuilder.append(sCurrentLine).append("\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return contentBuilder.toString();
    }

    public static boolean loadSchema(Layer layer) throws Exception {
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Layer schema", EXTENSION);
        JFileChooser chooser = new JFileChooser();
        chooser.setFileFilter(filter);
        chooser.addChoosableFileFilter(filter);
        chooser.setFileSelectionMode(0);
        chooser.setDialogType(0);
        int result = chooser.showOpenDialog(JUMPWorkbench.getInstance().getFrame());
        String schemaString = "";
        File file = null;
        if (result == 0) {
            AttributeType type;
            boolean isSchema;
            file = chooser.getSelectedFile();
            schemaString = FeatureSchemaUtils.readFile(file.getAbsolutePath());
            FeatureSchema featureSchema = new FeatureSchema();
            boolean bl = isSchema = schemaString.length() > 0;
            if (isSchema) {
                boolean endOfString;
                int tabIndex = schemaString.indexOf("\t");
                int crIndex = schemaString.indexOf("\n");
                boolean bl2 = endOfString = tabIndex < 0 || crIndex < 0;
                while (!endOfString) {
                    String name = schemaString.substring(0, tabIndex);
                    String typeStr = schemaString.substring(tabIndex + 1, crIndex);
                    type = AttributeType.STRING;
                    if (typeStr.compareToIgnoreCase("STRING") == 0) {
                        type = AttributeType.STRING;
                    } else if (typeStr.compareToIgnoreCase("DOUBLE") == 0) {
                        type = AttributeType.DOUBLE;
                    } else if (typeStr.compareToIgnoreCase("INTEGER") == 0) {
                        type = AttributeType.INTEGER;
                    } else if (typeStr.compareToIgnoreCase("DATE") == 0) {
                        type = AttributeType.DATE;
                    } else if (typeStr.compareToIgnoreCase("GEOMETRY") == 0) {
                        type = AttributeType.GEOMETRY;
                    } else if (typeStr.compareToIgnoreCase("OBJECT") == 0) {
                        type = AttributeType.OBJECT;
                    } else if (typeStr.compareToIgnoreCase("BOOLEAN") == 0) {
                        type = AttributeType.BOOLEAN;
                    } else if (typeStr.compareToIgnoreCase("LONG") == 0) {
                        type = AttributeType.LONG;
                    } else {
                        isSchema = false;
                        break;
                    }
                    featureSchema.addAttribute(name, type);
                    schemaString = schemaString.substring(crIndex + 1);
                    tabIndex = schemaString.indexOf("\t");
                    crIndex = schemaString.indexOf("\n");
                    endOfString = tabIndex < 0 || crIndex < 0;
                }
                boolean bl3 = isSchema = featureSchema.getAttributeCount() > 0;
            }
            if (isSchema) {
                FeatureSchema layerSchema = layer.getFeatureCollectionWrapper().getFeatureSchema();
                int numAttributes = featureSchema.getAttributeCount();
                boolean changedSchema = false;
                for (int index = 0; index < numAttributes; ++index) {
                    String name = featureSchema.getAttributeName(index);
                    type = featureSchema.getAttributeType(index);
                    if (layerSchema.hasAttribute(name) || type != AttributeType.STRING && type != AttributeType.DOUBLE && type != AttributeType.INTEGER && type != AttributeType.DATE && type != AttributeType.OBJECT && type != AttributeType.BOOLEAN && type != AttributeType.LONG) continue;
                    layerSchema.addAttribute(name, type);
                    changedSchema = true;
                }
                if (changedSchema) {
                    List<Feature> layerFeatures = layer.getFeatureCollectionWrapper().getFeatures();
                    for (int j = 0; j < layerFeatures.size(); ++j) {
                        BasicFeature newFeature = new BasicFeature(layerSchema);
                        Feature oldFeature = layerFeatures.get(j);
                        int numAttribs = oldFeature.getAttributes().length;
                        for (int k = 0; k < numAttribs; ++k) {
                            newFeature.setAttribute(k, oldFeature.getAttribute(k));
                        }
                        oldFeature.setSchema(newFeature.getSchema());
                        oldFeature.setAttributes(newFeature.getAttributes());
                    }
                    layer.setFeatureCollectionModified(true);
                    layer.fireLayerChanged(LayerEventType.METADATA_CHANGED);
                }
            }
        }
        return true;
    }
}

