/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.view;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiShortcutEnabled;
import com.vividsolutions.jump.workbench.plugin.PlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.Viewport;
import java.awt.geom.NoninvertibleTransformException;
import javax.swing.JInternalFrame;
import org.locationtech.jts.geom.Envelope;

public class InstallKeyPanPlugIn
extends AbstractPlugIn
implements MultiShortcutEnabled {
    private static final int NORTH = 0;
    private static final int EAST = 1;
    private static final int SOUTH = 2;
    private static final int WEST = 3;
    private static final int ZOOM_IN = 4;
    private static final int ZOOM_OUT = 5;
    private static final int ZOOM_FULL = 6;
    public static final String sPAN_NORTH = I18N.getInstance().get("org.openjump.core.ui.plugin.view.InstallKeyPanPlugIn.pan-north");
    public static final String sPAN_EAST = I18N.getInstance().get("org.openjump.core.ui.plugin.view.InstallKeyPanPlugIn.pan-east");
    public static final String sPAN_SOUTH = I18N.getInstance().get("org.openjump.core.ui.plugin.view.InstallKeyPanPlugIn.pan-south");
    public static final String sPAN_WEST = I18N.getInstance().get("org.openjump.core.ui.plugin.view.InstallKeyPanPlugIn.pan-west");
    public static final String sZOOM_IN = I18N.getInstance().get("org.openjump.core.ui.plugin.view.InstallKeyPanPlugIn.zoom-in");
    public static final String sZOOM_OUT = I18N.getInstance().get("org.openjump.core.ui.plugin.view.InstallKeyPanPlugIn.zoom-out");
    public static final String sZOOM_EXT = I18N.getInstance().get("org.openjump.core.ui.plugin.view.InstallKeyPanPlugIn.zoom-to-full-extent");
    public static final String sACCEPTED_VALUES = I18N.getInstance().get("org.openjump.core.ui.plugin.view.InstallKeyPanPlugIn.accepted-values");
    private static final int[][] DIRECTIONS = new int[][]{{0, -1, 0, -1}, {-1, 0, -1, 0}, {0, 1, 0, 1}, {1, 0, 1, 0}, {1, 1, -1, -1}, {-1, -1, 1, 1}};
    private static double panPercentage;
    AbstractPlugIn[] plugIns;
    int[] keys = new int[]{38, 39, 40, 37, 521, 45, 107, 109, 48};

    public InstallKeyPanPlugIn() {
        this(0.5);
    }

    public InstallKeyPanPlugIn(double panPercentage) {
        this.setPanPercentage(panPercentage);
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        this.plugIns = new AbstractPlugIn[]{new PanHelper(sPAN_NORTH, 0), new PanHelper(sPAN_EAST, 1), new PanHelper(sPAN_SOUTH, 2), new PanHelper(sPAN_WEST, 3), new PanHelper(sZOOM_IN, 4), new PanHelper(sZOOM_OUT, 5), new PanHelper(sZOOM_IN, 4), new PanHelper(sZOOM_OUT, 5), new PanHelper(sZOOM_EXT, 6)};
        for (int i = 0; i < this.keys.length; ++i) {
            this.plugIns[i].initialize(context);
            this.plugIns[i].setShortcutKeys(this.keys[i]);
            this.plugIns[i].setShortcutModifiers(2);
        }
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        return true;
    }

    public double getPanPercentage() {
        return 2.0 * panPercentage;
    }

    public void setPanPercentage(double panPercent) {
        if (panPercent <= 0.0 || panPercent > 1.0) {
            throw new IllegalArgumentException(sACCEPTED_VALUES);
        }
        panPercentage = panPercent / 2.0;
    }

    @Override
    public PlugIn[] getShortcutEnabledPlugins() {
        return this.plugIns;
    }

    private static Envelope createEnvelopeFromDirection(Envelope oldEnvelope, int mode) {
        double oldWidth = panPercentage * oldEnvelope.getWidth();
        double oldHeight = panPercentage * oldEnvelope.getHeight();
        double dxPlus = (double)DIRECTIONS[mode][0] * oldWidth;
        double dyPlus = (double)DIRECTIONS[mode][1] * oldHeight;
        double dxMinus = (double)DIRECTIONS[mode][2] * oldWidth;
        double dyMinus = (double)DIRECTIONS[mode][3] * oldHeight;
        return new Envelope(oldEnvelope.getMinX() - dxMinus, oldEnvelope.getMaxX() - dxPlus, oldEnvelope.getMinY() - dyMinus, oldEnvelope.getMaxY() - dyPlus);
    }

    private static boolean pan(JInternalFrame jif, int mode) {
        if (jif instanceof TaskFrame) {
            try {
                TaskFrame taskFrame = (TaskFrame)jif;
                LayerViewPanel lvp = taskFrame.getLayerViewPanel();
                Viewport vp = lvp.getViewport();
                if (mode == 6) {
                    vp.zoomToFullExtent();
                    return true;
                }
                Envelope oldEnvelope = vp.getEnvelopeInModelCoordinates();
                vp.zoom(InstallKeyPanPlugIn.createEnvelopeFromDirection(oldEnvelope, mode));
            }
            catch (NoninvertibleTransformException e1) {
                e1.printStackTrace();
                return false;
            }
        }
        return true;
    }

    private class PanHelper
    extends AbstractPlugIn {
        private final int mode;
        private String name;

        public PanHelper(String name, int mode) {
            this.mode = mode;
            this.name = name;
        }

        @Override
        public void initialize(PlugInContext context) throws Exception {
            super.initialize(context);
        }

        @Override
        public boolean execute(PlugInContext context) throws Exception {
            return InstallKeyPanPlugIn.pan(context.getWorkbenchFrame().getActiveInternalFrame(), this.mode);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public EnableCheck getEnableCheck() {
            return EnableCheckFactory.getInstance(this.getWorkbenchContext()).createTaskWindowMustBeActiveCheck();
        }
    }
}

