/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools.statistics;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.AttributeTypeFilter;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.GenericNames;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.openjump.core.ui.plot.Plot2DPanelOJ;
import org.openjump.sextante.gui.additionalResults.AdditionalResults;

public class CreateHistogramPlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    private String sHistogram = "Histogram";
    private String sCount = "count";
    private String T2 = "number of ranges";
    private String CLAYER = "select layer";
    private String ATTRIBUTE = "select attribute";
    private Layer selLayer = null;
    private int ranges = 7;
    private String selAttribute = null;
    private String sName = "Create Histogram Plot";
    private String sWrongDataType = "Wrong datatype of chosen attribute";

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        this.ATTRIBUTE = GenericNames.SELECT_ATTRIBUTE;
        this.T2 = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.statistics.CreateHistogramPlugIn.Number-of-ranges");
        this.CLAYER = GenericNames.SELECT_LAYER;
        this.sHistogram = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.statistics.CreateHistogramPlugIn.Histogram-Plot");
        this.sCount = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.statistics.CreateHistogramPlugIn.count");
        this.sName = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.statistics.CreateHistogramPlugIn");
        this.sWrongDataType = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.statistics.CreateBarPlotPlugIn.Wrong-datatype-of-chosen-attribute");
        FeatureInstaller featureInstaller = context.getFeatureInstaller();
        featureInstaller.addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.STATISTICS, MenuNames.PLOT}, this.sName + "...", false, null, CreateHistogramPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createAtLeastNLayersMustExistCheck(1)).add(checkFactory.createWindowWithAssociatedTaskFrameMustBeActiveCheck());
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.sName, true);
        this.setDialogValues(dialog, context);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        return true;
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        this.createHistogram(context, this.selLayer);
    }

    private void setDialogValues(final MultiInputDialog dialog, PlugInContext context) {
        dialog.addLayerComboBox(this.CLAYER, context.getCandidateLayer(0), context.getLayerManager());
        List<String> list = AttributeTypeFilter.NUMERIC_FILTER.filter(context.getCandidateLayer(0));
        String val = list.size() > 0 ? list.iterator().next() : null;
        final JComboBox<String> jcb_attribute = dialog.addComboBox(this.ATTRIBUTE, val, list, this.ATTRIBUTE);
        if (list.size() == 0) {
            jcb_attribute.setEnabled(false);
        }
        dialog.addIntegerField(this.T2, this.ranges, 6, this.T2);
        dialog.getComboBox(this.CLAYER).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List<String> list = AttributeTypeFilter.NUMERIC_FILTER.filter(dialog.getLayer(CreateHistogramPlugIn.this.CLAYER));
                if (list.size() == 0) {
                    jcb_attribute.setModel(new DefaultComboBoxModel<String>(new String[0]));
                    jcb_attribute.setEnabled(false);
                }
                jcb_attribute.setModel(new DefaultComboBoxModel<String>(list.toArray(new String[0])));
            }
        });
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.ranges = dialog.getInteger(this.T2);
        this.selLayer = dialog.getLayer(this.CLAYER);
        this.selAttribute = dialog.getText(this.ATTRIBUTE);
    }

    private boolean createHistogram(PlugInContext context, Layer selLayer) {
        FeatureCollectionWrapper fc = selLayer.getFeatureCollectionWrapper();
        FeatureSchema fs = fc.getFeatureSchema();
        AttributeType type = fs.getAttributeType(this.selAttribute);
        if (type != AttributeType.DOUBLE && type != AttributeType.INTEGER && type != AttributeType.LONG) {
            context.getWorkbenchFrame().warnUser(this.sWrongDataType);
            return false;
        }
        double[] data = new double[fc.size()];
        int i = 0;
        for (Feature f : fc.getFeatures()) {
            Object val = f.getAttribute(this.selAttribute);
            if (!(val instanceof Number)) continue;
            data[i] = ((Number)val).doubleValue();
            ++i;
        }
        double[] data2 = new double[i];
        System.arraycopy(data, 0, data2, 0, i);
        Plot2DPanelOJ plot = new Plot2DPanelOJ();
        plot.addHistogramPlotOJ(this.selAttribute, data2, this.ranges, context, selLayer, this.selAttribute);
        plot.plotToolBar.setVisible(true);
        plot.setAxisLabel(0, this.selAttribute);
        plot.setAxisLabel(1, this.sCount);
        AdditionalResults.addAdditionalResultAndShow(this.sHistogram, (Object)plot);
        return true;
    }
}

