/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools.generate;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.MultiTabInputDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import org.openjump.core.ui.images.IconLoader;
import org.openjump.core.ui.plugin.tools.generate.AbstractLinearReferencingPlugIn;

public class LinearReferencingOnSelectionPlugIn
extends AbstractLinearReferencingPlugIn {
    private static final String KEY = LinearReferencingOnSelectionPlugIn.class.getName();
    private String categoryName = StandardCategoryNames.RESULT;

    public LinearReferencingOnSelectionPlugIn() {
        super(I18N.getInstance().get(KEY), IconLoader.icon("linearref_selection.png"));
    }

    public void setCategoryName(String value) {
        this.categoryName = value;
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_GENERATE, MenuNames.TOOLS_LINEARREFERENCING}, this.getName() + "...", false, this.getIcon(), LinearReferencingOnSelectionPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustExistCheck(1)).add(checkFactory.createAtLeastNFeaturesMustBeSelectedCheck(1));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        super.execute(context);
        MultiTabInputDialog dialog = new MultiTabInputDialog((Frame)context.getWorkbenchFrame(), this.getName(), this.getName(), true);
        this.setDialogValues(dialog, context);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        return true;
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        monitor.allowCancellationRequests();
        FeatureSchema featureSchema = new FeatureSchema();
        featureSchema.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        featureSchema.addAttribute("LAYER", AttributeType.STRING);
        featureSchema.addAttribute("PATH", AttributeType.STRING);
        featureSchema.addAttribute("NUM", AttributeType.INTEGER);
        featureSchema.addAttribute("DISTANCE", AttributeType.DOUBLE);
        featureSchema.addAttribute("OFFSET", AttributeType.DOUBLE);
        FeatureDataset resultFC = new FeatureDataset(featureSchema);
        Collection<Layer> layers = context.getLayerViewPanel().getSelectionManager().getLayersWithSelectedItems();
        for (Layer layer : layers) {
            Collection<Feature> features = context.getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems(layer);
            for (Feature feature : features) {
                if (feature.getGeometry().getDimension() == 1) {
                    this.setPointsAlong(resultFC, layer.getName(), Integer.toString(feature.getID()), feature.getGeometry());
                    continue;
                }
                if (feature.getGeometry().getDimension() != 2) continue;
                this.setPointsAlong(resultFC, layer.getName(), Integer.toString(feature.getID()), feature.getGeometry().getBoundary());
            }
        }
        context.addLayer(this.categoryName, "Linear-Referencing", resultFC);
    }

    private void setDialogValues(MultiTabInputDialog dialog, PlugInContext context) {
        dialog.setSideBarDescription(this.DESCRIPTION);
        dialog.addSubTitle(this.DISTANCE_UNIT);
        dialog.addRadioButton(this.MAP_UNIT, "UNIT", this.map_unit, this.MAP_UNIT_TOOLTIP);
        dialog.addRadioButton(this.LINESTRING_FRACTION, "UNIT", this.linestring_fraction, this.LINESTRING_FRACTION_TOOLTIP);
        dialog.addSubTitle(this.DISTANCE_AND_OFFSET);
        dialog.addDoubleField(this.DISTANCE, this.distance, 6, this.DISTANCE_TOOLTIP);
        dialog.addDoubleField(this.OFFSET, this.offset, 6, this.OFFSET_TOOLTIP);
        dialog.addSeparator();
        final JCheckBox repeatCheckBox = dialog.addCheckBox(this.REPEAT, this.repeat, null);
        final JTextField repeatDistanceTextField = dialog.addDoubleField(this.REPEAT_DISTANCE, this.repeat_distance, 6, null);
        final JCheckBox addEndPointCheckBox = dialog.addCheckBox(this.ADD_END_POINT, this.add_end_point, null);
        dialog.addSeparator();
        repeatCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                repeatDistanceTextField.setEnabled(repeatCheckBox.isSelected());
                addEndPointCheckBox.setEnabled(repeatCheckBox.isSelected());
            }
        });
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.map_unit = dialog.getBoolean(this.MAP_UNIT);
        this.linestring_fraction = dialog.getBoolean(this.LINESTRING_FRACTION);
        this.distance = dialog.getDouble(this.DISTANCE);
        this.offset = dialog.getDouble(this.OFFSET);
        this.repeat = dialog.getBoolean(this.REPEAT);
        this.repeat_distance = dialog.getDouble(this.REPEAT_DISTANCE);
        if (this.repeat_distance == 0.0) {
            this.repeat = false;
        }
        this.add_end_point = dialog.getBoolean(this.ADD_END_POINT);
    }
}

