/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureDatasetFactory;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.triangulate.VertexTaggedGeometryDataMapper;
import org.locationtech.jts.triangulate.VoronoiDiagramBuilder;
import org.openjump.core.ui.images.IconLoader;
import org.openjump.core.ui.plugin.AbstractThreadedUiPlugIn;

public class VoronoiDiagramPlugIn
extends AbstractThreadedUiPlugIn {
    public static String TRIANGULATE = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.VoronoiDiagramPlugIn.triangulate");
    public static String VORONOI = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.VoronoiDiagramPlugIn.voronoi");
    public static String SITES_LAYER = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.VoronoiDiagramPlugIn.sites-layer");
    public static String TRANSFER_ATTRIBUTES = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.VoronoiDiagramPlugIn.transfer-attributes");
    public static String TOLERANCE = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.VoronoiDiagramPlugIn.tolerance");
    public static String DESCRIPTION = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.VoronoiDiagramPlugIn.description");
    String sitesLayer;
    boolean transferAttributes = false;
    double tolerance = 0.0;

    @Override
    public void initialize(PlugInContext context) throws Exception {
        FeatureInstaller featureInstaller = context.getFeatureInstaller();
        featureInstaller.addMainMenuItem(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_GENERATE}, this.getName() + "...", false, IconLoader.icon("voronoi.png"), VoronoiDiagramPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createAtLeastNLayersMustExistCheck(1));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        this.setDialogValues(dialog, context);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog);
        return true;
    }

    public void setSitesLayer(String sitesLayer) {
        this.sitesLayer = sitesLayer;
    }

    public void setTransferAttributes(boolean transferAttributes) {
        this.transferAttributes = transferAttributes;
    }

    public void setTolerance(double tolerance) {
        this.tolerance = tolerance;
    }

    private void setDialogValues(MultiInputDialog dialog, PlugInContext context) {
        dialog.setSideBarDescription(DESCRIPTION);
        if (this.sitesLayer == null || context.getLayerManager().getLayer(this.sitesLayer) == null) {
            this.sitesLayer = context.getCandidateLayer(0).getName();
        }
        dialog.addLayerComboBox(SITES_LAYER, context.getLayerManager().getLayer(this.sitesLayer), null, context.getLayerManager());
        dialog.addCheckBox(TRANSFER_ATTRIBUTES, this.transferAttributes);
        dialog.addDoubleField(TOLERANCE, this.tolerance, 12);
    }

    private void getDialogValues(MultiInputDialog dialog) {
        this.sitesLayer = dialog.getLayer(SITES_LAYER).getName();
        this.transferAttributes = dialog.getBoolean(TRANSFER_ATTRIBUTES);
        this.tolerance = dialog.getDouble(TOLERANCE);
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        monitor.report(TRIANGULATE);
        LayerManager layerManager = context.getLayerManager();
        FeatureCollectionWrapper inputFC = layerManager.getLayer(this.sitesLayer).getFeatureCollectionWrapper();
        Geometry sites = this.getSites(inputFC, this.transferAttributes);
        VertexTaggedGeometryDataMapper mapper = null;
        if (this.transferAttributes) {
            mapper = new VertexTaggedGeometryDataMapper();
            mapper.loadSourceGeometries(sites);
        }
        VoronoiDiagramBuilder voronoiBuilder = new VoronoiDiagramBuilder();
        voronoiBuilder.setSites(sites);
        voronoiBuilder.setTolerance(this.tolerance);
        Envelope env = null;
        env = context.getLayerViewPanel().getFence() != null ? context.getLayerViewPanel().getFence().getEnvelopeInternal() : layerManager.getEnvelopeOfAllLayers();
        voronoiBuilder.setClipEnvelope(env);
        Geometry g = voronoiBuilder.getDiagram(new GeometryFactory());
        FeatureCollection result = null;
        if (this.transferAttributes && mapper != null) {
            mapper.transferData(g);
            FeatureSchema schema = inputFC.getFeatureSchema();
            result = new FeatureDataset(schema);
            for (int i = 0; i < g.getNumGeometries(); ++i) {
                Geometry cellGeom = g.getGeometryN(i);
                Feature cell = ((Feature)cellGeom.getUserData()).clone(false);
                cellGeom.setUserData(null);
                cell.setGeometry(cellGeom);
                result.add(cell);
            }
        } else {
            ArrayList<Geometry> geometries = new ArrayList<Geometry>();
            for (int i = 0; i < g.getNumGeometries(); ++i) {
                geometries.add(g.getGeometryN(i));
            }
            result = FeatureDatasetFactory.createFromGeometry(geometries);
        }
        context.getLayerManager().addLayer(StandardCategoryNames.RESULT, this.sitesLayer + "-" + VORONOI, result);
    }

    private Geometry getSites(FeatureCollection fcSites, boolean transferAttributes) {
        ArrayList<Point> sites = new ArrayList<Point>();
        GeometryFactory gf = null;
        if (fcSites.isEmpty()) {
            gf = new GeometryFactory();
        } else {
            gf = fcSites.iterator().next().getGeometry().getFactory();
            for (Feature o : fcSites.getFeatures()) {
                this.addSite(o.getGeometry(), sites, gf, o, transferAttributes);
            }
        }
        return gf.createMultiPoint(sites.toArray(new Point[sites.size()]));
    }

    private void addSite(Geometry g, List<Point> sites, GeometryFactory gf, Object o, boolean transferAttributes) {
        if (g instanceof Point) {
            g.setUserData(o);
            sites.add((Point)g);
        } else {
            for (Coordinate c : g.getCoordinates()) {
                Point p = gf.createPoint(c);
                p.setUserData(o);
                sites.add(gf.createPoint(c));
            }
        }
    }
}

