/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.EditTransaction;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.locationtech.jts.geom.Geometry;
import org.openjump.core.apitools.FeatureCollectionTools;
import org.openjump.core.apitools.LayerTools;
import org.openjump.core.geomutils.algorithm.PolygonMerge;

public class MergeTwoSelectedPolygonsPlugIn
extends AbstractPlugIn {
    private String sMergeTwoPolys = I18N.getInstance().get("org.openjump.core.ui.plugin.tools.MergeTwoSelectedPolygonsPlugIn.Merge-Two-Polygons");

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        FeatureInstaller featureInstaller = context.getFeatureInstaller();
        featureInstaller.addMainMenuItem(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_EDIT_GEOMETRY}, this.getName(), false, null, MergeTwoSelectedPolygonsPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    @Override
    public String getName() {
        return this.sMergeTwoPolys;
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck()).add(checkFactory.createSelectedLayersMustBeEditableCheck()).add(checkFactory.createAtLeastNItemsMustBeSelectedCheck(2));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Collection<Feature> features = context.getWorkbenchContext().getLayerViewPanel().getSelectionManager().getFeaturesWithSelectedItems();
        if (features.size() == 2) {
            Iterator<Feature> iter = features.iterator();
            Feature f1 = iter.next();
            Feature f2 = iter.next();
            PolygonMerge merge = new PolygonMerge(f1.getGeometry(), f2.getGeometry());
            if (merge.isMergeSuccesfull() == 1) {
                ArrayList<Feature> fToEdit = new ArrayList<Feature>();
                fToEdit.add(f1);
                Map<Layer, List<Feature>> layer2FeatList = LayerTools.getLayer2FeatureMap(fToEdit, context);
                Layer[] layersWithFeatures = layer2FeatList.keySet().toArray(new Layer[0]);
                EditTransaction edtr = new EditTransaction(fToEdit, "setgeom", layersWithFeatures[0], true, false, context.getLayerViewPanel());
                Geometry g = merge.getOutPolygon();
                edtr.setGeometry(f1, g);
                edtr.commit();
                edtr.clearEnvelopeCaches();
                ArrayList<Feature> fToDelete = new ArrayList<Feature>();
                fToDelete.add(f2);
                FeatureCollectionTools.deleteFeatures(fToDelete, context);
            }
        } else {
            context.getWorkbenchFrame().warnUser("more than 2 objects selected");
        }
        return true;
    }
}

