/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.tools;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.AttributeTypeFilter;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.MultiTabInputDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.openjump.core.ui.images.IconLoader;
import org.openjump.core.ui.plugin.AbstractThreadedUiPlugIn;
import org.openjump.core.ui.plugin.tools.aggregate.Aggregator;
import org.openjump.core.ui.plugin.tools.aggregate.Aggregators;
import org.openjump.core.ui.plugin.tools.aggregate.AttributeAggregator;
import org.openjump.core.ui.plugin.tools.aggregate.FeatureCollectionAggregator;

public class Dissolve2PlugIn
extends AbstractThreadedUiPlugIn {
    private static final String KEY = Dissolve2PlugIn.class.getName();
    private static final Dimension LARGE = new Dimension(110, 22);
    private static final Dimension MEDIUM = new Dimension(22, 22);
    private static final Dimension NARROW = new Dimension(22, 22);
    private static final String SOURCE_LAYER = I18N.JUMP.get(KEY + ".source-layer");
    private static final String DESCRIPTION = I18N.JUMP.get(KEY + ".description");
    private static final String KEY_ATTRIBUTES = I18N.JUMP.get(KEY + ".key-attributes");
    private static final String ADD_KEY_ATTRIBUTE = I18N.JUMP.get(KEY + ".add-key-attribute");
    private static final String AGGREGATORS = I18N.JUMP.get(KEY + ".aggregators");
    private static final String AGGREGATE_FUNCTION = I18N.JUMP.get(KEY + ".aggregate-function");
    private static final String AGGREGATE_FUNCTIONS = I18N.JUMP.get(KEY + ".aggregate-functions");
    private static final String ADD_AGGREGATE_FUNCTION = I18N.JUMP.get(KEY + ".add-aggregate-function");
    private static final String REMOVE_AGGREGATE_FUNCTION = I18N.JUMP.get(KEY + ".remove-aggregate-function");
    private static final String IGNORE_NULL = I18N.JUMP.get(KEY + ".ignore-null");
    private static final String PARAMETER = I18N.JUMP.get(KEY + ".parameter");
    private static final String OUTPUT_NAME = I18N.JUMP.get(KEY + ".output-name");
    private static final String INPUT_ATTRIBUTE = I18N.JUMP.get(KEY + ".input-attribute");
    private static final String GEOMETRY_AGGREGATOR = I18N.JUMP.get(KEY + ".geometry-aggregator");
    private static final String FLOATING_PRECISION_MODEL = I18N.JUMP.get("jts.use-floating-point-precision-model");
    private static final String FLOATING_PRECISION_MODEL_TT = I18N.JUMP.get("jts.use-floating-point-precision-model-tt");
    private static final String FIXED_PRECISION_MODEL = I18N.JUMP.get("jts.use-fixed-precision-model");
    private static final String FIXED_PRECISION_MODEL_TT = I18N.JUMP.get("jts.use-fixed-precision-model-tt");
    private static final String PRECISION = I18N.JUMP.get("jts.fixed-precision");
    private static final String PRECISION_TT = I18N.JUMP.get("jts.fixed-precision-tt");
    private Layer layer;
    private FeatureCollectionAggregator fca;
    private boolean floatingPrecision = true;
    private boolean fixedPrecision = false;
    private double precision = 1000.0;

    @Override
    public String getName() {
        return I18N.JUMP.get(KEY);
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.TOOLS, MenuNames.TOOLS_ANALYSIS}, this.getName() + "...", false, IconLoader.icon("groupby.png"), Dissolve2PlugIn.createEnableCheck(context.getWorkbenchContext()), -1);
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createTaskWindowMustBeActiveCheck()).add(checkFactory.createAtLeastNLayersMustExistCheck(1)).add(component -> AttributeTypeFilter.NO_GEOMETRY_FILTER.filter(workbenchContext.getLayerManager()).size() > 0 ? null : I18N.JUMP.get(KEY + ".dataset-must-have-attributes"));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        MultiTabInputDialog dialog = new MultiTabInputDialog((Frame)context.getWorkbenchFrame(), this.getName(), KEY_ATTRIBUTES, true);
        KeyOptionPanel keyOptionPanel = new KeyOptionPanel();
        AggregateOptionPanel aggregateOptionPanel = new AggregateOptionPanel();
        this.initDialog(dialog, context, keyOptionPanel, aggregateOptionPanel);
        dialog.setVisible(true);
        if (!dialog.wasOKPressed()) {
            return false;
        }
        this.getDialogValues(dialog, keyOptionPanel, aggregateOptionPanel);
        return true;
    }

    private void initDialog(final MultiTabInputDialog dialog, PlugInContext context, final KeyOptionPanel keyOptionPanel, final AggregateOptionPanel aggregateOptionPanel) throws Exception {
        dialog.setSideBarDescription(DESCRIPTION);
        dialog.addSeparator();
        if (this.layer == null) {
            if (context.getCandidateLayer(0).getFeatureCollectionWrapper().getFeatureSchema().getAttributeCount() > 1) {
                this.layer = context.getCandidateLayer(0);
            } else {
                List<Layer> candidates = AttributeTypeFilter.NO_GEOMETRY_FILTER.filter(this.workbenchContext.getLayerManager());
                this.layer = candidates.get(0);
            }
        }
        final JComboBox<Layer> layerComboBox = dialog.addLayerComboBox(SOURCE_LAYER, this.layer, "", AttributeTypeFilter.NO_GEOMETRY_FILTER.filter(context.getLayerManager()));
        dialog.addSeparator();
        keyOptionPanel.setSchema(dialog.getLayer(SOURCE_LAYER).getFeatureCollectionWrapper().getFeatureSchema());
        dialog.addRow(KEY_ATTRIBUTES, new JLabel(KEY_ATTRIBUTES), keyOptionPanel, null, "", 1, 2);
        dialog.addSeparator();
        Aggregators.Union union = new Aggregators.Union();
        Aggregators.Collect collect = new Aggregators.Collect();
        dialog.addComboBox(GEOMETRY_AGGREGATOR, union, Arrays.asList(union, collect), "");
        JRadioButton floatingPrecisionRB = dialog.addRadioButton(FLOATING_PRECISION_MODEL, "MODEL", this.floatingPrecision, FLOATING_PRECISION_MODEL_TT);
        JRadioButton fixedPrecisionRB = dialog.addRadioButton(FIXED_PRECISION_MODEL, "MODEL", this.fixedPrecision, FIXED_PRECISION_MODEL_TT);
        JTextField precisionTF = dialog.addDoubleField(PRECISION, this.precision, 12, PRECISION_TT);
        precisionTF.setEnabled(this.fixedPrecision);
        floatingPrecisionRB.addActionListener(e -> {
            FeatureSchema schema = this.layer.getFeatureCollectionWrapper().getFeatureSchema();
            try {
                keyOptionPanel.setSchema(schema);
                aggregateOptionPanel.setSchema(schema);
                precisionTF.setEnabled(!floatingPrecisionRB.isSelected());
                this.updateControls(dialog, keyOptionPanel, aggregateOptionPanel);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        });
        fixedPrecisionRB.addActionListener(e -> {
            FeatureSchema schema = dialog.getLayer(SOURCE_LAYER).getFeatureCollectionWrapper().getFeatureSchema();
            try {
                keyOptionPanel.setSchema(schema);
                aggregateOptionPanel.setSchema(schema);
                precisionTF.setEnabled(fixedPrecisionRB.isSelected());
                this.updateControls(dialog, keyOptionPanel, aggregateOptionPanel);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        });
        dialog.addSeparator();
        JPanel aggregationOptionsTab = dialog.addPane(AGGREGATORS);
        aggregationOptionsTab.setLayout(new BorderLayout());
        aggregateOptionPanel.setSchema(dialog.getLayer(SOURCE_LAYER).getFeatureCollectionWrapper().getFeatureSchema());
        aggregationOptionsTab.add((Component)aggregateOptionPanel, "North");
        dialog.pack();
        layerComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    Dissolve2PlugIn.this.layer = (Layer)layerComboBox.getSelectedItem();
                    if (Dissolve2PlugIn.this.layer != null) {
                        FeatureSchema schema = Dissolve2PlugIn.this.layer.getFeatureCollectionWrapper().getFeatureSchema();
                        try {
                            keyOptionPanel.setSchema(schema);
                            aggregateOptionPanel.setSchema(schema);
                            Dissolve2PlugIn.this.updateControls(dialog, keyOptionPanel, aggregateOptionPanel);
                        }
                        catch (Exception ex) {
                            throw new RuntimeException(ex);
                        }
                    }
                }
            }
        });
        GUIUtil.centreOnWindow(dialog);
    }

    private void getDialogValues(MultiInputDialog dialog, KeyOptionPanel keyOptionPanel, AggregateOptionPanel aggregateOptionPanel) {
        this.layer = dialog.getLayer(SOURCE_LAYER);
        this.floatingPrecision = dialog.getBoolean(FLOATING_PRECISION_MODEL);
        this.fixedPrecision = dialog.getBoolean(FIXED_PRECISION_MODEL);
        this.precision = dialog.getDouble(PRECISION);
        FeatureSchema schema = this.layer.getFeatureCollectionWrapper().getFeatureSchema();
        ArrayList<String> keyAttributes = new ArrayList<String>(keyOptionPanel.getKeyAttributes());
        ArrayList<AttributeAggregator> aggregators = new ArrayList<AttributeAggregator>();
        if (!keyAttributes.contains(schema.getAttributeName(schema.getGeometryIndex()))) {
            Aggregator geomAggregator = (Aggregator)dialog.getComboBox(GEOMETRY_AGGREGATOR).getSelectedItem();
            if (geomAggregator instanceof Aggregators.Union && this.fixedPrecision) {
                geomAggregator.setParameter("precision", this.precision);
            }
            AttributeAggregator attAggregator = new AttributeAggregator(schema.getAttributeName(schema.getGeometryIndex()), geomAggregator, schema.getAttributeName(schema.getGeometryIndex()));
            aggregators.add(attAggregator);
        }
        aggregators.addAll(aggregateOptionPanel.getAttributeAggregators());
        int geometryTypeCount = 0;
        for (String key : keyAttributes) {
            if (schema.getAttributeType(key) != AttributeType.GEOMETRY) continue;
            ++geometryTypeCount;
        }
        for (AttributeAggregator agg : aggregators) {
            if (agg.getAggregator().getOutputAttributeType() != AttributeType.GEOMETRY) continue;
            ++geometryTypeCount;
        }
        try {
            if (geometryTypeCount != 1) {
                throw new Exception(I18N.getInstance().get(KEY + ".exactly-one-geometry-attribute-is-required"));
            }
            this.fca = new FeatureCollectionAggregator(this.layer.getFeatureCollectionWrapper(), keyAttributes, aggregators);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void updateControls(MultiInputDialog dialog, KeyOptionPanel keyAttributeOptionPanel, AggregateOptionPanel aggregateOptionPanel) throws Exception {
        this.getDialogValues(dialog, keyAttributeOptionPanel, aggregateOptionPanel);
        FeatureSchema schema = this.layer.getFeatureCollectionWrapper().getFeatureSchema();
        keyAttributeOptionPanel.setSchema(schema);
        aggregateOptionPanel.setSchema(schema);
        dialog.pack();
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        monitor.allowCancellationRequests();
        monitor.report(this.getName());
        FeatureCollection resultfc = this.fca.getAggregatedFeatureCollection();
        context.getLayerManager().addCategory(StandardCategoryNames.RESULT);
        String newLayerName = this.layer.getName() + "-grouped";
        context.addLayer(StandardCategoryNames.RESULT, newLayerName, resultfc);
    }

    class AttributeAggregatePanel
    extends JPanel {
        final AggregateOptionPanel aggregatePanel;
        final FeatureSchema schema;
        JTextField jtfOutputAttributeName;
        JComboBox<String> jcbInputAttributeName;
        JComboBox<Aggregator<?>> jcbAggregators;
        JCheckBox jcbIgnoreNull;
        JTextField jtfParameter;
        JButton jbRemove;

        AttributeAggregatePanel(AggregateOptionPanel aggregatePanel, final FeatureSchema schema) {
            this.aggregatePanel = aggregatePanel;
            this.schema = schema;
            this.jtfOutputAttributeName = new JTextField();
            this.jtfOutputAttributeName.setPreferredSize(LARGE);
            this.jcbInputAttributeName = new JComboBox();
            for (int i = 0; i < schema.getAttributeCount(); ++i) {
                if (i == schema.getGeometryIndex()) continue;
                this.jcbInputAttributeName.addItem(schema.getAttributeName(i));
            }
            String defaultAttribute = null;
            if (this.jcbInputAttributeName.getSelectedItem() != null) {
                defaultAttribute = this.jcbInputAttributeName.getSelectedItem().toString();
            }
            this.jtfOutputAttributeName.setText(defaultAttribute);
            this.jcbInputAttributeName.setPreferredSize(LARGE);
            this.jcbAggregators = new JComboBox<Aggregator>(Aggregators.getAggregators(schema.getAttributeType(defaultAttribute)).values().toArray(new Aggregator[0]));
            this.jcbAggregators.setPreferredSize(LARGE);
            Aggregator aggregator = (Aggregator)this.jcbAggregators.getSelectedItem();
            this.jcbIgnoreNull = new JCheckBox();
            this.jcbIgnoreNull.setPreferredSize(MEDIUM);
            this.jcbIgnoreNull.setSelected(aggregator == null || aggregator.ignoreNull());
            this.jtfParameter = new JTextField(",");
            this.jtfParameter.setEditable(aggregator != null && aggregator.getParameters().size() > 0);
            this.jtfParameter.setPreferredSize(NARROW);
            this.jbRemove = new JButton();
            this.jbRemove.setIcon(IconLoader.icon("remove.gif"));
            this.jbRemove.setToolTipText(REMOVE_AGGREGATE_FUNCTION);
            this.jbRemove.setPreferredSize(NARROW);
            this.jcbInputAttributeName.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AttributeType type = schema.getAttributeType(AttributeAggregatePanel.this.jcbInputAttributeName.getSelectedItem().toString());
                    AttributeAggregatePanel.this.jcbAggregators.setModel(new DefaultComboBoxModel<Aggregator>(Aggregators.getAggregators(type).values().toArray(new Aggregator[0])));
                    Aggregator agg = (Aggregator)AttributeAggregatePanel.this.jcbAggregators.getSelectedItem();
                    if (agg != null) {
                        AttributeAggregatePanel.this.jcbIgnoreNull.setSelected(agg.ignoreNull());
                        AttributeAggregatePanel.this.jtfParameter.setEditable(agg.getParameters().size() > 0);
                    }
                    AttributeAggregatePanel.this.jtfOutputAttributeName.setText(AttributeAggregatePanel.this.jcbInputAttributeName.getSelectedItem().toString());
                }
            });
            this.jcbAggregators.addActionListener(e -> {
                Aggregator agg = (Aggregator)this.jcbAggregators.getSelectedItem();
                if (agg != null) {
                    this.jcbIgnoreNull.setSelected(agg.ignoreNull());
                    this.jtfParameter.setEditable(agg.getParameters().size() > 0);
                }
            });
            this.jbRemove.addActionListener(e -> {
                aggregatePanel.getAggregatorsPanel().remove(this);
                SwingUtilities.getWindowAncestor(aggregatePanel).pack();
            });
            this.add(this.jtfOutputAttributeName);
            this.add(this.jcbInputAttributeName);
            this.add(this.jcbAggregators);
            this.add(this.jcbIgnoreNull);
            this.add(this.jtfParameter);
            this.add(this.jbRemove);
        }
    }

    class AggregateOptionPanel
    extends JPanel {
        final JPanel northPanel = new JPanel(new BorderLayout());
        final JPanel aggregatorsPanel;
        FeatureSchema schema;

        AggregateOptionPanel() {
            this.northPanel.add((Component)new JLabel("<html><b>" + AGGREGATE_FUNCTIONS + "</b></html>"), "North");
            JPanel titleLine = new JPanel();
            JLabel jlOutputName = new JLabel(OUTPUT_NAME);
            jlOutputName.setPreferredSize(LARGE);
            titleLine.add(jlOutputName);
            JLabel jlInputName = new JLabel(INPUT_ATTRIBUTE);
            jlInputName.setPreferredSize(LARGE);
            titleLine.add(jlInputName);
            JLabel jlFunction = new JLabel(AGGREGATE_FUNCTION);
            jlFunction.setPreferredSize(LARGE);
            titleLine.add(jlFunction);
            JLabel jlIgnoreNull = new JLabel(IGNORE_NULL);
            jlIgnoreNull.setPreferredSize(MEDIUM);
            jlIgnoreNull.setToolTipText(IGNORE_NULL);
            titleLine.add(jlIgnoreNull);
            JLabel jlFunctionParameter = new JLabel(PARAMETER);
            jlFunctionParameter.setPreferredSize(NARROW);
            jlFunctionParameter.setToolTipText(PARAMETER);
            titleLine.add(jlFunctionParameter);
            JButton jbPlus = new JButton(IconLoader.icon("plus.gif"));
            jbPlus.setToolTipText(ADD_AGGREGATE_FUNCTION);
            jbPlus.setPreferredSize(NARROW);
            titleLine.add(jbPlus);
            this.northPanel.add((Component)titleLine, "Center");
            this.aggregatorsPanel = new JPanel();
            this.aggregatorsPanel.setLayout(new BoxLayout(this.aggregatorsPanel, 1));
            jbPlus.addActionListener(e -> {
                this.aggregatorsPanel.add(new AttributeAggregatePanel(this, this.schema));
                SwingUtilities.getWindowAncestor(this.aggregatorsPanel).pack();
            });
            this.setLayout(new BorderLayout());
            this.add((Component)this.northPanel, "North");
            this.add((Component)this.aggregatorsPanel, "Center");
        }

        void setSchema(FeatureSchema schema) {
            this.schema = schema;
            this.aggregatorsPanel.removeAll();
        }

        JPanel getAggregatorsPanel() {
            return this.aggregatorsPanel;
        }

        List<AttributeAggregator> getAttributeAggregators() {
            ArrayList<AttributeAggregator> aggregators = new ArrayList<AttributeAggregator>();
            if (this.aggregatorsPanel != null) {
                Component[] components;
                for (Component component : components = this.aggregatorsPanel.getComponents()) {
                    if (!(component instanceof AttributeAggregatePanel)) continue;
                    AttributeAggregatePanel aap = (AttributeAggregatePanel)component;
                    Object selectedAttributeName = aap.jcbInputAttributeName.getSelectedItem();
                    Object selectedAggregator = aap.jcbAggregators.getSelectedItem();
                    if (selectedAttributeName == null || selectedAggregator == null) continue;
                    String inputName = selectedAttributeName.toString();
                    String outputName = aap.jtfOutputAttributeName.getText();
                    Aggregator<?> agg = ((Aggregator)selectedAggregator).clone();
                    agg.setIgnoreNull(aap.jcbIgnoreNull.isSelected());
                    if (aap.jtfParameter.isEnabled() && agg.getParameters().size() > 0) {
                        agg.setParameter(agg.getParameters().iterator().next(), aap.jtfParameter.getText());
                    }
                    AttributeAggregator aggregator = new AttributeAggregator(inputName, agg, outputName);
                    aggregators.add(aggregator);
                }
            }
            return aggregators;
        }
    }

    class KeyAttributePanel
    extends JPanel {
        final KeyOptionPanel keyOptionPanel;
        final FeatureSchema schema;
        final JComboBox<String> jcbInputAttributeName;
        final JButton jbRemove;

        KeyAttributePanel(KeyOptionPanel keyOptionPanel, FeatureSchema schema) throws Exception {
            this.setLayout(new FlowLayout());
            this.keyOptionPanel = keyOptionPanel;
            this.schema = schema;
            this.jcbInputAttributeName = new JComboBox();
            for (int i = 0; i < schema.getAttributeCount(); ++i) {
                this.jcbInputAttributeName.addItem(schema.getAttributeName(i));
            }
            this.jcbInputAttributeName.setSelectedItem(this.pickKeyAttribute(schema, keyOptionPanel.getKeyAttributes()));
            this.jcbInputAttributeName.setPreferredSize(LARGE);
            this.jbRemove = new JButton();
            this.jbRemove.setIcon(IconLoader.icon("remove.gif"));
            this.jbRemove.setPreferredSize(NARROW);
            this.jbRemove.setToolTipText(REMOVE_AGGREGATE_FUNCTION);
            this.jbRemove.addActionListener(e -> {
                if (keyOptionPanel.getKeyAttributes().size() > 1) {
                    keyOptionPanel.getKeyAttributesPanel().remove(this);
                    SwingUtilities.getWindowAncestor(keyOptionPanel).pack();
                }
            });
            this.add(this.jcbInputAttributeName);
            this.add(this.jbRemove);
        }

        public String getAttribute() {
            Object selection = this.jcbInputAttributeName.getSelectedItem();
            if (selection != null) {
                return selection.toString();
            }
            return null;
        }

        private String pickKeyAttribute(FeatureSchema schema, Set<String> set) throws Exception {
            for (int i = 0; i < schema.getAttributeCount(); ++i) {
                if (schema.getGeometryIndex() == i || schema.getExternalPrimaryKeyIndex() == i || set.contains(schema.getAttributeName(i))) continue;
                return schema.getAttributeName(i);
            }
            throw new Exception(I18N.getInstance().get(KEY + ".no-more-candidate-attribute"));
        }
    }

    class KeyOptionPanel
    extends JPanel {
        final JPanel northPanel;
        final JPanel keyAttributesPanel;
        FeatureSchema schema;

        KeyOptionPanel() {
            this.setLayout(new BorderLayout());
            this.northPanel = new JPanel(new BorderLayout());
            JPanel titleLine = new JPanel();
            JLabel jlInputName = new JLabel(ADD_KEY_ATTRIBUTE);
            jlInputName.setPreferredSize(LARGE);
            titleLine.add(jlInputName);
            JButton jbPlus = new JButton(IconLoader.icon("plus.gif"));
            jbPlus.setToolTipText(ADD_KEY_ATTRIBUTE);
            jbPlus.setPreferredSize(NARROW);
            titleLine.add(jbPlus);
            this.northPanel.add((Component)titleLine, "Center");
            this.keyAttributesPanel = new JPanel();
            this.keyAttributesPanel.setLayout(new BoxLayout(this.keyAttributesPanel, 1));
            jbPlus.addActionListener(e -> {
                try {
                    this.keyAttributesPanel.add(new KeyAttributePanel(this, this.schema));
                    SwingUtilities.getWindowAncestor(this.keyAttributesPanel).pack();
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            });
            JPanel westPanel = new JPanel(new BorderLayout());
            this.add((Component)westPanel, "West");
            westPanel.add((Component)this.northPanel, "North");
            westPanel.add((Component)this.keyAttributesPanel, "Center");
        }

        public void setSchema(FeatureSchema schema) throws Exception {
            this.schema = schema;
            if (schema.getAttributeCount() < 2) {
                throw new Exception(I18N.getInstance().get(KEY + ".no-available-attribute-to-group-by"));
            }
            this.keyAttributesPanel.removeAll();
            this.keyAttributesPanel.add(new KeyAttributePanel(this, schema));
        }

        public JPanel getKeyAttributesPanel() {
            return this.keyAttributesPanel;
        }

        public Set<String> getKeyAttributes() {
            LinkedHashSet<String> keyAttributeSet = new LinkedHashSet<String>();
            if (this.keyAttributesPanel != null) {
                Component[] components;
                for (Component component : components = this.keyAttributesPanel.getComponents()) {
                    if (!(component instanceof KeyAttributePanel)) continue;
                    KeyAttributePanel kap = (KeyAttributePanel)component;
                    keyAttributeSet.add(kap.getAttribute());
                }
            }
            return keyAttributeSet;
        }
    }
}

