/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.style;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.util.Range;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.OKCancelDialog;
import com.vividsolutions.jump.workbench.ui.TitledPopupMenu;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import com.vividsolutions.jump.workbench.ui.renderer.style.BasicStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.ColorThemingStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.LabelStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.VertexStyle;
import java.awt.Component;
import java.io.File;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilderFactory;
import org.openjump.core.ui.images.IconLoader;
import org.openjump.core.ui.plugin.style.StyleChooserPanel;
import org.openjump.core.ui.swing.SelectFromListPanel;
import org.openjump.util.SLDImporter;
import org.w3c.dom.Document;

public class ImportSLDPlugIn
extends AbstractPlugIn {
    public static final ImageIcon ICON = IconLoader.icon("sld_in_16.png");

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        FeatureInstaller featureInstaller = context.getFeatureInstaller();
        EnableCheck enableCheck = this.createEnableCheck(context.getWorkbenchContext());
        TitledPopupMenu popupMenu = context.getWorkbenchFrame().getLayerNamePopupMenu();
        featureInstaller.addPopupMenuItem(popupMenu, this, new String[]{MenuNames.STYLE}, this.getName(), false, ICON, enableCheck);
        featureInstaller.addMainMenuItem(this, new String[]{MenuNames.LAYER}, I18N.getInstance().get("org.openjump.core.ui.plugin.style.ImportSLDPlugIn.name"), false, ICON, enableCheck);
    }

    private static String fixAttribute(Layer l, WorkbenchFrame frame, String old) {
        FeatureSchema fs = l.getFeatureCollectionWrapper().getFeatureSchema();
        if (!fs.hasAttribute(old)) {
            if (old.indexOf(58) != -1) {
                old = old.substring(old.indexOf(58));
            }
            if (!fs.hasAttribute(old)) {
                old = old.toUpperCase();
            }
        }
        return ImportSLDPlugIn.chooseAttribute(l, old, frame);
    }

    private static void setStyles(Layer l, BasicStyle bs, VertexStyle vs, LabelStyle ls, ColorThemingStyle cts, WorkbenchFrame frame) {
        if (bs != null) {
            bs.setEnabled(true);
            l.removeStyle(l.getBasicStyle());
            l.addStyle(bs);
        }
        if (vs != null) {
            vs.setEnabled(true);
            l.removeStyle(l.getVertexStyle());
            l.addStyle(vs);
        }
        if (ls != null) {
            ls.setAttribute(ImportSLDPlugIn.fixAttribute(l, frame, ls.getAttribute()));
            ls.setEnabled(true);
            l.removeStyle(l.getLabelStyle());
            l.addStyle(ls);
        }
        if (cts != null) {
            cts.setAttributeName(ImportSLDPlugIn.fixAttribute(l, frame, cts.getAttributeName()));
            try {
                ImportSLDPlugIn.fixColorThemingAttributeMap(l, cts, frame);
                cts.setDefaultStyle(cts.getAttributeValueToBasicStyleMap().values().iterator().next());
                cts.setEnabled(true);
                l.removeStyle(l.getStyle(ColorThemingStyle.class));
                l.addStyle(cts);
            }
            catch (NumberFormatException e) {
                JOptionPane.showMessageDialog(frame, I18N.getInstance().get("org.openjump.core.ui.plugin.style.ImportSLDPlugIn.Number-Error-reading-styles", e.getLocalizedMessage()), I18N.getInstance().get("com.vividsolutions.wms.WMService.Error"), 0);
            }
        }
    }

    private static void fixColorThemingAttributeMap(Layer l, ColorThemingStyle cts, WorkbenchFrame frame) {
        FeatureSchema fs = l.getFeatureCollectionWrapper().getFeatureSchema();
        String a = cts.getAttributeName();
        try {
            BasicStyle s;
            TreeMap<Object, String> labelMap;
            Map<Object, BasicStyle> oldMap;
            TreeMap<Object, BasicStyle> map;
            AttributeType t = fs.getAttributeType(a);
            Class<?> c = t.toJavaClass();
            try {
                if (cts.getAttributeValueToLabelMap().keySet().iterator().next() instanceof Range) {
                    Range newRange;
                    Range r;
                    Logger.debug("Color theming values are ranges.");
                    Range.RangeTreeMap<Object, BasicStyle> map2 = new Range.RangeTreeMap<Object, BasicStyle>();
                    Range.RangeTreeMap<Object, String> labelMap2 = new Range.RangeTreeMap<Object, String>();
                    Map<Object, BasicStyle> oldMap2 = cts.getAttributeValueToBasicStyleMap();
                    Map<Object, String> oldLabelMap = cts.getAttributeValueToLabelMap();
                    if (c.equals(Integer.class)) {
                        Logger.debug("Color theming values are ranges of integers.");
                        for (Object k : cts.getAttributeValueToBasicStyleMap().keySet()) {
                            r = (Range)k;
                            newRange = new Range(Integer.valueOf((String)r.getMin()), r.isIncludingMin(), Integer.valueOf((String)r.getMax()), r.isIncludingMax());
                            map2.put(newRange, oldMap2.get(r));
                            labelMap2.put(newRange, oldLabelMap.get(r));
                        }
                    }
                    if (c.equals(Double.class)) {
                        Logger.debug("Color theming values are ranges of doubles.");
                        for (Object k : cts.getAttributeValueToBasicStyleMap().keySet()) {
                            r = (Range)k;
                            newRange = new Range(Double.valueOf((String)r.getMin()), r.isIncludingMin(), Double.valueOf((String)r.getMax()), r.isIncludingMax());
                            map2.put(newRange, oldMap2.get(r));
                            labelMap2.put(newRange, oldLabelMap.get(r));
                        }
                    }
                    if (Logger.isDebugEnabled()) {
                        Logger.debug("Color theming values are ranges of java class " + c + ".");
                    }
                    cts.setAttributeValueToBasicStyleMap(map2);
                    cts.setAttributeValueToLabelMap(labelMap2);
                    return;
                }
            }
            catch (NumberFormatException e) {
                throw e;
            }
            catch (Exception e) {
                Logger.debug("Unknown error: ", e);
                return;
            }
            if (c.equals(Integer.class)) {
                Logger.debug("Color theming values are integers.");
                map = new TreeMap<Object, BasicStyle>();
                oldMap = cts.getAttributeValueToBasicStyleMap();
                labelMap = new TreeMap<Object, String>();
                for (Object key : oldMap.keySet()) {
                    s = oldMap.get(key);
                    map.put(Integer.valueOf((String)key), s);
                    labelMap.put(Integer.valueOf((String)key), (String)key);
                }
                cts.setAttributeValueToBasicStyleMap(map);
                cts.setAttributeValueToLabelMap(labelMap);
            }
            if (c.equals(Double.class)) {
                Logger.debug("Color theming values are doubles.");
                map = new TreeMap();
                oldMap = cts.getAttributeValueToBasicStyleMap();
                labelMap = new TreeMap();
                for (Object key : oldMap.keySet()) {
                    s = oldMap.get(key);
                    map.put(Double.valueOf((String)key), s);
                    labelMap.put(Double.valueOf((String)key), (String)key);
                }
                cts.setAttributeValueToBasicStyleMap(map);
                cts.setAttributeValueToLabelMap(labelMap);
            }
            if (Logger.isDebugEnabled()) {
                Logger.debug("Color theming values are of java type " + c + ".");
            }
            return;
        }
        catch (NumberFormatException e) {
            throw e;
        }
        catch (IllegalArgumentException e) {
            JOptionPane.showMessageDialog(frame, I18N.getInstance().get("org.openjump.core.ui.plugin.style.ImportSLDPlugIn.Error-reading-styles", e.getLocalizedMessage()), I18N.getInstance().get("com.vividsolutions.wms.WMService.Error"), 0);
            Logger.debug("Probably unknown attribute name: ", e);
            return;
        }
    }

    private static String chooseAttribute(Layer l, String def, WorkbenchFrame frame) {
        final SelectFromListPanel panel = new SelectFromListPanel("none");
        Vector<String> list = new Vector<String>();
        FeatureSchema fs = l.getFeatureCollectionWrapper().getFeatureSchema();
        for (int i = 0; i < fs.getAttributeCount(); ++i) {
            list.add(fs.getAttributeName(i));
        }
        if (list.size() == 1) {
            return (String)list.firstElement();
        }
        panel.list.setListData(list);
        if (list.contains(def)) {
            panel.list.setSelectedValue(def, true);
        }
        OKCancelDialog dlg = new OKCancelDialog(frame, I18N.getInstance().get("org.openjump.core.ui.plugin.style.ImportSLDPlugIn.Select-Attribute"), true, (Component)panel, new OKCancelDialog.Validator(){

            @Override
            public String validateInput(Component component) {
                return panel.list.getSelectedValue() == null ? I18N.getInstance().get("org.openjump.core.ui.plugin.style.ImportSLDPlugIn.Must-Select-Attribute") : null;
            }
        });
        dlg.setVisible(true);
        return dlg.wasOKPressed() ? (String)panel.list.getSelectedValue() : null;
    }

    public static void importSLD(Document doc, PlugInContext context) {
        OKCancelDialog dlg;
        Layer l = context.getSelectedLayer(0);
        LinkedList<String> rules = SLDImporter.getRuleNames(doc);
        if (rules.isEmpty()) {
            JOptionPane.showMessageDialog(context.getWorkbenchFrame(), I18N.getInstance().get("org.openjump.core.ui.plugin.style.ImportSLDPlugIn.No-Styles-Found"), I18N.getInstance().get("com.vividsolutions.wms.WMService.Error"), 1);
            return;
        }
        if (rules.size() == 1) {
            ImportSLDPlugIn.setStyles(l, SLDImporter.getBasicStyle(rules.peek(), doc), SLDImporter.getVertexStyle(rules.peek(), doc), SLDImporter.getLabelStyle(rules.peek(), doc), SLDImporter.getColorThemingStyle(rules.peek(), doc), context.getWorkbenchFrame());
            return;
        }
        do {
            final StyleChooserPanel panel = new StyleChooserPanel(doc);
            dlg = new OKCancelDialog(context.getWorkbenchFrame(), I18N.getInstance().get("org.openjump.core.ui.plugin.style.ImportSLDPlugIn.Choose-Style"), true, (Component)panel, new OKCancelDialog.Validator(){

                @Override
                public String validateInput(Component component) {
                    return panel.getSelectedStyle() == null ? I18N.getInstance().get("org.openjump.core.ui.plugin.style.ImportSLDPlugIn.Must-Select-Style") : null;
                }
            });
            dlg.setVisible(true);
            if (!dlg.wasOKPressed()) continue;
            ImportSLDPlugIn.setStyles(l, SLDImporter.getBasicStyle(panel.getSelectedStyle(), doc), SLDImporter.getVertexStyle(panel.getSelectedStyle(), doc), SLDImporter.getLabelStyle(panel.getSelectedStyle(), doc), SLDImporter.getColorThemingStyle(panel.getSelectedStyle(), doc), context.getWorkbenchFrame());
        } while (dlg.wasOKPressed() && JOptionPane.showConfirmDialog(context.getWorkbenchFrame(), I18N.getInstance().get("org.openjump.core.ui.plugin.style.ImportSLDPlugIn.Select-Another-Style"), I18N.getInstance().get("org.openjump.core.ui.plugin.style.ImportSLDPlugIn.Question"), 0) == 0);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        int res;
        Blackboard bb = PersistentBlackboardPlugIn.get(context.getWorkbenchContext());
        String fileName = (String)bb.get("ImportSLDPlugin.filename");
        JFileChooser chooser = new JFileChooser();
        if (fileName != null) {
            chooser.setCurrentDirectory(new File(fileName).getParentFile());
        }
        if ((res = chooser.showOpenDialog(context.getWorkbenchFrame())) == 0) {
            File f = chooser.getSelectedFile();
            bb.put("ImportSLDPlugin.filename", f.getAbsoluteFile().toString());
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            Document doc = dbf.newDocumentBuilder().parse(f);
            ImportSLDPlugIn.importSLD(doc, context);
        }
        return false;
    }

    @Override
    public String getName() {
        return I18N.getInstance().get("org.openjump.core.ui.plugin.style.ImportSLDPlugIn.name");
    }

    public EnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory ecf = EnableCheckFactory.getInstance(workbenchContext);
        MultiEnableCheck mec = new MultiEnableCheck().add(ecf.createWindowWithLayerNamePanelMustBeActiveCheck()).add(ecf.createExactlyNLayerablesMustBeSelectedCheck(1, Layerable.class));
        return mec;
    }
}

