/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.raster.color;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.ColorChooserPanel;
import com.vividsolutions.jump.workbench.ui.ColorPanel;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.OKCancelPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.NoninvertibleTransformException;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.rasterimage.sextante.OpenJUMPSextanteRasterLayer;
import org.openjump.core.ui.plugin.raster.color.RasterColorEditor;

public class RasterColorEditorDialog
extends JDialog {
    private RasterImageLayer layer = null;
    private JTextField fromValue;
    private JLabel fromValueLabel;
    private JLabel toValueLabel;
    private JTextField toValue;
    private JLabel layerLabel;
    private JComboBox colorScaleChooser;
    private String[] colorTableList = new String[]{I18N.getInstance().get("org.openjump.core.ui.plugin.raster.color.RasterColorEditorDialog.Default-colors"), I18N.getInstance().get("org.openjump.core.ui.plugin.raster.color.RasterColorEditorDialog.Green-Yellow-Red"), I18N.getInstance().get("org.openjump.core.ui.plugin.raster.color.RasterColorEditorDialog.Blue-Green-Red"), I18N.getInstance().get("org.openjump.core.ui.plugin.raster.color.RasterColorEditorDialog.Red-Blue"), I18N.getInstance().get("org.openjump.core.ui.plugin.raster.color.RasterColorEditorDialog.Blue-Red"), I18N.getInstance().get("org.openjump.core.ui.plugin.raster.color.RasterColorEditorDialog.Black-White"), I18N.getInstance().get("org.openjump.core.ui.plugin.raster.color.RasterColorEditorDialog.White-Black"), I18N.getInstance().get("org.openjump.core.ui.plugin.raster.color.RasterColorEditorDialog.Rainbow")};
    private JPanel mainPanel = new JPanel();
    private OKCancelPanel okCancelPanel = new OKCancelPanel();
    private PlugInContext plugInContext;
    private Border border = BorderFactory.createEmptyBorder(10, 10, 10, 10);
    private Border borderRaised = BorderFactory.createRaisedBevelBorder();
    private Border borderLowerered = BorderFactory.createLoweredBevelBorder();
    private Color[] valuesColors;
    private Color noDataColor;
    private LayoutManager layout = new BorderLayout();
    private ColorChooserPanel colorChooser;
    private LayoutManager gridBagLayout = new GridBagLayout();
    private JButton NoDataColorButton = new JButton();
    private JLabel NodataColor = new JLabel(I18N.getInstance().get("org.openjump.core.ui.plugin.raster.color.RasterColorEditorDialog.No-data-color"));
    private ColorPanel NoDataColorPanel = new ColorPanel();
    private JCheckBox transparent = new JCheckBox(I18N.getInstance().get("org.openjump.core.ui.plugin.raster.color.RasterColorEditorDialog.Transparency"));
    private int alpha = 255;
    private JPanel panelSeparator = new JPanel();
    private boolean enabled = true;
    private String sToolTip = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.color.RasterColorEditorPlugIn.Choose-a-color-range-It-will-be-automaticaly-expanded-between-the-2-values");
    private String sColorRange = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.color.RasterColorEditorPlugIn.Color-range");
    private String sFromValue = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.color.RasterColorEditorPlugIn.From-value");
    private String sToValue = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.color.RasterColorEditorPlugIn.To-value");
    private String sNoDataValueColor = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.color.RasterColorEditorPlugIn.no-data-value-color");
    private String sChange = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.color.RasterColorEditorPlugIn.change");
    private String sChoseOtherColor = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.color.RasterColorEditorPlugIn.Choose-other-color-for-no-data-values");
    private String sToggleTransparency = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.color.RasterColorEditorPlugIn.Toggle-transparency-for-no-data-values");
    private String sSelectColor = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.color.RasterColorEditorPlugIn.Select-color");
    private String sLayerName = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.color.RasterColorEditorPlugIn.Selected-Layer");

    public RasterColorEditorDialog(PlugInContext context, RasterImageLayer actualLayer) {
        super(context.getWorkbenchFrame(), I18N.getInstance().get("org.openjump.core.ui.plugin.raster.color.RasterColorEditorPlugIn.Raster-Color-Editor"), true);
        this.plugInContext = context;
        this.setLayer(actualLayer);
        this.setResizable(true);
        this.setSize(500, 350);
        GUIUtil.setLocation(this, new GUIUtil.Location(100, true, 100, true), this.plugInContext.getWorkbenchFrame());
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setLayer(RasterImageLayer actualLayer) {
        this.layer = actualLayer;
    }

    void jbInit() throws Exception {
        this.setLayout(this.layout);
        this.add((Component)this.okCancelPanel, "South");
        this.okCancelPanel.setOKPressed(false);
        this.okCancelPanel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    RasterColorEditorDialog.this.okCancelPanel_actionPerformed(e);
                }
                catch (NumberFormatException e1) {
                    e1.printStackTrace();
                }
                catch (NoninvertibleTransformException e1) {
                    e1.printStackTrace();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.layerLabel = new JLabel(this.sLayerName + ": " + this.layer.getName());
        this.layerLabel.setBorder(this.border);
        this.add((Component)this.layerLabel, "North");
        this.mainPanel.setBorder(this.border);
        this.mainPanel.setLayout(this.gridBagLayout);
        GridBagConstraints c = new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 18, 2, new Insets(10, 10, 0, 10), 0, 0);
        this.colorScaleChooser = new JComboBox<String>(this.colorTableList);
        this.colorScaleChooser.setSelectedIndex(0);
        String fieldName = this.sColorRange;
        this.colorScaleChooser.setToolTipText(this.sToolTip);
        this.colorScaleChooser.setBorder(this.borderRaised);
        this.mainPanel.add((Component)this.colorScaleChooser, c);
        OpenJUMPSextanteRasterLayer ojraster = new OpenJUMPSextanteRasterLayer();
        ojraster.create(this.layer, false);
        this.fromValue = new JTextField(Double.toString(ojraster.getMinValue()), 15);
        this.fromValueLabel = new JLabel(this.sFromValue);
        this.fromValue.setCaretPosition(0);
        this.fromValue.selectAll();
        this.toValue = new JTextField(Double.toString(ojraster.getMaxValue()), 15);
        this.toValue.setCaretPosition(0);
        this.fromValue.selectAll();
        this.toValueLabel = new JLabel(this.sToValue);
        this.panelSeparator.setSize(300, 50);
        this.NoDataColorPanel.setFillColor(Color.WHITE);
        this.NoDataColorPanel.setLineColor(Color.BLACK);
        this.NoDataColorPanel.setBorder(this.borderLowerered);
        this.NoDataColorPanel.setToolTipText(this.sNoDataValueColor);
        this.NoDataColorButton.setText(this.sChange);
        this.NoDataColorButton.setToolTipText(this.sChoseOtherColor);
        this.NoDataColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RasterColorEditorDialog.this.changeButton_actionPerformed(e);
            }
        });
        this.transparent.setToolTipText(this.sToggleTransparency);
        this.transparent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RasterColorEditorDialog.this.transparent_actionPerformed(e);
            }
        });
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 1;
        c.gridwidth = 1;
        this.mainPanel.add((Component)this.fromValueLabel, c);
        c.gridx = 0;
        c.gridy = 2;
        c.gridwidth = 1;
        this.mainPanel.add((Component)this.fromValue, c);
        c.weightx = 1.0;
        c.gridx = 3;
        c.gridy = 1;
        c.gridwidth = 1;
        this.mainPanel.add((Component)this.toValueLabel, c);
        c.gridx = 3;
        c.gridy = 2;
        c.gridwidth = 1;
        this.mainPanel.add((Component)this.toValue, c);
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridx = 0;
        c.gridy = 3;
        c.gridheight = 2;
        c.gridwidth = 4;
        c.ipady = 40;
        this.mainPanel.add((Component)this.panelSeparator, c);
        this.add((Component)this.mainPanel, "Center");
    }

    void okCancelPanel_actionPerformed(ActionEvent e) throws NumberFormatException, NoninvertibleTransformException, IOException {
        if (!this.okCancelPanel.wasOKPressed()) {
            this.setVisible(false);
            return;
        }
        if (this.okCancelPanel.wasOKPressed() && this.validateInput()) {
            switch (this.colorScaleChooser.getSelectedIndex()) {
                case 0: {
                    this.valuesColors = null;
                    break;
                }
                case 1: {
                    this.valuesColors = new Color[]{Color.GREEN, Color.YELLOW, Color.RED};
                    break;
                }
                case 2: {
                    this.valuesColors = new Color[]{Color.BLUE, Color.GREEN, Color.RED};
                    break;
                }
                case 3: {
                    this.valuesColors = new Color[]{Color.RED, Color.BLUE};
                    break;
                }
                case 4: {
                    this.valuesColors = new Color[]{Color.BLUE, Color.RED};
                    break;
                }
                case 5: {
                    this.valuesColors = new Color[]{Color.WHITE, Color.BLACK};
                    break;
                }
                case 6: {
                    this.valuesColors = new Color[]{Color.BLACK, Color.WHITE};
                    break;
                }
                case 7: {
                    this.valuesColors = new Color[]{Color.decode("#9400D3"), Color.decode("#4B0082"), Color.BLUE, Color.GREEN, Color.YELLOW, Color.ORANGE, Color.RED};
                }
            }
            RasterColorEditor colorEditor = new RasterColorEditor(this.layer);
            colorEditor.changeColors(this.plugInContext.getWorkbenchContext(), this.valuesColors, GUIUtil.alphaColor(this.NoDataColorPanel.getFillColor(), this.alpha), Float.parseFloat(this.fromValue.getText()), Float.parseFloat(this.toValue.getText()));
            this.setVisible(false);
            return;
        }
        this.plugInContext.getWorkbenchFrame().warnUser("min > max!");
    }

    private boolean validateInput() {
        return Float.parseFloat(this.fromValue.getText()) < Float.parseFloat(this.toValue.getText());
    }

    void changeButton_actionPerformed(ActionEvent e) {
        Color newColor = JColorChooser.showDialog(SwingUtilities.windowForComponent(this), this.sSelectColor, Color.WHITE);
        if (newColor == null) {
            return;
        }
        this.NoDataColorPanel.setFillColor(newColor);
        this.NoDataColorPanel.repaint();
    }

    void transparent_actionPerformed(ActionEvent e) {
        if (this.transparent.isSelected()) {
            this.alpha = 0;
            this.enabled = false;
        } else {
            this.alpha = 255;
            this.enabled = true;
        }
        this.NoDataColorButton.setEnabled(this.enabled);
        this.NoDataColorPanel.setVisible(this.enabled);
    }
}

