/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.raster;

import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.geom.EnvelopeUtil;
import com.vividsolutions.jump.util.ColorUtil;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.renderer.style.BasicStyle;
import com.vividsolutions.jump.workbench.ui.renderer.style.ColorScheme;
import com.vividsolutions.jump.workbench.ui.renderer.style.ColorThemingStyle;
import java.awt.Color;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.TreeMap;
import org.openjump.core.rasterimage.RasterImageLayer;

public class Utils {
    public static WorkbenchFrame frame = JUMPWorkbench.getInstance().getFrame();

    public static void zoom(RasterImageLayer rLayer) throws NoninvertibleTransformException {
        frame.getContext().getLayerViewPanel().getViewport().zoom(EnvelopeUtil.bufferByFraction(rLayer.getWholeImageEnvelope(), 0.03));
    }

    public static void applyRandomGradualStyle(Layer layer, String attribute) throws Exception {
        FeatureCollectionWrapper featDataset = layer.getFeatureCollectionWrapper();
        ColorScheme colorScheme = ColorUtil.createRandomColorSchema(featDataset.size());
        TreeMap<Object, BasicStyle> attributeToStyleMap = new TreeMap<Object, BasicStyle>();
        for (Feature feature : featDataset) {
            attributeToStyleMap.put(feature.getAttribute(attribute), new BasicStyle(colorScheme.next()));
        }
        layer.getBasicStyle().setEnabled(false);
        ColorThemingStyle themeStyle = new ColorThemingStyle(attribute, attributeToStyleMap, new BasicStyle(Color.gray));
        themeStyle.setEnabled(true);
        layer.addStyle(themeStyle);
        ColorThemingStyle.get(layer).setEnabled(true);
        layer.removeStyle(ColorThemingStyle.get(layer));
        ColorThemingStyle.get(layer).setEnabled(true);
        layer.getBasicStyle().setEnabled(false);
        layer.fireAppearanceChanged();
    }

    public static void applyGradualStyle(Layer layer, String attribute, Color startColor, Color endColor) throws Exception {
        FeatureCollectionWrapper featDataset = layer.getFeatureCollectionWrapper();
        ColorScheme colorScheme = ColorUtil.createColorSchema(featDataset.size(), startColor, endColor);
        TreeMap<Object, BasicStyle> attributeToStyleMap = new TreeMap<Object, BasicStyle>();
        for (Feature feature : featDataset) {
            attributeToStyleMap.put(feature.getAttribute(attribute), new BasicStyle(colorScheme.next()));
        }
        layer.getBasicStyle().setEnabled(false);
        ColorThemingStyle themeStyle = new ColorThemingStyle(attribute, attributeToStyleMap, new BasicStyle(Color.gray));
        themeStyle.setEnabled(true);
        layer.addStyle(themeStyle);
        ColorThemingStyle.get(layer).setEnabled(true);
        layer.removeStyle(ColorThemingStyle.get(layer));
        ColorThemingStyle.get(layer).setEnabled(true);
        layer.getBasicStyle().setEnabled(false);
        layer.fireAppearanceChanged();
    }

    public static void applyAlternateStyle(Layer layer, String attribute, int interval, int subInterval, Color color1, Color color2) throws Exception {
        FeatureCollectionWrapper featDataset = layer.getFeatureCollectionWrapper();
        ArrayList<Color> arrayColor = new ArrayList<Color>();
        for (int c = 1; c < interval; ++c) {
            if (c % subInterval == 0) {
                arrayColor.add(color1);
                continue;
            }
            arrayColor.add(color2);
        }
        ColorScheme colorScheme = new ColorScheme("test", arrayColor);
        TreeMap<Object, BasicStyle> attributeToStyleMap = new TreeMap<Object, BasicStyle>();
        for (Feature feature : featDataset) {
            attributeToStyleMap.put(feature.getAttribute(attribute), new BasicStyle(colorScheme.next()));
        }
        layer.getBasicStyle().setEnabled(false);
        ColorThemingStyle themeStyle = new ColorThemingStyle(attribute, attributeToStyleMap, new BasicStyle(Color.gray));
        themeStyle.setEnabled(true);
        layer.addStyle(themeStyle);
        ColorThemingStyle.get(layer).setEnabled(true);
        layer.removeStyle(ColorThemingStyle.get(layer));
        ColorThemingStyle.get(layer).setEnabled(true);
        layer.getBasicStyle().setEnabled(false);
        layer.fireAppearanceChanged();
    }
}

