/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.layer.pirolraster;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.util.FileUtil;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.datasource.SaveFileDataSourceQueryChooser;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.PersistentBlackboardPlugIn;
import java.io.File;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import org.locationtech.jts.geom.Envelope;
import org.openjump.core.apitools.LayerTools;
import org.openjump.core.rasterimage.RasterImageIOUtils;
import org.openjump.core.rasterimage.RasterImageLayer;

public class SaveRasterImageAsImagePlugIn
extends AbstractPlugIn {
    private static final String FILE_CHOOSER_DIRECTORY_KEY = SaveFileDataSourceQueryChooser.class.getName() + " - FILE CHOOSER DIRECTORY";
    private static String ERROR = I18N.getInstance().get("org.openjump.core.ui.plugin.mousemenu.SaveDatasetsPlugIn.Error-See-Output-Window");
    private static String PLUGINNAME = I18N.getInstance().get("org.openjump.core.ui.plugin.layer.pirolraster.SaveRasterImageAsImagePlugIn.Save-Raster-Image-As-Image");
    private static String SAVED = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.file.saved");
    private static HashMap extensions;
    public static final String TIF_EXTENSION = "TIF";
    private static File file;
    private static File fileHDR;
    public static final ImageIcon ICON;

    public SaveRasterImageAsImagePlugIn() {
        extensions = new HashMap();
        extensions.put("ASC", "ASC");
        extensions.put("FLT", "FLT");
        extensions.put(TIF_EXTENSION, TIF_EXTENSION);
    }

    @Override
    public String getName() {
        return PLUGINNAME;
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        SaveRasterImageAsImagePlugIn.saveSingleRaster(context);
        return true;
    }

    public static void saveSingleRaster(PlugInContext context) throws Exception {
        RasterImageLayer rLayer = (RasterImageLayer)LayerTools.getSelectedLayerable(context, RasterImageLayer.class);
        Envelope env = rLayer.getWholeImageEnvelope();
        int bands = rLayer.getNumBands();
        JFileChooser fileChooser = GUIUtil.createJFileChooserWithOverwritePrompting();
        fileChooser.setDialogTitle(PLUGINNAME);
        if (PersistentBlackboardPlugIn.get(context.getWorkbenchContext()).get(FILE_CHOOSER_DIRECTORY_KEY) != null) {
            fileChooser.setCurrentDirectory(new File((String)PersistentBlackboardPlugIn.get(context.getWorkbenchContext()).get(FILE_CHOOSER_DIRECTORY_KEY)));
        }
        fileChooser.setMultiSelectionEnabled(false);
        if (bands == 1) {
            fileChooser.setFileFilter(GUIUtil.createFileFilter("Raster grid", new String[]{"asc", "flt", "tif"}));
        } else {
            fileChooser.setFileFilter(GUIUtil.createFileFilter("Raster image", new String[]{"tif"}));
        }
        int option = fileChooser.showSaveDialog(context.getWorkbenchFrame());
        if (option == 0) {
            file = fileChooser.getSelectedFile();
            fileHDR = fileChooser.getSelectedFile();
            file = FileUtil.addExtensionIfNone(file, "tif");
            String extension = FileUtil.getExtension(file);
            fileHDR = FileUtil.removeExtensionIfAny(fileHDR);
            fileHDR = FileUtil.addExtensionIfNone(fileHDR, "hdr");
            String catName = StandardCategoryNames.WORKING;
            try {
                catName = ((Category)context.getLayerNamePanel().getSelectedCategories().toArray()[0]).getName();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            int band = 0;
            String trueExtension = (String)extensions.get(extension.toUpperCase());
            if (trueExtension.equalsIgnoreCase("ASC")) {
                RasterImageIOUtils.saveASC(file, context, rLayer, band);
                RasterImageIOUtils.loadASC(file, context, catName);
            } else if (trueExtension.equalsIgnoreCase("FLT")) {
                RasterImageIOUtils.saveFLT(file, context, rLayer, band);
                RasterImageIOUtils.saveHDR(fileHDR, context, rLayer);
                RasterImageIOUtils.loadFLT(file, context, catName);
            } else if (trueExtension.equalsIgnoreCase(TIF_EXTENSION)) {
                RasterImageIOUtils.saveTIF(file, rLayer, env);
                RasterImageIOUtils.loadTIF(file, context, catName);
            }
            rLayer.setNeedToKeepImage(false);
            context.getWorkbenchFrame().setStatusMessage(SAVED);
        }
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        MultiEnableCheck multiEnableCheck = new MultiEnableCheck();
        multiEnableCheck.add(checkFactory.createExactlyNLayerablesMustBeSelectedCheck(1, RasterImageLayer.class));
        return multiEnableCheck;
    }

    static {
        ICON = IconLoader.icon("disk_dots.png");
    }
}

