/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.file;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.io.datasource.DataSource;
import com.vividsolutions.jump.io.datasource.DataSourceQuery;
import com.vividsolutions.jump.io.datasource.StandardReaderWriterFileDataSource;
import com.vividsolutions.jump.task.DummyTaskMonitor;
import com.vividsolutions.jump.util.FileUtil;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerView;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import org.openjump.core.ui.plugin.file.open.JFCWithEnterAction;

public class SaveLayersWithoutDataSourcePlugIn
extends AbstractPlugIn {
    private static final String KEY = SaveLayersWithoutDataSourcePlugIn.class.getName();
    private static final String LAYERS_WITHOUT_DATASOURCE = I18N.getInstance().get("org.openjump.core.ui.plugin.file.SaveLayersWithoutDataSourcePlugIn.layers-without-datasource-management");
    private static final String DONOTSAVE = I18N.getInstance().get("org.openjump.core.ui.plugin.file.SaveLayersWithoutDataSourcePlugIn.do-not-save");
    private static final String SAVEASJML = I18N.getInstance().get("org.openjump.core.ui.plugin.file.SaveLayersWithoutDataSourcePlugIn.save-as-jml");
    private static final String SAVEASSHP = I18N.getInstance().get("org.openjump.core.ui.plugin.file.SaveLayersWithoutDataSourcePlugIn.save-as-shp");
    private static final String FILECHOOSER = I18N.getInstance().get("org.openjump.core.ui.plugin.file.SaveLayersWithoutDataSourcePlugIn.directory-chooser");
    private static final String WARN_USER = I18N.getInstance().get("org.openjump.core.ui.plugin.file.SaveLayersWithoutDataSourcePlugIn.every-layer-has-a-datasource");
    public static final ImageIcon ICON = IconLoader.icon("disks_dots.png");
    private JFileChooser fileChooser;

    @Override
    public String getName() {
        return I18N.getInstance().get(KEY);
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        this.fileChooser = new JFCWithEnterAction();
        this.fileChooser.setFileSelectionMode(1);
        this.fileChooser.setDialogTitle(FILECHOOSER);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Collection<Layer> layersWithoutDataSource = this.layersWithoutDataSource(context.getTask());
        if (layersWithoutDataSource.size() == 0) {
            context.getWorkbenchFrame().warnUser(WARN_USER);
            return false;
        }
        int ret = this.fileChooser.showSaveDialog(context.getWorkbenchFrame());
        if (ret == 0) {
            return this.execute(context, layersWithoutDataSource, this.fileChooser.getSelectedFile());
        }
        return false;
    }

    public boolean execute(PlugInContext context, Collection<Layer> collection, File dir) throws Exception {
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), LAYERS_WITHOUT_DATASOURCE, true);
        String tooltip = "<html>" + Arrays.toString(collection.toArray(new Object[0])).replaceAll(",", "<br>") + "</html>";
        dialog.addSubTitle(I18N.getInstance().get("org.openjump.core.ui.plugin.file.SaveLayersWithoutDataSourcePlugIn.layers-without-datasource", collection.size())).setToolTipText(tooltip);
        dialog.addLabel(I18N.getInstance().get("org.openjump.core.ui.plugin.file.SaveLayersWithoutDataSourcePlugIn.hover-the-label-to-see-the-list")).setToolTipText(tooltip);
        dialog.addRadioButton(DONOTSAVE, "ACTION", true, "");
        dialog.addRadioButton(SAVEASJML, "ACTION", false, "");
        dialog.addRadioButton(SAVEASSHP, "ACTION", false, "");
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (dialog.wasOKPressed()) {
            if (dialog.getBoolean(DONOTSAVE)) {
                return false;
            }
            dir.mkdir();
            String ext = null;
            for (Layer layer : collection) {
                File file = this.getFile(layer, dir, ext);
                StandardReaderWriterFileDataSource.ClassicReaderWriterFileDataSource dataSource = null;
                if (dialog.getBoolean(SAVEASJML)) {
                    ext = "jml";
                    dataSource = new StandardReaderWriterFileDataSource.JML();
                } else if (dialog.getBoolean(SAVEASSHP)) {
                    ext = "shp";
                    dataSource = new StandardReaderWriterFileDataSource.Shapefile();
                }
                if (dataSource != null) {
                    if (file.exists()) {
                        if (!GUIUtil.showConfirmOverwriteDialog(context.getWorkbenchFrame(), file)) continue;
                        this.saveLayer(layer, dir, dataSource, ext);
                        continue;
                    }
                    this.saveLayer(layer, dir, dataSource, ext);
                    continue;
                }
                Logger.warn("Data source (jml or shp) could not be instanciated to save dataset on disk");
            }
            return true;
        }
        return false;
    }

    private void saveLayer(Layer layer, File dir, DataSource dataSource, String ext) throws Exception {
        File file = this.getFile(layer, dir, ext);
        String path = file.getAbsolutePath();
        HashMap<String, Object> dp = new HashMap<String, Object>();
        dp.put("Uri", file.toURI().toString());
        dp.put("File", path);
        dataSource.setProperties(dp);
        DataSourceQuery dsq = new DataSourceQuery(dataSource, path, path);
        layer.setDataSourceQuery(dsq).setFeatureCollectionModified(false);
        if (layer instanceof LayerView) {
            return;
        }
        dataSource.getConnection().executeUpdate("", layer.getFeatureCollectionWrapper(), new DummyTaskMonitor());
    }

    private File getFile(Layer layer, File dir, String ext) {
        String name = FileUtil.getFileNameFromLayerName(layer.getName());
        int dotPos = name.indexOf(".");
        if (dotPos > 0) {
            name = name.substring(0, dotPos);
        }
        File fileName = FileUtil.addExtensionIfNone(new File(name), ext);
        return new File(dir, fileName.getName());
    }

    private Collection<Layer> layersWithoutDataSource(Task task) {
        ArrayList<Layer> layersWithoutDataSource = new ArrayList<Layer>();
        for (Layer layer : task.getLayerManager().getLayers()) {
            if (layer.hasReadableDataSource()) continue;
            layersWithoutDataSource.add(layer);
        }
        return layersWithoutDataSource;
    }

    public EnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        final WorkbenchContext wc = workbenchContext;
        EnableCheckFactory enableCheckFactory = EnableCheckFactory.getInstance(workbenchContext);
        MultiEnableCheck enableCheck = new MultiEnableCheck();
        enableCheck.add(enableCheckFactory.createWindowWithLayerManagerMustBeActiveCheck());
        enableCheck.add(new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return SaveLayersWithoutDataSourcePlugIn.this.layersWithoutDataSource(wc.getTask()).size() > 0 ? null : I18N.getInstance().get("org.openjump.core.ui.plugin.file.SaveLayersWithoutDataSourcePlugIn.a-layer-without-datasource-must-exist");
            }
        });
        return enableCheck;
    }
}

