/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.edit;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import java.util.ArrayList;
import java.util.List;

public class SelectAllModifiedFeaturesPlugIn
extends AbstractPlugIn {
    public SelectAllModifiedFeaturesPlugIn() {
        super(I18N.getInstance().get("org.openjump.core.ui.plugin.edit.SelectAllModifiedFeaturesPlugIn.select-all-modified-features"));
        this.setShortcutKeys(65);
        this.setShortcutModifiers(3);
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.EDIT, MenuNames.SELECTION}, this.getName(), false, null, this.createEnableCheck(context.getWorkbenchContext()));
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        ArrayList<Feature> selectedFeatures = new ArrayList<Feature>();
        LayerViewPanel layerViewPanel = context.getWorkbenchContext().getLayerViewPanel();
        layerViewPanel.getSelectionManager().clear();
        List<Layer> layers = context.getLayerManager().getLayers();
        for (Layer layer : layers) {
            selectedFeatures.clear();
            if (layer.isVisible()) {
                FeatureCollectionWrapper featureCollection = layer.getFeatureCollectionWrapper();
                for (Feature feature : featureCollection.getFeatures()) {
                    if (!(feature instanceof BasicFeature) || !((BasicFeature)feature).isModified()) continue;
                    selectedFeatures.add(feature);
                }
            }
            if (selectedFeatures.size() <= 0) continue;
            layerViewPanel.getSelectionManager().getFeatureSelection().selectItems(layer, selectedFeatures);
        }
        return true;
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck());
    }
}

