/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.edit;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.LayerViewPanel;
import com.vividsolutions.jump.workbench.ui.SelectionManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;

public class InvertSelectionPlugIn
extends AbstractPlugIn {
    private String name = I18N.getInstance().get("org.openjump.core.ui.plugin.edit.InvertSelectionPlugIn.invert-selection");

    public InvertSelectionPlugIn() {
        this.setShortcutKeys(73);
        this.setShortcutModifiers(2);
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        this.reportNothingToUndoYet(context);
        ArrayList<Feature> newSelectedFeatures = new ArrayList<Feature>();
        LayerViewPanel layerViewPanel = context.getWorkbenchContext().getLayerViewPanel();
        SelectionManager selectionManager = layerViewPanel.getSelectionManager();
        Collection<Layer> layers = selectionManager.getLayersWithSelectedItems();
        for (Layer layer : layers) {
            newSelectedFeatures.clear();
            Collection<Feature> oldSelectedFeatures = selectionManager.getFeaturesWithSelectedItems(layer);
            selectionManager.getFeatureSelection().unselectItems(layer);
            if (layer.isVisible()) {
                TreeSet<Integer> ids = new TreeSet<Integer>();
                for (Feature oldF : oldSelectedFeatures) {
                    ids.add(oldF.getID());
                }
                FeatureCollectionWrapper featureCollection = layer.getFeatureCollectionWrapper();
                for (Feature feature : featureCollection.getFeatures()) {
                    if (ids.contains(feature.getID())) continue;
                    newSelectedFeatures.add(feature);
                }
            }
            selectionManager.getFeatureSelection().selectItems(layer, newSelectedFeatures);
        }
        return true;
    }

    public MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        return new MultiEnableCheck().add(checkFactory.createWindowWithLayerViewPanelMustBeActiveCheck()).add(checkFactory.createAtLeastNItemsMustBeSelectedCheck(1));
    }

    @Override
    public String getName() {
        return this.name;
    }
}

