/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.edit;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureCollectionWrapper;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.tools.AttributeMapping;
import com.vividsolutions.jump.tools.OverlayEngine;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.FenceLayerFinder;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.EnableCheck;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.HTMLFrame;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.MultiInputDialog;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.JComponent;

public class ClipToFencePlugIn
extends AbstractPlugIn
implements ThreadedPlugIn {
    private static String FENCELAYERMUSTBEPRESENT = "Fence layer must be present";
    private static String DIALOGMSG = "All vector layers will be clipped to the Fence. Warning: if your task loaded with layers not visible, they have not be loaded and therefore will not be clipped.";
    private static String DIALOGWARNING = "This operation is not undoable.";
    private static String VISIBLEONLY = "Visible Only (see Warning)";
    private static final boolean POLYGON_OUTPUT = false;
    private WorkbenchContext workbenchContext;
    private boolean visibleOnly = true;

    @Override
    public String getName() {
        return I18N.getInstance().get("org.openjump.core.ui.plugin.edit.ClipToFencePlugIn.Clip-Map-to-Fence");
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        this.workbenchContext = context.getWorkbenchContext();
        context.getFeatureInstaller().addMainMenuPlugin(this, new String[]{MenuNames.EDIT}, this.getName() + "...", false, null, new MultiEnableCheck().add(EnableCheckFactory.getInstance(context.getWorkbenchContext()).createTaskWindowMustBeActiveCheck()).add(this.fenceLayerMustBePresent()));
        DIALOGWARNING = I18N.getInstance().get("org.openjump.core.ui.plugin.edit.ClipToFencePlugIn.This-operation-is-not-undoable");
        VISIBLEONLY = I18N.getInstance().get("org.openjump.core.ui.plugin.edit.ClipToFencePlugIn.Visible-Only-(-see-Warning-)");
        DIALOGMSG = I18N.getInstance().get("org.openjump.core.ui.plugin.edit.ClipToFencePlugIn.description");
        FENCELAYERMUSTBEPRESENT = I18N.getInstance().get("org.openjump.core.ui.plugin.edit.ClipToFencePlugIn.Fence-layer-must-be-present");
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        MultiInputDialog dialog = new MultiInputDialog(context.getWorkbenchFrame(), this.getName(), true);
        dialog.setSideBarDescription(DIALOGMSG);
        dialog.addLabel(DIALOGWARNING);
        dialog.addCheckBox(VISIBLEONLY, this.visibleOnly);
        GUIUtil.centreOnWindow(dialog);
        dialog.setVisible(true);
        if (dialog.wasOKPressed()) {
            this.visibleOnly = dialog.getCheckBox(VISIBLEONLY).isSelected();
            return true;
        }
        return false;
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        LayerManager layerManager = context.getLayerManager();
        Layer fence = layerManager.getLayer(FenceLayerFinder.LAYER_NAME);
        ArrayList<Layer> layerList = this.visibleOnly ? new ArrayList<Layer>(layerManager.getVisibleLayers(false)) : new ArrayList<Layer>(layerManager.getLayers());
        OverlayEngine overlayEngine = new OverlayEngine();
        overlayEngine.setAllowingPolygonsOnly(false);
        overlayEngine.setSplittingGeometryCollections(false);
        FeatureCollectionWrapper a = fence.getFeatureCollectionWrapper();
        ArrayList<Layer> unprocessedLayers = new ArrayList<Layer>();
        for (Layer layer : layerList) {
            if (layer == fence) continue;
            FeatureCollectionWrapper b = layer.getFeatureCollectionWrapper();
            if (this.hasDuplicateAttributeNames(b.getFeatureSchema())) {
                context.getWorkbenchFrame().warnUser(I18N.getInstance().get("org.openjump.core.ui.plugin.edit.ClipToFencePlugIn.duplicate-attribute-names-are-not-supported"));
                unprocessedLayers.add(layer);
                continue;
            }
            FeatureCollection overlay = overlayEngine.overlay(a, b, this.mapping(a, b), monitor);
            layer.setFeatureCollection(overlay);
        }
        if (unprocessedLayers.size() > 0) {
            HTMLFrame outputFrame = context.getWorkbenchFrame().getOutputFrame();
            outputFrame.createNewDocument();
            outputFrame.addHeader(1, I18N.getInstance().get("org.openjump.core.ui.plugin.edit.ClipToFencePlugIn.Clip-Map-to-Fence"));
            outputFrame.addHeader(2, I18N.getInstance().get("org.openjump.core.ui.plugin.edit.ClipToFencePlugIn.unprocessed-layers"));
            for (Layer layer : unprocessedLayers) {
                outputFrame.append(layer.getName());
            }
        }
    }

    private AttributeMapping mapping(FeatureCollection a, FeatureCollection b) {
        return new AttributeMapping(new FeatureSchema(), b.getFeatureSchema());
    }

    private boolean hasDuplicateAttributeNames(FeatureSchema schema) {
        HashSet<String> set = new HashSet<String>();
        for (int i = 0; i < schema.getAttributeCount(); ++i) {
            if (set.add(schema.getAttributeName(i))) continue;
            return true;
        }
        return false;
    }

    private EnableCheck fenceLayerMustBePresent() {
        return new EnableCheck(){

            @Override
            public String check(JComponent component) {
                return ClipToFencePlugIn.this.workbenchContext.getLayerViewPanel().getFence() == null ? FENCELAYERMUSTBEPRESENT : null;
            }
        };
    }
}

