/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.datastore.transaction;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.workbench.Logger;
import java.util.Arrays;
import org.openjump.core.ui.plugin.datastore.transaction.EvolutionOperationException;

public class Evolution {
    private static final String KEY = Evolution.class.getName();
    private Type type;
    private Feature newFeature;
    private Feature oldFeature;

    private Evolution(Type type, Feature feature, Feature old) {
        assert (type.equals((Object)Type.CREATION) && this.oldFeature == null && feature != null || type.equals((Object)Type.SUPPRESSION) && this.oldFeature != null && feature == null || type.equals((Object)Type.SUPPRESSION) && this.oldFeature != null && feature != null);
        this.type = type;
        this.newFeature = feature;
        this.oldFeature = old;
    }

    public Feature getOldFeature() {
        return this.oldFeature;
    }

    public Feature getNewFeature() {
        return this.newFeature;
    }

    public Type getType() {
        return this.type;
    }

    public static Evolution createCreation(Feature feature) {
        return new Evolution(Type.CREATION, feature, null);
    }

    public static Evolution createModification(Feature feature, Feature old) {
        return new Evolution(Type.MODIFICATION, feature, old);
    }

    public static Evolution createSuppression(Feature feature) {
        return new Evolution(Type.SUPPRESSION, null, feature);
    }

    public Evolution mergeToPrevious(Evolution previous) throws EvolutionOperationException {
        if (previous == null) {
            return this;
        }
        Feature evo1Old = previous.getOldFeature();
        Feature evo1New = previous.getNewFeature();
        Type type1 = previous.getType();
        Feature evo2Old = this.getOldFeature();
        Feature evo2New = this.getNewFeature();
        Type type2 = this.getType();
        if (type1 != Type.SUPPRESSION && type2 != Type.CREATION && !Arrays.equals(evo1New.getAttributes(), evo2Old.getAttributes())) {
            Logger.info("Try to merge evolution  : " + previous);
            Logger.info(" which final state is   : " + Arrays.toString(evo1New.getAttributes()));
            Logger.info("        with evolution  : " + this);
            Logger.info(" which initial state is : " + Arrays.toString(evo2Old.getAttributes()));
            throw new EvolutionOperationException(I18N.getInstance().get(KEY + ".cannot-merge-non-consecutive-evolutions"));
        }
        if (type1 == Type.CREATION) {
            switch (type2) {
                case CREATION: {
                    throw new EvolutionOperationException(I18N.getInstance().get(KEY + ".cannot-merge-2-creations") + " (" + previous.getNewFeature().getID() + " - " + this.getNewFeature().getID() + ")");
                }
                case MODIFICATION: {
                    return Evolution.createCreation(evo2New);
                }
                case SUPPRESSION: {
                    return null;
                }
            }
            return null;
        }
        if (type1 == Type.MODIFICATION) {
            switch (type2) {
                case CREATION: {
                    throw new EvolutionOperationException(I18N.getInstance().get(KEY + ".cannot-merge-a-modification-with-a-creation"));
                }
                case MODIFICATION: {
                    boolean unchanged = Arrays.equals(evo1Old.getAttributes(), evo2New.getAttributes());
                    return unchanged ? null : Evolution.createModification(evo2New, evo1Old);
                }
                case SUPPRESSION: {
                    return Evolution.createSuppression(evo1Old);
                }
            }
            return null;
        }
        if (type1 == Type.SUPPRESSION) {
            switch (type2) {
                case CREATION: {
                    Logger.debug("State before deletion " + Arrays.toString(evo1Old.getAttributes()));
                    Logger.debug("State after creation  " + Arrays.toString(evo2New.getAttributes()));
                    boolean unchanged = Arrays.equals(evo1Old.getAttributes(), evo2New.getAttributes());
                    return unchanged ? null : Evolution.createModification(evo2New, evo1Old);
                }
                case MODIFICATION: {
                    throw new EvolutionOperationException(I18N.getInstance().get(KEY + ".cannot-merge-a-suppression-with-a-modification"));
                }
                case SUPPRESSION: {
                    throw new EvolutionOperationException(I18N.getInstance().get(KEY + ".cannot-merge-a-suppression-with-a-suppression"));
                }
            }
            return null;
        }
        return null;
    }

    public String toString() {
        if (this.type == Type.CREATION) {
            return "Creation: fid=" + this.newFeature.getID();
        }
        if (this.type == Type.SUPPRESSION) {
            return "Suppression: fid=" + this.oldFeature.getID();
        }
        return "Change from: fid=" + this.oldFeature.getID() + " to: fid=" + this.newFeature.getID();
    }

    public static enum Type {
        CREATION,
        MODIFICATION,
        SUPPRESSION;

    }
}

