/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.datastore.transaction;

import com.vividsolutions.jump.util.Blackboard;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Task;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.TaskFrame;
import com.vividsolutions.jump.workbench.ui.WorkbenchToolBar;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.WorkbenchContextReference;
import com.vividsolutions.jump.workbench.ui.toolbox.ToolboxDialog;
import com.vividsolutions.jump.workbench.ui.toolbox.ToolboxPlugIn;
import java.awt.Component;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import org.openjump.core.model.TaskEvent;
import org.openjump.core.model.TaskListener;
import org.openjump.core.ui.plugin.datastore.WritableDataStoreDataSource;
import org.openjump.core.ui.plugin.datastore.transaction.DataStoreTransactionManager;
import org.openjump.core.ui.plugin.datastore.transaction.TransactionManagerPanel;

public class DataStoreTransactionManagerPlugIn
extends ToolboxPlugIn
implements WorkbenchContextReference {
    private static final String KEY = DataStoreTransactionManagerPlugIn.class.getName();
    private static final String INSTANCE_KEY = KEY + " - INSTANCE";
    private TransactionManagerPanel transactionManagerPanel;
    private WorkbenchContext context;

    public static DataStoreTransactionManagerPlugIn instance(Blackboard blackboard) {
        if (blackboard.get(INSTANCE_KEY) == null) {
            blackboard.put(INSTANCE_KEY, new DataStoreTransactionManagerPlugIn());
        }
        return (DataStoreTransactionManagerPlugIn)blackboard.get(INSTANCE_KEY);
    }

    @Override
    public void initialize(PlugInContext context) throws Exception {
        ImageIcon icon = GUIUtil.resize(IconLoader.icon("database_writable_add.png"), 20);
        WorkbenchToolBar toolbar = context.getWorkbenchFrame().getToolBar();
        int endIndex = toolbar.getComponents().length;
        toolbar.addPlugIn(endIndex, this, icon, null, context.getWorkbenchContext());
        this.setWorkbenchContext(context.getWorkbenchContext());
        context.getWorkbenchFrame().addTaskListener(new TaskListener(){

            @Override
            public void taskAdded(TaskEvent taskEvent) {
                Task task = taskEvent.getTask();
                Logger.info("Task added : " + task.getName());
                List<Layer> layers = task.getLayerManager().getLayers();
                for (Layer layer : layers) {
                    if (!(layer.getDataSourceQuery().getDataSource() instanceof WritableDataStoreDataSource)) continue;
                    DataStoreTransactionManagerPlugIn.this.getTransactionManager().registerLayer(layer, task);
                }
                DataStoreTransactionManagerPlugIn.this.addListenerToTaskFrame(task);
            }

            @Override
            public void taskLoaded(TaskEvent taskEvent) {
                Task task = taskEvent.getTask();
                Logger.info("Task loaded : " + task.getName());
                List<Layer> layers = taskEvent.getTask().getLayerManager().getLayers();
                for (Layer layer : layers) {
                    if (layer.getDataSourceQuery() == null || !(layer.getDataSourceQuery().getDataSource() instanceof WritableDataStoreDataSource)) continue;
                    DataStoreTransactionManagerPlugIn.this.getTransactionManager().registerLayer(layer, task);
                }
                DataStoreTransactionManagerPlugIn.this.addListenerToTaskFrame(task);
            }
        });
    }

    protected DataStoreTransactionManager getTransactionManager() {
        return DataStoreTransactionManager.getTxInstance("org.openjump.core.ui.plugin.datastore.transaction.DataStoreTransactionManager");
    }

    @Override
    protected void initializeToolbox(ToolboxDialog toolbox) {
        this.transactionManagerPanel = new TransactionManagerPanel(this.getTransactionManager(), toolbox.getContext().getErrorHandler(), toolbox.getContext());
        this.transactionManagerPanel.updateListener(toolbox.getContext().getTask());
        toolbox.getCenterPanel().add((Component)this.transactionManagerPanel, "Center");
        toolbox.pack();
        toolbox.setInitialLocation(new GUIUtil.Location(20, true, 40, false));
    }

    private void addListenerToTaskFrame(final Task task) {
        this.getTaskFrame().addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameActivated(InternalFrameEvent e) {
                Logger.trace("Task frame activated " + e.getInternalFrame().getTitle());
                if (DataStoreTransactionManagerPlugIn.this.getTransactionManagerPanel() != null) {
                    DataStoreTransactionManagerPlugIn.this.getTransactionManagerPanel().updateListener(task);
                }
            }
        });
        if (this.getTransactionManagerPanel() != null) {
            this.getTransactionManagerPanel().updateListener(task);
        }
    }

    TaskFrame getTaskFrame() {
        return this.context.getWorkbench().getFrame().getActiveTaskFrame();
    }

    private TransactionManagerPanel getTransactionManagerPanel() {
        return this.transactionManagerPanel;
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        boolean b = super.execute(context);
        if (this.transactionManagerPanel != null) {
            this.transactionManagerPanel.updateTextArea(context.getTask());
        }
        return b;
    }

    @Override
    public void setWorkbenchContext(WorkbenchContext context) {
        this.context = context;
    }
}

