/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin.customize;

import bsh.EvalError;
import bsh.Interpreter;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.JUMPException;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.HTMLFrame;
import com.vividsolutions.jump.workbench.ui.MenuNames;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import com.vividsolutions.jump.workbench.ui.plugin.BeanShellPlugIn;
import com.vividsolutions.jump.workbench.ui.plugin.FeatureInstaller;
import com.vividsolutions.jump.workbench.ui.task.TaskMonitorManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class BeanToolsPlugIn
extends AbstractPlugIn {
    public static final String NAME = I18N.getInstance().get("org.openjump.core.ui.plugin.customize.BeanToolsPlugIn.Bean-Tools");
    private File beanToolsFolder = null;
    private String lastcmd = "";
    private TaskMonitorManager taskMonitorManager;
    private FeatureInstaller featureInstaller;

    @Override
    public void initialize(PlugInContext context) throws Exception {
        JMenu menu;
        this.beanToolsFolder = context.getWorkbenchContext().getWorkbench().getPlugInManager().findFileOrFolderInExtensionDirs("BeanTools");
        if (null == this.beanToolsFolder || !this.beanToolsFolder.isDirectory() || !this.beanToolsFolder.exists()) {
            throw new JUMPException("BeanTools plugin initialization failed because folder 'BeanTools' is missing.");
        }
        this.featureInstaller = context.getFeatureInstaller();
        this.taskMonitorManager = new TaskMonitorManager();
        if (this.beanToolsFolder.exists()) {
            this.scanBeanShellDir(this.beanToolsFolder, context);
        }
        if ((menu = this.featureInstaller.menuBarMenu(MenuNames.CUSTOMIZE)) != null) {
            JMenu item = (JMenu)FeatureInstaller.childMenuItem(this.getName(), FeatureInstaller.wrapMenu(menu));
            if (item != null) {
                this.addFolderIconRecursive(item);
                item.setIcon(this.getIcon());
            }
            for (int i = 0; i < item.getItemCount(); ++i) {
                JMenuItem menuEntry = item.getItem(i);
                String text = menuEntry.getText();
                if (!text.matches("^(?i)(help|refresh)$")) continue;
                item.insertSeparator(i);
                break;
            }
        }
    }

    private void addFolderIconRecursive(JMenu menu) {
        ImageIcon icon = IconLoader.icon("fugue/folder-horizontal-open_16.png");
        menu.setIcon(icon);
        for (int i = 0; i < menu.getItemCount(); ++i) {
            JMenuItem item = menu.getItem(i);
            if (!(item instanceof JMenu)) continue;
            this.addFolderIconRecursive((JMenu)item);
        }
    }

    private String ancestors(File dir, File file) throws IOException {
        String path = file.getCanonicalPath();
        return path.substring(path.lastIndexOf(dir.getName()), path.lastIndexOf(file.getName()));
    }

    private void scanBeanShellDir(final File file, PlugInContext context) throws IOException {
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            Arrays.sort(files, new Comparator<File>(){
                Pattern pattern = Pattern.compile(".*?([0-9]+).*");
                Pattern helpRefresh = Pattern.compile("^(Help|Refresh)\\.bsh$", 2);

                @Override
                public int compare(File f1, File f2) {
                    if (f1.isDirectory() && !f2.isDirectory()) {
                        return -1;
                    }
                    if (!f1.isDirectory() && f2.isDirectory()) {
                        return 1;
                    }
                    if (f1.getParentFile().equals(BeanToolsPlugIn.this.beanToolsFolder)) {
                        if (this.helpRefresh.matcher(f1.getName()).matches()) {
                            return 1;
                        }
                        if (this.helpRefresh.matcher(f2.getName()).matches()) {
                            return -1;
                        }
                    }
                    Matcher m1 = this.pattern.matcher(f1.getName());
                    Matcher m2 = this.pattern.matcher(f2.getName());
                    if (m1.matches() && m2.matches()) {
                        return Integer.valueOf(m1.group(1)).compareTo(Integer.valueOf(m2.group(1)));
                    }
                    return f1.getName().compareTo(f2.getName());
                }

                @Override
                public boolean equals(Object obj) {
                    return this == obj;
                }
            });
            for (File f : files) {
                this.scanBeanShellDir(f, context);
            }
        } else if (file.getName().endsWith(".bsh")) {
            String ancestors = this.ancestors(this.beanToolsFolder, file);
            String[] ancestorList = ancestors.split(File.separator.replace("\\", "\\\\"));
            ancestorList[0] = this.getName();
            String shellName = file.getName().substring(0, file.getName().length() - 4);
            JMenu menu = this.featureInstaller.menuBarMenu(MenuNames.CUSTOMIZE);
            if (menu == null) {
                menu = (JMenu)FeatureInstaller.installMnemonic(new JMenu(I18N.getInstance().get(MenuNames.CUSTOMIZE)), this.featureInstaller.menuBar());
                this.featureInstaller.menuBar().add(menu);
            }
            JMenu parent = (JMenu)this.featureInstaller.createMenusIfNecessary(FeatureInstaller.wrapMenu(menu), ancestorList).getWrappee();
            JMenuItem menuItem = FeatureInstaller.installMnemonic(new JMenuItem(shellName), parent);
            menuItem.setIcon(BeanShellPlugIn.ICON);
            final ActionListener listener = AbstractPlugIn.toActionListener(this, context.getWorkbenchContext(), this.taskMonitorManager);
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (e != null) {
                        BeanToolsPlugIn.this.lastcmd = file.getPath();
                    }
                    listener.actionPerformed(e);
                }
            });
            parent.add(menuItem);
        }
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Icon getIcon() {
        return IconLoader.icon("famfam/applications_bean_go.png");
    }

    @Override
    public boolean execute(final PlugInContext context) throws Exception {
        final JTextArea console = new JTextArea(15, 60);
        OutputStream out = this.getOutputStream(console);
        console.append("************************************************************");
        console.append("\nScript started from \"" + this.lastcmd + "\" at\n" + String.format("%1$tY-%1$tm-%1$td %1$tH:%1$tM:%1$tS", new Date()));
        console.append("\n************************************************************\n");
        JDialog dialog = this.displayConsole(context, console);
        long t0 = System.currentTimeMillis();
        try {
            Interpreter interpreter = new Interpreter();
            interpreter.setOut(new PrintStream(out));
            interpreter.setErr(new PrintStream(out));
            interpreter.setClassLoader(context.getWorkbenchContext().getWorkbench().getPlugInManager().getClassLoader());
            interpreter.set("wc", (Object)context.getWorkbenchContext());
            interpreter.eval("setAccessibility(true)");
            interpreter.eval("import org.locationtech.jts.geom.*");
            interpreter.eval("import com.vividsolutions.jump.feature.*");
            interpreter.source(this.lastcmd);
            console.append("\nExecuted in " + (System.currentTimeMillis() - t0) + " ms\n");
            dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    HTMLFrame outputFrame = context.getOutputFrame();
                    outputFrame.createNewDocument();
                    outputFrame.addText(console.getText());
                }
            });
        }
        catch (EvalError e) {
            console.append("\n" + e.getMessage());
            for (int i = 0; i < e.getStackTrace().length; ++i) {
                console.append("\n" + e.getStackTrace()[i].toString());
            }
            console.append("\nExecuted with errors in " + (System.currentTimeMillis() - t0) + " ms");
        }
        return true;
    }

    private OutputStream getOutputStream(final JTextArea textArea) {
        return new OutputStream(){

            @Override
            public void write(int b) {
                textArea.append(String.valueOf((char)b));
            }

            @Override
            public void write(byte[] b, int off, int len) {
                textArea.append(new String(b, off, len));
            }
        };
    }

    private JDialog displayConsole(PlugInContext context, JTextArea textArea) {
        JDialog consoleDialog = new JDialog(context.getWorkbenchFrame(), "BeanTool output", false);
        consoleDialog.add(new JScrollPane(textArea));
        consoleDialog.setMinimumSize(textArea.getPreferredSize());
        GUIUtil.centre(consoleDialog, context.getWorkbenchFrame());
        consoleDialog.setVisible(true);
        return consoleDialog;
    }
}

