/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ui.plugin;

import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.registry.Registry;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import com.vividsolutions.jump.workbench.ui.wizard.WizardDialog;
import com.vividsolutions.jump.workbench.ui.wizard.WizardPanel;
import java.awt.Frame;
import java.util.List;
import javax.swing.Icon;
import org.openjump.core.ui.plugin.AbstractThreadedUiPlugIn;
import org.openjump.core.ui.swing.wizard.WizardGroup;

public class AbstractWizardPlugin
extends AbstractThreadedUiPlugIn {
    private WizardGroup wizard;
    private WizardDialog dialog;

    public AbstractWizardPlugin() {
    }

    public AbstractWizardPlugin(Icon icon) {
        super(icon);
    }

    public AbstractWizardPlugin(String name, Icon icon, String toolTip) {
        super(name, icon, toolTip);
    }

    public AbstractWizardPlugin(String name, Icon icon) {
        super(name, icon);
    }

    public AbstractWizardPlugin(String name, String toolTip) {
        super(name, toolTip);
    }

    public AbstractWizardPlugin(String name) {
        super(name);
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        Registry registry = this.workbenchContext.getRegistry();
        WorkbenchFrame workbenchFrame = context.getWorkbenchFrame();
        this.dialog = new WizardDialog((Frame)workbenchFrame, this.getName(), context.getErrorHandler());
        this.wizard.initialize(this.workbenchContext, this.dialog);
        List<WizardPanel> panels = this.wizard.getPanels();
        String firstId = this.wizard.getFirstId();
        if (panels.isEmpty() || firstId == null) {
            return true;
        }
        this.dialog.init(panels);
        this.dialog.setCurrentWizardPanel(firstId);
        this.dialog.pack();
        GUIUtil.centreOnWindow(this.dialog);
        this.dialog.setVisible(true);
        return this.dialog.wasFinishPressed();
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
        this.wizard.run(this.dialog, monitor);
    }

    public WizardGroup getWizard() {
        return this.wizard;
    }

    protected void setWizard(WizardGroup wizard) {
        this.wizard = wizard;
    }
}

