/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.rasterimage.styler.ui;

import com.vividsolutions.jump.util.Range;
import com.vividsolutions.jump.workbench.Logger;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openjump.core.rasterimage.RasterSymbology;
import org.openjump.core.rasterimage.styler.ColorMapEntry;
import org.openjump.core.rasterimage.styler.I18N;
import org.openjump.core.rasterimage.styler.ui.CustomGradientColorsDialog;
import org.openjump.core.rasterimage.styler.ui.GUIUtils;
import org.openjump.core.rasterimage.styler.ui.GradientCanvas;
import org.openjump.core.rasterimage.styler.ui.GradientComboBox;

public class StretchedPanel
extends JPanel {
    private JButton jButton_Custom;
    private JCheckBox jCheckBox_Invert;
    private JLabel jLabel_MaxLabel;
    private JLabel jLabel_MaxValue;
    private JLabel jLabel_MinLabel;
    private JLabel jLabel_MinValue;
    private JLabel jLabel_Value;
    private JPanel jPanel_ShowGradient;
    private final double minValue;
    private final double maxValue;
    private ColorMapEntry[] colorMapEntries;
    private GradientComboBox comboBox_Gradient;
    private RasterSymbology rasterSymbology;
    private final int width = 200;
    private final int height = 18;

    public StretchedPanel(Range range) {
        this.initComponents();
        this.minValue = (Double)range.getMin();
        this.maxValue = (Double)range.getMax();
        this.fixComponents();
    }

    public void reset() {
        try {
            this.jCheckBox_Invert.setSelected(false);
            this.comboBox_Gradient.setSelectedIndex(0);
            this.comboBox_Gradient.getModel().getElementAt(0);
            ColorMapEntry[] paletteColorMapEntries = ((GradientCanvas)this.comboBox_Gradient.getModel().getElementAt(0)).getColorMapEntries();
            this.updateRasterStyler(paletteColorMapEntries);
            GUIUtils utils = new GUIUtils();
            utils.setGradientPanel(this.jPanel_ShowGradient, paletteColorMapEntries);
            this.updateUI();
        }
        catch (Exception ex) {
            Logger.error(ex);
        }
    }

    private void initComponents() {
        this.jLabel_Value = new JLabel();
        this.jLabel_MinLabel = new JLabel();
        this.jLabel_MinValue = new JLabel();
        this.jLabel_MaxLabel = new JLabel();
        this.jLabel_MaxValue = new JLabel();
        this.jPanel_ShowGradient = new JPanel();
        this.jButton_Custom = new JButton();
        this.jCheckBox_Invert = new JCheckBox();
        this.setAlignmentY(0.0f);
        this.setCursor(new Cursor(0));
        this.setMaximumSize(new Dimension(365, 160));
        this.setMinimumSize(new Dimension(365, 160));
        this.setPreferredSize(new Dimension(365, 160));
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                StretchedPanel.this.formComponentShown(evt);
            }
        });
        this.setLayout(new GridBagLayout());
        this.jLabel_Value.setFont(new Font("Tahoma", 2, 11));
        this.jLabel_Value.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.StretchedPanel.jLabel_Value.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.add((Component)this.jLabel_Value, gridBagConstraints);
        this.jLabel_MinLabel.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.StretchedPanel.jLabel_MinLabel.text"));
        this.jLabel_MinLabel.setMaximumSize(new Dimension(83, 14));
        this.jLabel_MinLabel.setMinimumSize(new Dimension(83, 14));
        this.jLabel_MinLabel.setPreferredSize(new Dimension(83, 14));
        this.jLabel_MinLabel.setRequestFocusEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel_MinLabel, gridBagConstraints);
        this.jLabel_MinValue.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.StretchedPanel.jLabel_MinValue.text"));
        this.jLabel_MinValue.setMaximumSize(new Dimension(83, 14));
        this.jLabel_MinValue.setMinimumSize(new Dimension(83, 14));
        this.jLabel_MinValue.setPreferredSize(new Dimension(83, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel_MinValue, gridBagConstraints);
        this.jLabel_MaxLabel.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.StretchedPanel.jLabel_MaxLabel.text"));
        this.jLabel_MaxLabel.setToolTipText(I18N.get("org.openjump.core.rasterimage.styler.ui.StretchedPanel.jLabel_MaxLabel.toolTipText"));
        this.jLabel_MaxLabel.setMaximumSize(new Dimension(83, 14));
        this.jLabel_MaxLabel.setMinimumSize(new Dimension(83, 14));
        this.jLabel_MaxLabel.setPreferredSize(new Dimension(83, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel_MaxLabel, gridBagConstraints);
        this.jLabel_MaxValue.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.StretchedPanel.jLabel_MaxValue.text"));
        this.jLabel_MaxValue.setMaximumSize(new Dimension(83, 14));
        this.jLabel_MaxValue.setMinimumSize(new Dimension(83, 14));
        this.jLabel_MaxValue.setPreferredSize(new Dimension(83, 14));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jLabel_MaxValue, gridBagConstraints);
        this.jPanel_ShowGradient.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel_ShowGradient.setMinimumSize(new Dimension(80, 75));
        this.jPanel_ShowGradient.setPreferredSize(new Dimension(73, 75));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jPanel_ShowGradient, gridBagConstraints);
        this.jButton_Custom.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.StretchedPanel.jButton_Custom.text"));
        this.jButton_Custom.addActionListener(this::jButton_CustomActionPerformed);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.jButton_Custom, gridBagConstraints);
        this.jCheckBox_Invert.setText(I18N.get("org.openjump.core.rasterimage.styler.ui.StretchedPanel.jCheckBox_Invert.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)this.jCheckBox_Invert, gridBagConstraints);
    }

    private void formComponentShown(ComponentEvent evt) {
        this.jLabel_MinValue.setText(Double.toString(GUIUtils.round(this.minValue, 3)));
        this.jLabel_MaxValue.setText(Double.toString(GUIUtils.round(this.maxValue, 3)));
    }

    private void jButton_CustomActionPerformed(ActionEvent evt) {
        this.customGradient();
    }

    private void comboBox_GradientActionPerformed(ActionEvent evt) {
        try {
            if (this.comboBox_Gradient != null) {
                ColorMapEntry[] paletteColorMapEntries = ((GradientCanvas)this.comboBox_Gradient.getSelectedItem()).getColorMapEntries();
                this.updateRasterStyler(paletteColorMapEntries);
                GUIUtils utils = new GUIUtils();
                utils.setGradientPanel(this.jPanel_ShowGradient, paletteColorMapEntries);
            }
        }
        catch (Exception ex) {
            Logger.error(ex);
        }
    }

    private void fixComponents() {
        this.setComboBox();
        GUIUtils.addGradientComboBoxToList(this.comboBox_Gradient);
        GradientCanvas gradientCanvas = (GradientCanvas)this.comboBox_Gradient.getItemAt(0);
        this.colorMapEntries = gradientCanvas.getColorMapEntries();
        this.rasterSymbology = new RasterSymbology("RAMP");
        this.updateRasterStyler(this.colorMapEntries);
        GUIUtils utils = new GUIUtils();
        utils.setGradientPanel(this.jPanel_ShowGradient, this.colorMapEntries);
    }

    private void setComboBox() {
        this.comboBox_Gradient = GUIUtils.createStandardGradientComboBox(200, 18);
        this.comboBox_Gradient.addActionListener(this::comboBox_GradientActionPerformed);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.comboBox_Gradient, gridBagConstraints);
    }

    private void customGradient() {
        GradientCanvas gradientCanvas = (GradientCanvas)this.comboBox_Gradient.getSelectedItem();
        ColorMapEntry[] coloMapEntries = gradientCanvas.getColorMapEntries();
        CustomGradientColorsDialog customGradientDialog = new CustomGradientColorsDialog(null, true, coloMapEntries);
        customGradientDialog.setLocationRelativeTo(this);
        customGradientDialog.setVisible(true);
        ColorMapEntry[] newGradient = customGradientDialog.getColorMapEntries();
        if (newGradient != null) {
            GUIUtils.updateGradientComboBoxes(newGradient, 200, 18);
            this.comboBox_Gradient.setSelectedIndex(this.comboBox_Gradient.getItemCount() - 1);
        }
    }

    private void updateRasterStyler(ColorMapEntry[] colorMapEntries) {
        this.rasterSymbology = new RasterSymbology("RAMP");
        for (ColorMapEntry paletteColorMapEntrie : colorMapEntries) {
            double quantity = (this.maxValue - this.minValue) * paletteColorMapEntrie.getUpperValue() + this.minValue;
            this.rasterSymbology.addColorMapEntry(quantity, paletteColorMapEntrie.getColor());
        }
    }

    public void plugRasterSymbology(RasterSymbology rasterSymbology) throws Exception {
        this.colorMapEntries = rasterSymbology.getColorMapEntries();
        ColorMapEntry[] relColMapEntries = new ColorMapEntry[rasterSymbology.getColorMapEntries().length];
        double minVal = 0.0;
        minVal = rasterSymbology.getColorMapEntries()[0].getColor() != null ? rasterSymbology.getColorMapEntries()[0].getUpperValue() : rasterSymbology.getColorMapEntries()[1].getUpperValue();
        double maxVal = rasterSymbology.getColorMapEntries()[rasterSymbology.getColorMapEntries().length - 1].getUpperValue();
        relColMapEntries[0] = new ColorMapEntry(0.0, rasterSymbology.getColorMapEntries()[0].getColor());
        for (int i = 1; i < rasterSymbology.getColorMapEntries().length; ++i) {
            double relVal = (rasterSymbology.getColorMapEntries()[i].getUpperValue() - minVal) / (maxVal - minVal);
            relColMapEntries[i] = new ColorMapEntry(relVal, rasterSymbology.getColorMapEntries()[i].getColor());
        }
        GUIUtils.updateGradientComboBoxes(relColMapEntries, 200, 18);
        this.comboBox_Gradient.setSelectedIndex(this.comboBox_Gradient.getItemCount() - 1);
    }

    public RasterSymbology getRasterStyler() {
        if (this.jCheckBox_Invert.isSelected()) {
            RasterSymbology revRasterSymbology = new RasterSymbology(this.rasterSymbology.getColorMapType());
            int firstEntry = 0;
            if (this.rasterSymbology.getColorMapEntries()[0].getColor() == null) {
                revRasterSymbology.addColorMapEntry(this.rasterSymbology.getColorMapEntries()[0].getUpperValue(), this.rasterSymbology.getColorMapEntries()[0].getColor());
                firstEntry = 1;
            }
            int up = this.rasterSymbology.getColorMapEntries().length - 1 + firstEntry;
            for (int cme = firstEntry; cme < this.rasterSymbology.getColorMapEntries().length; ++cme) {
                revRasterSymbology.addColorMapEntry(this.rasterSymbology.getColorMapEntries()[cme].getUpperValue(), this.rasterSymbology.getColorMapEntries()[up - cme].getColor());
            }
            return revRasterSymbology;
        }
        return this.rasterSymbology;
    }
}

