/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.rasterimage.styler;

import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.TIFFEncodeParam;
import com.sun.media.jai.codec.TIFFField;
import com.sun.media.jai.codecimpl.TIFFCodec;
import com.sun.media.jai.codecimpl.TIFFImageEncoder;
import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.workbench.JUMPWorkbench;
import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.plugin.EnableCheckFactory;
import com.vividsolutions.jump.workbench.plugin.MultiEnableCheck;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.plugin.ThreadedPlugIn;
import com.vividsolutions.jump.workbench.ui.GUIUtil;
import com.vividsolutions.jump.workbench.ui.images.IconLoader;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLayeredPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.locationtech.jts.geom.Envelope;
import org.openjump.core.apitools.LayerTools;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.rasterimage.RasterSymbology;
import org.openjump.core.rasterimage.styler.ui.ColorsLabelLegendComponent;
import org.openjump.core.rasterimage.styler.ui.GradientLabelLegendComponent;
import org.openjump.core.ui.io.file.FileNameExtensionFilter;
import org.openjump.core.ui.plugin.layer.pirolraster.RasterImageContextMenu;
import org.openjump.core.ui.swing.DetachableInternalFrame;

public class RasterLegendPlugIn
implements ThreadedPlugIn {
    private final String sSaved = I18N.getInstance().get("org.openjump.core.ui.plugin.raster.RasterImageLayerPropertiesPlugIn.file.saved");
    private final String sShowLegend = I18N.getInstance().get("org.openjump.core.ui.plugin.style.LegendPlugIn");
    private final String SCouldNotSave = I18N.getInstance().get("org.openjump.sextante.gui.additionalResults.AdditionalResultsPlugIn.Could-not-save-selected-result");
    private final String SAVE = I18N.getInstance().get("deejump.plugin.SaveLegendPlugIn.Save");
    private final String CLOSE = I18N.getInstance().get("ui.plugin.imagery.ImageLayerManagerDialog.Close");
    JScrollPane scrollPane = new JScrollPane();
    WorkbenchContext wcontext = JUMPWorkbench.getInstance().getContext();
    public static RasterImageLayer rasterImageLayer = new RasterImageLayer();

    @Override
    public void initialize(PlugInContext context) throws Exception {
        RasterImageContextMenu menu = RasterImageContextMenu.getInstance(context);
        context.getFeatureInstaller().addPopupMenuPlugin(menu, this, this.getName(), false, this.getIcon(), RasterLegendPlugIn.createEnableCheck(context.getWorkbenchContext()));
    }

    public static RasterImageLayer getLayer() {
        return rasterImageLayer;
    }

    @Override
    public boolean execute(PlugInContext context) throws Exception {
        rasterImageLayer = (RasterImageLayer)LayerTools.getSelectedLayerable(context, RasterImageLayer.class);
        RasterSymbology rasterStyler = rasterImageLayer.getSymbology();
        if (rasterStyler.getColorMapEntries_tm().size() > 40) {
            JOptionPane.showMessageDialog(context.getWorkbenchFrame(), "More than 40 colors", "Raster Styles", 1);
            return false;
        }
        TreeMap<Double, Color> colorMapEntries = rasterStyler.getColorMapEntries_tm();
        String type = RasterLegendPlugIn.getLayer().getSymbology().getColorMapType();
        if (type.equals("INTERVALS") || type.equals("SINGLE")) {
            this.scrollPane = new JScrollPane(this.getPanelInterval(colorMapEntries, rasterImageLayer), 20, 30);
        } else if (type.equals("RAMP")) {
            this.scrollPane = new JScrollPane(this.getPanelGradient(colorMapEntries, rasterImageLayer), 20, 30);
        }
        this.scrollPane.setPreferredSize(new Dimension(300, 400));
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout());
        panel.add((Component)this.scrollPane, "Center");
        panel.setPreferredSize(this.scrollPane.getPreferredSize());
        DetachableInternalFrame frame = new DetachableInternalFrame();
        frame.setTitle(this.getName() + " (" + rasterImageLayer.getName() + ")");
        frame.setResizable(true);
        frame.setClosable(true);
        frame.setIconifiable(true);
        frame.setMaximizable(true);
        frame.setSize(300, 500);
        frame.setLayer(JLayeredPane.PALETTE_LAYER);
        panel.add((Component)this.scrollPane, "Center");
        panel.add((Component)this.getOKSavePanel(frame), "South");
        panel.updateUI();
        frame.setContentPane(panel);
        frame.pack();
        context.getWorkbenchFrame().addInternalFrame(frame, true, true);
        return true;
    }

    protected JPanel getOKSavePanel(final DetachableInternalFrame frame) {
        JPanel okPanel = new JPanel();
        JButton saveButton = new JButton(this.SAVE){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(100, 25);
            }
        };
        JButton closeButton = new JButton(this.CLOSE){
            private static final long serialVersionUID = 2L;

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(100, 25);
            }
        };
        saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RasterLegendPlugIn.this.save(RasterLegendPlugIn.this.scrollPane);
            }
        });
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                frame.dispose();
            }
        });
        okPanel.add((Component)saveButton, "West");
        okPanel.add((Component)closeButton, "East");
        return okPanel;
    }

    @Override
    public void run(TaskMonitor monitor, PlugInContext context) throws Exception {
    }

    private JPanel getPanelInterval(TreeMap<Double, Color> colorMapEntry_tm, RasterImageLayer rLayer) throws Exception {
        ColorsLabelLegendComponent component = new ColorsLabelLegendComponent(colorMapEntry_tm, rLayer.getNoDataValue(), rLayer.getName());
        component.setPreferredSize(new Dimension(200, 400));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(component);
        panel.setVisible(true);
        return panel;
    }

    private JPanel getPanelGradient(TreeMap<Double, Color> colorMapEntry, RasterImageLayer rLayer) throws Exception {
        GradientLabelLegendComponent component = new GradientLabelLegendComponent(colorMapEntry, rLayer.getNoDataValue(), rLayer.getName());
        component.setPreferredSize(new Dimension(200, 400));
        JPanel panel = new JPanel(new BorderLayout());
        panel.add(component);
        panel.setVisible(true);
        return panel;
    }

    @Override
    public String getName() {
        return this.sShowLegend;
    }

    public ImageIcon getIcon() {
        return IconLoader.icon("saig/addLegend.gif");
    }

    public static MultiEnableCheck createEnableCheck(WorkbenchContext workbenchContext) {
        MultiEnableCheck multiEnableCheck = new MultiEnableCheck();
        EnableCheckFactory checkFactory = EnableCheckFactory.getInstance(workbenchContext);
        multiEnableCheck.add(checkFactory.createWindowWithLayerNamePanelMustBeActiveCheck());
        multiEnableCheck.add(checkFactory.createExactlyNLayerablesMustBeSelectedCheck(1, RasterImageLayer.class));
        multiEnableCheck.add(checkFactory.createRasterImageLayerExactlyNBandsMustExistCheck(1));
        return multiEnableCheck;
    }

    public void save(JScrollPane pane) {
        JPanel panel = (JPanel)pane.getViewport().getView();
        int w = panel.getWidth();
        int h = panel.getHeight();
        BufferedImage bi = new BufferedImage(w, h, 1);
        Graphics2D g = bi.createGraphics();
        panel.paint(g);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("Portable Network Graphics (png)", "png");
        GUIUtil.FileChooserWithOverwritePrompting fc = new GUIUtil.FileChooserWithOverwritePrompting("png");
        fc.setFileFilter(filter);
        fc.addChoosableFileFilter(filter);
        int returnVal = fc.showSaveDialog(JUMPWorkbench.getInstance().getFrame());
        fc.getWidth();
        fc.getHeight();
        if (returnVal == 0) {
            try {
                File file = new File(((JFileChooser)fc).getSelectedFile() + "-legend.png");
                ImageIO.write((RenderedImage)bi, "png", file);
                this.saved(file);
            }
            catch (Exception e) {
                this.notsaved();
                RasterLegendPlugIn.Logger(this.getClass(), e);
            }
        }
    }

    public double cellSizeX(Raster r, Envelope env) throws IOException {
        return env.getWidth() / (double)r.getWidth();
    }

    public double cellSizeY(Raster r, Envelope env) throws IOException {
        return env.getHeight() / (double)r.getHeight();
    }

    public static BufferedImage joinBufferedImage(BufferedImage img1, BufferedImage img2) {
        int offset = 5;
        int wid = img1.getWidth() + img2.getWidth() + 5;
        int height = Math.max(img1.getHeight(), img2.getHeight()) + 5;
        BufferedImage newImage = new BufferedImage(wid, height, 2);
        Graphics2D g2 = newImage.createGraphics();
        Color oldColor = g2.getColor();
        g2.setPaint(Color.WHITE);
        g2.fillRect(0, 0, wid, height);
        g2.setColor(oldColor);
        g2.drawImage(img1, null, 0, 0);
        g2.drawImage(img2, null, img1.getWidth() + 5, 0);
        g2.dispose();
        return newImage;
    }

    public static void Logger(Class<?> plugin, Exception e) {
        JUMPWorkbench.getInstance().getFrame().warnUser(plugin.getSimpleName() + " Exception: " + e.toString());
        Logger.error(plugin.getName() + " Exception: ", e);
    }

    protected void saved(File file) {
        JUMPWorkbench.getInstance().getFrame().setStatusMessage(this.sSaved + " :" + file.getAbsolutePath());
    }

    protected void notsaved() {
        JOptionPane.showMessageDialog(null, this.SCouldNotSave, I18N.getInstance().get(this.getName()), 2);
    }

    private boolean exportToGeoTIFFFile(String sFilename, double cellsizeX, double cellsizeY, double nodata, Envelope envelope, BufferedImage image) {
        try {
            FileOutputStream tifOut = new FileOutputStream(sFilename);
            TIFFEncodeParam param = new TIFFEncodeParam();
            param.setCompression(1);
            TIFFField[] tiffFields = new TIFFField[3];
            tiffFields[0] = new TIFFField(33550, 12, 2, (Object)new double[]{cellsizeX, cellsizeY});
            String noDataS = Double.toString(nodata);
            byte[] bytes = noDataS.getBytes();
            tiffFields[1] = new TIFFField(42113, 1, noDataS.length(), (Object)bytes);
            tiffFields[2] = new TIFFField(33922, 12, 6, (Object)new double[]{0.0, 0.0, 0.0, envelope.getMinX(), envelope.getMaxY(), 0.0});
            param.setExtraFields(tiffFields);
            TIFFImageEncoder encoder = (TIFFImageEncoder)TIFFCodec.createImageEncoder((String)"tiff", (OutputStream)tifOut, (ImageEncodeParam)param);
            encoder.encode((RenderedImage)image);
            tifOut.close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }
}

