/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.rasterimage.sextante.rasterWrappers;

import org.openjump.core.rasterimage.sextante.ISextanteRasterLayer;
import org.openjump.core.rasterimage.sextante.rasterWrappers.GridExtent;
import org.openjump.core.rasterimage.sextante.rasterWrappers.GridWrapper;

public class GridWrapperNotInterpolated
extends GridWrapper {
    public GridWrapperNotInterpolated(ISextanteRasterLayer layer, GridExtent windowExtent) {
        super(layer, windowExtent);
        this.calculateOffsets();
    }

    protected void calculateOffsets() {
        GridExtent layerExtent = this.m_Layer.getLayerGridExtent();
        this.m_iOffsetX = (int)((this.m_WindowExtent.getXMin() - layerExtent.getXMin()) / this.m_WindowExtent.getCellSize().x);
        this.m_iOffsetY = (int)((layerExtent.getYMax() - this.m_WindowExtent.getYMax()) / this.m_WindowExtent.getCellSize().y);
    }

    @Override
    public byte getCellValueAsByte(int x, int y) {
        return (byte)this.getCellValueInLayerCoords(x + this.m_iOffsetX, y + this.m_iOffsetY, 0);
    }

    @Override
    public byte getCellValueAsByte(int x, int y, int band) {
        return (byte)this.getCellValueInLayerCoords(x + this.m_iOffsetX, y + this.m_iOffsetY, band);
    }

    @Override
    public short getCellValueAsShort(int x, int y) {
        return (short)this.getCellValueInLayerCoords(x + this.m_iOffsetX, y + this.m_iOffsetY, 0);
    }

    @Override
    public short getCellValueAsShort(int x, int y, int band) {
        return (short)this.getCellValueInLayerCoords(x + this.m_iOffsetX, y + this.m_iOffsetY, band);
    }

    @Override
    public int getCellValueAsInt(int x, int y) {
        return (int)this.getCellValueInLayerCoords(x + this.m_iOffsetX, y + this.m_iOffsetY, 0);
    }

    @Override
    public int getCellValueAsInt(int x, int y, int band) {
        return (int)this.getCellValueInLayerCoords(x + this.m_iOffsetX, y + this.m_iOffsetY, band);
    }

    @Override
    public float getCellValueAsFloat(int x, int y) {
        return (float)this.getCellValueInLayerCoords(x + this.m_iOffsetX, y + this.m_iOffsetY, 0);
    }

    @Override
    public float getCellValueAsFloat(int x, int y, int band) {
        return (float)this.getCellValueInLayerCoords(x + this.m_iOffsetX, y + this.m_iOffsetY, band);
    }

    @Override
    public double getCellValueAsDouble(int x, int y) {
        return this.getCellValueInLayerCoords(x + this.m_iOffsetX, y + this.m_iOffsetY, 0);
    }

    @Override
    public double getCellValueAsDouble(int x, int y, int band) {
        return this.getCellValueInLayerCoords(x + this.m_iOffsetX, y + this.m_iOffsetY, band);
    }
}

