/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.rasterimage.sextante;

import java.awt.geom.Point2D;
import java.util.Arrays;
import org.openjump.core.rasterimage.sextante.ISextanteRasterLayer;
import org.openjump.core.rasterimage.sextante.rasterWrappers.GridExtent;
import org.openjump.core.rasterimage.sextante.rasterWrappers.GridWrapper;
import org.openjump.core.rasterimage.sextante.rasterWrappers.GridWrapperInterpolated;
import org.openjump.core.rasterimage.sextante.rasterWrappers.GridWrapperNotInterpolated;

public abstract class AbstractSextanteRasterLayer
implements ISextanteRasterLayer {
    private static final int[] m_iOffsetX = new int[]{0, 1, 1, 1, 0, -1, -1, -1};
    private static final int[] m_iOffsetY = new int[]{1, 1, 0, -1, -1, -1, 0, 1};
    private static final double DEG_90_IN_RAD = 1.5707963267948966;
    private static final double DEG_180_IN_RAD = Math.PI;
    private static final double DEG_270_IN_RAD = 4.71238898038469;
    private GridWrapper m_GridWrapper;
    private double[] m_dDist;
    private double _2DX;
    private int[][] m_Histogram;
    private double[] m_dMax;
    private double[] m_dMin;
    private double[] m_dMean;
    private double[] m_dVariance;
    private boolean m_bStatisticsCalculated = false;
    private boolean m_bHistogramCalculated;
    protected Object m_BaseDataObject;

    @Override
    public Object getBaseDataObject() {
        return this.m_BaseDataObject;
    }

    @Override
    public void setInterpolationMethod(int iMethod) {
        this.m_GridWrapper.setInterpolationMethod(iMethod);
    }

    @Override
    public byte getCellValueAsByte(int x, int y) {
        return this.m_GridWrapper.getCellValueAsByte(x, y);
    }

    @Override
    public byte getCellValueAsByte(int x, int y, int band) {
        return this.m_GridWrapper.getCellValueAsByte(x, y, band);
    }

    @Override
    public short getCellValueAsShort(int x, int y) {
        return this.m_GridWrapper.getCellValueAsShort(x, y);
    }

    @Override
    public short getCellValueAsShort(int x, int y, int band) {
        return this.m_GridWrapper.getCellValueAsShort(x, y, band);
    }

    @Override
    public int getCellValueAsInt(int x, int y) {
        return this.m_GridWrapper.getCellValueAsInt(x, y);
    }

    @Override
    public int getCellValueAsInt(int x, int y, int band) {
        return this.m_GridWrapper.getCellValueAsInt(x, y, band);
    }

    @Override
    public float getCellValueAsFloat(int x, int y) {
        return this.m_GridWrapper.getCellValueAsFloat(x, y);
    }

    @Override
    public float getCellValueAsFloat(int x, int y, int band) {
        return this.m_GridWrapper.getCellValueAsFloat(x, y, band);
    }

    @Override
    public double getCellValueAsDouble(int x, int y) {
        return this.m_GridWrapper.getCellValueAsDouble(x, y);
    }

    @Override
    public double getCellValueAsDouble(int x, int y, int band) {
        return this.m_GridWrapper.getCellValueAsDouble(x, y, band);
    }

    @Override
    public double getValueAt(double x, double y) {
        return this.m_GridWrapper.getValueAt(x, y, 0);
    }

    @Override
    public double getValueAt(double x, double y, int band) {
        return this.m_GridWrapper.getValueAt(x, y, band);
    }

    @Override
    public boolean isNoDataValue(double dValue) {
        return dValue == this.getNoDataValue();
    }

    @Override
    public boolean isInWindow(int x, int y) {
        if (x < 0 || y < 0) {
            return false;
        }
        return x < this.m_GridWrapper.getNX() && y < this.m_GridWrapper.getNY();
    }

    @Override
    public int getNX() {
        return this.m_GridWrapper.getNX();
    }

    @Override
    public int getNY() {
        return this.m_GridWrapper.getNY();
    }

    @Override
    public Point2D.Double getWindowCellSize() {
        return this.m_GridWrapper.getCellSize();
    }

    @Override
    public GridExtent getWindowGridExtent() {
        return this.m_GridWrapper.getGridExtent();
    }

    @Override
    public void assign(double dValue) {
        for (int iBand = 0; iBand < this.getBandsCount(); ++iBand) {
            for (int x = 0; x < this.getNX(); ++x) {
                for (int y = 0; y < this.getNY(); ++y) {
                    this.setCellValue(x, y, iBand, dValue);
                }
            }
        }
    }

    @Override
    public void assign(ISextanteRasterLayer layer) {
        layer.setWindowExtent(this.getWindowGridExtent());
        int iNX = layer.getNX();
        int iNY = layer.getNY();
        for (int x = 0; x < iNX; ++x) {
            for (int y = 0; y < iNY; ++y) {
                double dValue = layer.getCellValueAsDouble(x, y);
                this.setCellValue(x, y, dValue);
            }
        }
        this.setNoDataValue(layer.getNoDataValue());
    }

    @Override
    public void add(ISextanteRasterLayer driver) {
        if (driver.getWindowGridExtent().equals(this.getWindowGridExtent())) {
            for (int x = 0; x < this.getWindowGridExtent().getNX(); ++x) {
                for (int y = 0; y < this.getWindowGridExtent().getNY(); ++y) {
                    double dValue = driver.getCellValueAsDouble(x, y) + this.getCellValueAsDouble(x, y);
                    this.setCellValue(x, y, dValue);
                }
            }
            this.setNoDataValue(driver.getNoDataValue());
        }
    }

    @Override
    public void assignNoData() {
        this.assign(this.getNoDataValue());
    }

    @Override
    public void setCellValue(int x, int y, double dValue) {
        this.setCellValue(x, y, 0, dValue);
    }

    @Override
    public void setNoData(int x, int y) {
        this.setCellValue(x, y, this.getNoDataValue());
    }

    @Override
    public void setNoData(int x, int y, int iBand) {
        this.setCellValue(x, y, iBand, this.getNoDataValue());
    }

    @Override
    public void addToCellValue(int x, int y, int iBand, double dValue) {
        double dCellValue = this.getCellValueAsDouble(x, y, iBand);
        if (!this.isNoDataValue(dCellValue)) {
            this.setCellValue(x, y, iBand, dCellValue += dValue);
        }
    }

    @Override
    public void addToCellValue(int x, int y, double dValue) {
        this.addToCellValue(x, y, 0, dValue);
    }

    @Override
    public void multiply(double dValue) {
        for (int iBand = 0; iBand < this.getBandsCount(); ++iBand) {
            for (int x = 0; x < this.getNX(); ++x) {
                for (int y = 0; y < this.getNY(); ++y) {
                    double dVal = this.getCellValueAsDouble(x, y, iBand);
                    this.setCellValue(x, y, iBand, dValue * dVal);
                }
            }
        }
    }

    @Override
    public void setWindowExtent(ISextanteRasterLayer layer) {
        GridExtent layerExtent = new GridExtent(layer);
        this.m_GridWrapper = layerExtent.fitsIn(this.getLayerGridExtent()) ? new GridWrapperNotInterpolated(this, layerExtent) : new GridWrapperInterpolated(this, layerExtent);
        this.setConstants();
    }

    @Override
    public void setWindowExtent(GridExtent extent) {
        this.m_GridWrapper = extent.fitsIn(this.getLayerGridExtent()) ? new GridWrapperNotInterpolated(this, extent) : new GridWrapperInterpolated(this, extent);
        this.setConstants();
    }

    @Override
    public void setFullExtent() {
        this.m_GridWrapper = new GridWrapperNotInterpolated(this, this.getLayerGridExtent());
        this.setConstants();
    }

    private void setConstants() {
        double dCellSizeX = this.getWindowCellSize().x;
        double dCellSizeY = this.getWindowCellSize().y;
        this.m_dDist = new double[8];
        for (int i = 0; i < 8; ++i) {
            this.m_dDist[i] = Math.sqrt((double)m_iOffsetX[i] * dCellSizeX * (double)m_iOffsetX[i] * dCellSizeX + (double)m_iOffsetY[i] * dCellSizeY * (double)m_iOffsetY[i] * dCellSizeY);
        }
        this._2DX = dCellSizeX * 2.0;
    }

    private void calculateStatistics() {
        int i;
        int iBands = this.getBandsCount();
        this.m_dMean = new double[iBands];
        this.m_dVariance = new double[iBands];
        this.m_dMin = new double[iBands];
        this.m_dMax = new double[iBands];
        for (i = 0; i < this.getBandsCount(); ++i) {
            this.m_dMean[i] = 0.0;
            this.m_dVariance[i] = 0.0;
        }
        if (this.m_GridWrapper == null) {
            this.setFullExtent();
        }
        for (i = 0; i < this.getBandsCount(); ++i) {
            int iValues = 0;
            for (int y = 0; y < this.getNY(); ++y) {
                for (int x = 0; x < this.getNX(); ++x) {
                    double z = this.getCellValueAsDouble(x, y, i);
                    if (this.isNoDataValue(z)) continue;
                    if (iValues == 0) {
                        this.m_dMin[i] = this.m_dMax[i] = z;
                    } else if (this.m_dMin[i] > z) {
                        this.m_dMin[i] = z;
                    } else if (this.m_dMax[i] < z) {
                        this.m_dMax[i] = z;
                    }
                    int n = i;
                    this.m_dMean[n] = this.m_dMean[n] + z;
                    int n2 = i;
                    this.m_dVariance[n2] = this.m_dVariance[n2] + z * z;
                    ++iValues;
                }
            }
            if (iValues <= 0) continue;
            int n = i;
            this.m_dMean[n] = this.m_dMean[n] / (double)iValues;
            this.m_dVariance[i] = this.m_dVariance[i] / (double)iValues - this.m_dMean[i] * this.m_dMean[i];
        }
        this.m_bStatisticsCalculated = true;
    }

    private void calculateHistogram() {
        if (!this.m_bStatisticsCalculated) {
            this.calculateStatistics();
        }
        int iBands = this.getBandsCount();
        this.m_Histogram = new int[iBands][256];
        Arrays.fill((Object[])this.m_Histogram, (Object)0);
        for (int i = 0; i < iBands; ++i) {
            double dRange = this.m_dMax[i] - this.m_dMin[i];
            for (int y = 0; y < this.getNY(); ++y) {
                for (int x = 0; x < this.getNX(); ++x) {
                    double dValue = this.getCellValueAsDouble(x, y, i);
                    if (this.isNoDataValue(dValue)) continue;
                    int iClass = (int)((dValue - this.m_dMin[i]) / dRange * 255.0);
                    int[] nArray = this.m_Histogram[i];
                    int n = iClass;
                    nArray[n] = nArray[n] + 1;
                }
            }
        }
        this.m_bHistogramCalculated = true;
    }

    @Override
    public int[] getHistogram(int iBand) {
        if (!this.m_bHistogramCalculated) {
            this.calculateHistogram();
        }
        return this.m_Histogram[iBand];
    }

    @Override
    public int[] getHistogram() {
        return this.getHistogram(0);
    }

    public int[] getAccumulatedHistogram(int iBand) {
        int[] accHistogram = new int[256];
        Arrays.fill(accHistogram, 0);
        if (!this.m_bHistogramCalculated) {
            this.calculateHistogram();
        }
        for (int i = 1; i < 256; ++i) {
            accHistogram[i] = this.m_Histogram[iBand][i] + accHistogram[i - 1];
        }
        return accHistogram;
    }

    @Override
    public int[] getAccumulatedHistogram() {
        return this.getAccumulatedHistogram(0);
    }

    @Override
    public double getMinValue(int iBand) {
        if (!this.m_bStatisticsCalculated) {
            this.calculateStatistics();
        }
        return this.m_dMin[iBand];
    }

    @Override
    public double getMaxValue(int iBand) {
        if (!this.m_bStatisticsCalculated) {
            this.calculateStatistics();
        }
        return this.m_dMax[iBand];
    }

    @Override
    public double getMeanValue(int iBand) {
        if (!this.m_bStatisticsCalculated) {
            this.calculateStatistics();
        }
        return this.m_dMean[iBand];
    }

    @Override
    public double getVariance(int iBand) {
        if (!this.m_bStatisticsCalculated) {
            this.calculateStatistics();
        }
        return this.m_dVariance[iBand];
    }

    @Override
    public double getMeanValue() {
        return this.getMeanValue(0);
    }

    @Override
    public double getMinValue() {
        return this.getMinValue(0);
    }

    @Override
    public double getMaxValue() {
        return this.getMaxValue(0);
    }

    @Override
    public double getVariance() {
        return this.getVariance(0);
    }

    private boolean getSubMatrix3x3(int x, int y, double[] SubMatrix) {
        double z = this.getCellValueAsDouble(x, y);
        if (this.isNoDataValue(z)) {
            return false;
        }
        for (int i = 0; i < 4; ++i) {
            int iDir = 2 * i;
            double z2 = this.getCellValueAsDouble(x + m_iOffsetX[iDir], y + m_iOffsetY[iDir]);
            SubMatrix[i] = !this.isNoDataValue(z2) ? z2 - z : (!this.isNoDataValue(z2 = this.getCellValueAsDouble(x + m_iOffsetX[(iDir + 4) % 8], y + m_iOffsetY[(iDir + 4) % 8])) ? z - z2 : 0.0);
        }
        return true;
    }

    @Override
    public double getSlope(int x, int y) {
        double[] zm = new double[4];
        if (this.getSubMatrix3x3(x, y, zm)) {
            double G = (zm[0] - zm[2]) / this._2DX;
            double H = (zm[1] - zm[3]) / this._2DX;
            return Math.atan(Math.sqrt(G * G + H * H));
        }
        return this.m_GridWrapper.getNoDataValue();
    }

    @Override
    public double getAspect(int x, int y) {
        double[] zm = new double[4];
        if (this.getSubMatrix3x3(x, y, zm)) {
            double G = (zm[0] - zm[2]) / this._2DX;
            double H = (zm[1] - zm[3]) / this._2DX;
            double dAspect = G != 0.0 ? Math.PI + Math.atan2(H, G) : (H > 0.0 ? 4.71238898038469 : (H < 0.0 ? 1.5707963267948966 : -1.0));
            return dAspect;
        }
        return this.m_GridWrapper.getNoDataValue();
    }

    @Override
    public double getDistToNeighborInDir(int iDir) {
        return this.m_dDist[iDir];
    }

    public static double getUnitDistToNeighborInDir(int iDir) {
        return iDir % 2 != 0 ? Math.sqrt(2.0) : 1.0;
    }

    @Override
    public int getDirToNextDownslopeCell(int x, int y) {
        return this.getDirToNextDownslopeCell(x, y, true);
    }

    @Override
    public int getDirToNextDownslopeCell(int x, int y, boolean bForceDirToNoDataCell) {
        double z = this.getCellValueAsDouble(x, y);
        if (this.isNoDataValue(z)) {
            return -1;
        }
        double dMaxSlope = 0.0;
        int iDir = -1;
        for (int i = 0; i < 8; ++i) {
            double z2 = this.getCellValueAsDouble(x + m_iOffsetX[i], y + m_iOffsetY[i]);
            if (this.isNoDataValue(z2)) {
                if (bForceDirToNoDataCell) {
                    return i;
                }
                return -1;
            }
            double dSlope = (z - z2) / this.getDistToNeighborInDir(i);
            if (!(dSlope > dMaxSlope)) continue;
            iDir = i;
            dMaxSlope = dSlope;
        }
        return iDir;
    }

    public String toString() {
        return this.getName();
    }
}

