/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.rasterimage.algorithms;

import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.operation.union.UnaryUnionOp;
import org.openjump.core.rasterimage.RasterImageIO;
import org.openjump.core.rasterimage.sextante.rasterWrappers.GridCell;
import org.openjump.core.rasterimage.sextante.rasterWrappers.GridExtent;
import org.openjump.core.ui.util.LayerableUtil;

public class RasterizeAlgorithm {
    private static Double noData = -99999.0;
    private static Double cellSize;
    private static double dValue;
    private static int m_iNX;
    private static int m_iNY;
    private static GridExtent m_Extent;
    private static WritableRaster raster;
    private static FeatureCollection featureCollection;
    private static String attrName;
    private static Envelope envelope;

    public RasterizeAlgorithm(Envelope limitEnvelope, FeatureCollection fCollection, String attributeName, double CellSize) throws OutOfMemoryError, Exception {
        featureCollection = fCollection;
        envelope = limitEnvelope;
        attrName = attributeName;
        cellSize = CellSize;
        m_Extent = new GridExtent();
        m_Extent.setValuesAndRaster(CellSize, CellSize, limitEnvelope, noData);
        m_iNX = m_Extent.getNX();
        m_iNY = m_Extent.getNY();
        raster = m_Extent.getRaster();
    }

    public void process() throws OutOfMemoryError, Exception {
        FeatureCollection fc2 = RasterizeAlgorithm.getFeaturesOverlappingEnvelope();
        FeatureCollection fc3 = RasterizeAlgorithm.unionByAttributeValue(fc2);
        if (!LayerableUtil.isPolygonalLayer(fc3)) {
            RasterizeAlgorithm.RasterizeAdbToolbox(fc3);
        } else {
            RasterizeAlgorithm.RasterizeSextante(fc3);
        }
    }

    public void saveToFile(File file) throws IOException {
        RasterImageIO rasterImageIO;
        Envelope m_Envelope = new Envelope(m_Extent.getXMin(), m_Extent.getXMax(), m_Extent.getYMin(), m_Extent.getYMax());
        RasterImageIO rasterImageIO2 = rasterImageIO = new RasterImageIO();
        Objects.requireNonNull(rasterImageIO2);
        rasterImageIO.writeImage(file, raster, m_Envelope, new RasterImageIO.CellSizeXY(rasterImageIO2, cellSize, cellSize), noData);
    }

    private static void RasterizeAdbToolbox(FeatureCollection fCollection) throws OutOfMemoryError, Exception {
        for (Feature feature : fCollection) {
            try {
                dValue = Double.parseDouble(feature.getAttribute(attrName).toString());
            }
            catch (Exception e) {
                dValue = noData;
            }
            RasterizeAlgorithm.rasterize(feature.getGeometry(), dValue);
        }
    }

    private static void RasterizeSextante(FeatureCollection fCollection) throws OutOfMemoryError {
        Coordinate[] coords = new Coordinate[]{new Coordinate(m_Extent.getXMin(), m_Extent.getYMin()), new Coordinate(m_Extent.getXMin(), m_Extent.getYMax()), new Coordinate(m_Extent.getXMax(), m_Extent.getYMax()), new Coordinate(m_Extent.getXMax(), m_Extent.getYMin()), new Coordinate(m_Extent.getXMin(), m_Extent.getYMin())};
        GeometryFactory gf = new GeometryFactory();
        LinearRing ring = gf.createLinearRing(coords);
        Polygon extent = gf.createPolygon(ring, null);
        List<Feature> inputC = fCollection.getFeatures();
        FeatureSchema schema = fCollection.getFeatureSchema();
        FeatureDataset inputFC = new FeatureDataset(inputC, schema);
        for (Feature feature : inputFC) {
            Geometry geometry;
            try {
                dValue = Double.parseDouble(feature.getAttribute(attrName).toString());
            }
            catch (Exception e) {
                dValue = noData;
            }
            if (!(geometry = feature.getGeometry()).intersects((Geometry)extent)) continue;
            RasterizeAlgorithm.doGeometry(geometry);
        }
    }

    public WritableRaster getRaster() {
        return raster;
    }

    public Envelope getEnvelope() {
        return new Envelope(m_Extent.getXMin(), m_Extent.getXMax(), m_Extent.getYMin(), m_Extent.getYMax());
    }

    private static void doPolygon(Geometry geom) {
        GeometryFactory gf = new GeometryFactory();
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            Polygon poly = (Polygon)geom.getGeometryN(i);
            LinearRing lr = gf.createLinearRing(poly.getExteriorRing().getCoordinates());
            Polygon part = gf.createPolygon(lr, null);
            RasterizeAlgorithm.doPolygonPart(part, false);
            for (int j = 0; j < poly.getNumInteriorRing(); ++j) {
                lr = gf.createLinearRing(poly.getInteriorRingN(j).getCoordinates());
                part = gf.createPolygon(lr, null);
                RasterizeAlgorithm.doPolygonPart(part, true);
            }
        }
    }

    private static void doPolygonPart(Polygon geom, boolean bIsHole) {
        int xStop;
        Coordinate p = new Coordinate();
        boolean[] bCrossing = new boolean[m_iNX];
        Envelope extent = geom.getEnvelopeInternal();
        int xStart = (int)((extent.getMinX() - m_Extent.getXMin()) / RasterizeAlgorithm.m_Extent.getCellSize().x) - 1;
        if (xStart < 0) {
            xStart = 0;
        }
        if ((xStop = (int)((extent.getMaxX() - m_Extent.getXMin()) / RasterizeAlgorithm.m_Extent.getCellSize().x) + 1) >= m_iNX) {
            xStop = m_iNX - 1;
        }
        Coordinate[] points = geom.getCoordinates();
        int y = 0;
        double yPos = m_Extent.getYMax();
        while (y < m_iNY) {
            if (yPos >= extent.getMinY() && yPos <= extent.getMaxY()) {
                Arrays.fill(bCrossing, false);
                Coordinate pLeft = new Coordinate(m_Extent.getXMin() - 1.0, yPos);
                Coordinate pRight = new Coordinate(m_Extent.getXMax() + 1.0, yPos);
                Coordinate pb = points[points.length - 1];
                for (int iPoint = 0; iPoint < points.length; ++iPoint) {
                    Coordinate pa = pb;
                    pb = points[iPoint];
                    if (!(pa.y <= yPos && yPos < pb.y) && (!(pa.y > yPos) || !(yPos >= pb.y))) continue;
                    RasterizeAlgorithm.getCrossing(p, pa, pb, pLeft, pRight);
                    int ix = (int)((p.x - m_Extent.getXMin()) / RasterizeAlgorithm.m_Extent.getCellSize().x + 1.0);
                    if (ix < 0) {
                        ix = 0;
                    } else if (ix >= m_iNX) {
                        ix = m_iNX - 1;
                    }
                    bCrossing[ix] = !bCrossing[ix];
                }
                boolean bFill = false;
                for (int x = xStart; x <= xStop; ++x) {
                    if (bCrossing[x]) {
                        boolean bl = bFill = !bFill;
                    }
                    if (!bFill) continue;
                    double dPrevValue = raster.getSampleDouble(x, y, 0);
                    if (bIsHole) {
                        if (dPrevValue != dValue) continue;
                        raster.setSample(x, y, 0, noData);
                        continue;
                    }
                    if (dPrevValue != noData) continue;
                    raster.setSample(x, y, 0, dValue);
                }
            }
            ++y;
            yPos -= RasterizeAlgorithm.m_Extent.getCellSize().y;
        }
    }

    private static void doLine(Geometry geom) {
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            Geometry part = geom.getGeometryN(i);
            RasterizeAlgorithm.doLineString(part);
        }
    }

    private static void doLineString(Geometry geom) {
        Coordinate[] coords = geom.getCoordinates();
        for (int i = 0; i < coords.length - 1; ++i) {
            double x = coords[i].x;
            double y = coords[i].y;
            double x2 = coords[i + 1].x;
            double y2 = coords[i + 1].y;
            RasterizeAlgorithm.writeSegment(x, y, x2, y2);
        }
    }

    private static void writeSegment(double x, double y, double x2, double y2) {
        double dx = Math.abs(x2 - x);
        double dy = Math.abs(y2 - y);
        if (dx > 0.0 || dy > 0.0) {
            double n;
            if (dx > dy) {
                n = dx /= cellSize.doubleValue();
                dy /= dx;
                dx = cellSize;
            } else {
                n = dy /= cellSize.doubleValue();
                dx /= dy;
                dy = cellSize;
            }
            if (x2 < x) {
                dx = -dx;
            }
            if (y2 < y) {
                dy = -dy;
            }
            double d = 0.0;
            while (d <= n) {
                if (m_Extent.contains(x, y)) {
                    GridCell cell = m_Extent.getGridCoordsFromWorldCoords(x, y);
                    raster.setSample(cell.getX(), cell.getY(), 0, dValue);
                }
                d += 1.0;
                x += dx;
                y += dy;
            }
        }
    }

    private static void doPoint(Geometry geometry) {
        Coordinate coord = geometry.getCoordinate();
        Point cell = m_Extent.getGridCoordsFromWorldCoords(coord);
        raster.setSample(cell.x, cell.y, 0, dValue);
    }

    private static boolean getCrossing(Coordinate crossing, Coordinate a1, Coordinate a2, Coordinate b1, Coordinate b2) {
        double a_dx = a2.x - a1.x;
        double b_dy = b2.y - b1.y;
        double b_dx = b2.x - b1.x;
        double a_dy = a2.y - a1.y;
        double div = a_dx * b_dy - b_dx * a_dy;
        if (div != 0.0) {
            double lambda = ((b1.x - a1.x) * b_dy - b_dx * (b1.y - a1.y)) / div;
            crossing.x = a1.x + lambda * a_dx;
            crossing.y = a1.y + lambda * a_dy;
            return true;
        }
        return false;
    }

    private static void doGeometry(Geometry geometry) {
        if (geometry.getGeometryType().equals("Point") || geometry.getGeometryType().equals("MultiPoint")) {
            RasterizeAlgorithm.doPoint(geometry);
        } else if (geometry.getGeometryType().equals("LineString") || geometry.getGeometryType().equals("MultiLineString")) {
            RasterizeAlgorithm.doLine(geometry);
        } else if (geometry.getGeometryType().equals("Polygon") || geometry.getGeometryType().equals("MultiPolygon")) {
            RasterizeAlgorithm.doPolygon(geometry);
        } else if (geometry instanceof GeometryCollection) {
            for (int j = 0; j < geometry.getNumGeometries(); ++j) {
                Geometry geometry2 = geometry.getGeometryN(j);
                if (geometry2.getGeometryType().equals("Point") || geometry2.getGeometryType().equals("MultiPoint")) {
                    RasterizeAlgorithm.doPoint(geometry2);
                    continue;
                }
                if (geometry2.getGeometryType().equals("LineString") || geometry2.getGeometryType().equals("MultiLineString")) {
                    RasterizeAlgorithm.doLine(geometry2);
                    continue;
                }
                if (!geometry2.getGeometryType().equals("Polygon") && !geometry2.getGeometryType().equals("MultiPolygon")) continue;
                RasterizeAlgorithm.doPolygon(geometry2);
            }
        }
    }

    private static FeatureCollection unionByAttributeValue(FeatureCollection featureCollection) throws Exception {
        FeatureDataset outputFC = new FeatureDataset(featureCollection.getFeatureSchema());
        HashMap<Object, FeatureDataset> map = new HashMap<Object, FeatureDataset>();
        for (Feature feature : featureCollection.getFeatures()) {
            Object key = feature.getAttribute(attrName);
            if (!map.containsKey(key)) {
                FeatureDataset fd = new FeatureDataset(featureCollection.getFeatureSchema());
                fd.add(feature);
                map.put(key, fd);
                continue;
            }
            ((FeatureCollection)map.get(key)).add(feature);
        }
        for (Object key : map.keySet()) {
            FeatureCollection fca = (FeatureCollection)map.get(key);
            if (fca.size() <= 0) continue;
            Feature feature = RasterizeAlgorithm.union(fca);
            feature.setAttribute(attrName, key);
            outputFC.add(feature);
        }
        return outputFC;
    }

    private static Feature union(FeatureCollection fc) {
        GeometryFactory factory = new GeometryFactory();
        ArrayList<Geometry> geometries = new ArrayList<Geometry>();
        for (Feature f : fc.getFeatures()) {
            Geometry g = f.getGeometry();
            geometries.add(g);
        }
        Geometry unioned = UnaryUnionOp.union(geometries);
        FeatureSchema schema = fc.getFeatureSchema();
        BasicFeature feature = new BasicFeature(schema);
        if (geometries.size() == 0) {
            feature.setGeometry((Geometry)factory.createGeometryCollection(new Geometry[0]));
        } else {
            feature.setGeometry(unioned);
        }
        return feature;
    }

    private static FeatureCollection getFeaturesOverlappingEnvelope() throws Exception {
        List<Feature> inputC = featureCollection.getFeatures();
        FeatureSchema schema1 = featureCollection.getFeatureSchema();
        FeatureDataset inputFC = new FeatureDataset(inputC, schema1);
        FeatureSchema schema = new FeatureSchema();
        schema.addAttribute("GEOMETRY", AttributeType.GEOMETRY);
        schema.addAttribute(attrName, AttributeType.DOUBLE);
        FeatureDataset outputFC = new FeatureDataset(schema);
        GeometryFactory factory = new GeometryFactory();
        Geometry geom = factory.toGeometry(envelope);
        for (Feature f : inputFC.getFeatures()) {
            Geometry g = f.getGeometry();
            if (geom.disjoint(g)) continue;
            outputFC.add(f);
        }
        return outputFC;
    }

    private static void rasterize(Geometry geom, double value) throws Exception, OutOfMemoryError {
        BufferedImage bimage = new BufferedImage(m_iNX, m_iNY, 2);
        bimage.setAccelerationPriority(1.0f);
        Graphics2D graphics = bimage.createGraphics();
        Color color = new Color(100);
        graphics.setPaint(color);
        graphics.setPaintMode();
        for (int g = 0; g < geom.getNumGeometries(); ++g) {
            int[] coordGridY;
            int[] coordGridX;
            Coordinate[] coord;
            if (geom.getGeometryN(g).getGeometryType().equals("Polygon")) {
                Area awtArea;
                java.awt.Polygon awtPolygon;
                Polygon polygon = (Polygon)geom.getGeometryN(g);
                if (polygon.getNumInteriorRing() > 0) {
                    coord = polygon.getExteriorRing().getCoordinates();
                    coordGridX = new int[coord.length];
                    coordGridY = new int[coord.length];
                    for (int p = 0; p < coord.length; ++p) {
                        Point point = m_Extent.getGridCoordsFromWorldCoords(coord[p]);
                        coordGridX[p] = point.x;
                        coordGridY[p] = point.y;
                    }
                    awtPolygon = new java.awt.Polygon(coordGridX, coordGridY, coord.length);
                    awtArea = new Area(awtPolygon);
                    for (int ir = 0; ir < polygon.getNumInteriorRing(); ++ir) {
                        coord = polygon.getInteriorRingN(ir).getCoordinates();
                        coordGridX = new int[coord.length];
                        coordGridY = new int[coord.length];
                        for (int p = 0; p < coord.length; ++p) {
                            Point point = m_Extent.getGridCoordsFromWorldCoords(coord[p]);
                            coordGridX[p] = point.x;
                            coordGridY[p] = point.y;
                        }
                        awtPolygon = new java.awt.Polygon(coordGridX, coordGridY, coord.length);
                        Area awtArea2 = new Area(awtPolygon);
                        awtArea.subtract(awtArea2);
                    }
                } else {
                    coord = polygon.getCoordinates();
                    coordGridX = new int[coord.length];
                    coordGridY = new int[coord.length];
                    for (int p = 0; p < coord.length; ++p) {
                        Point point = m_Extent.getGridCoordsFromWorldCoords(coord[p]);
                        coordGridX[p] = point.x;
                        coordGridY[p] = point.y;
                    }
                    awtPolygon = new java.awt.Polygon(coordGridX, coordGridY, coord.length);
                    awtArea = new Area(awtPolygon);
                }
                graphics.setPaint(color);
                graphics.setPaintMode();
                graphics.draw(awtArea);
                graphics.fill(awtArea);
                continue;
            }
            coord = geom.getGeometryN(g).getCoordinates();
            coordGridX = new int[coord.length];
            coordGridY = new int[coord.length];
            for (int p = 0; p < coord.length; ++p) {
                Point point = m_Extent.getGridCoordsFromWorldCoords(coord[p]);
                coordGridX[p] = point.x;
                coordGridY[p] = point.y;
            }
            if (geom.getGeometryN(g).getGeometryType().equals("LineString") || geom.getGeometryN(g).getGeometryType().equals("MultiLineString")) {
                graphics.setPaint(color);
                graphics.setPaintMode();
                graphics.drawPolyline(coordGridX, coordGridY, coord.length);
                continue;
            }
            if (!geom.getGeometryN(g).getGeometryType().equals("Point") && !geom.getGeometryN(g).getGeometryType().equals("MultiPoint")) continue;
            graphics.setPaint(color);
            graphics.setPaintMode();
            graphics.fillRect(coordGridX[0], coordGridY[0], 1, 1);
        }
        for (int r = 0; r < m_iNY; ++r) {
            for (int c = 0; c < m_iNX; ++c) {
                if (bimage.getRGB(c, r) == 0 || bimage.getRGB(c, r) == -1) continue;
                raster.setSample(c, m_iNY - r - 1, 0, dValue);
            }
        }
    }
}

