/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.rasterimage;

import com.vividsolutions.jump.util.FileUtil;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.GenericNames;
import com.vividsolutions.jump.workbench.ui.Viewport;
import java.awt.Point;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.text.NumberFormat;
import java.util.Objects;
import java.util.Properties;
import javax.imageio.ImageIO;
import javax.media.jai.PlanarImage;
import org.locationtech.jts.geom.Envelope;
import org.openjump.core.rasterimage.GridAscii;
import org.openjump.core.rasterimage.GridFloat;
import org.openjump.core.rasterimage.ImageAndMetadata;
import org.openjump.core.rasterimage.RasterImageIO;
import org.openjump.core.rasterimage.RasterImageLayer;
import org.openjump.core.rasterimage.Resolution;
import org.openjump.core.rasterimage.TiffTags;
import org.openjump.core.rasterimage.WorldFileHandler;
import org.openjump.core.rasterimage.sextante.OpenJUMPSextanteRasterLayer;
import org.openjump.core.rasterimage.sextante.rasterWrappers.GridWrapperNotInterpolated;

public class RasterImageIOUtils {
    static Properties properties = null;
    private static final String byteOrder = "LSBFIRST";
    private static final String propertiesFile = "path";
    static NumberFormat cellFormat = null;
    public static double defaultNoData = -99999.0;

    public static void saveTIF(File file, RasterImageLayer rLayer, Envelope envWanted) throws IOException {
        RasterImageIO rasterImageIO = new RasterImageIO();
        Raster raster = rLayer.getRasterData(rLayer.getRectangleFromEnvelope(envWanted));
        RasterImageIO rasterImageIO2 = rasterImageIO;
        Objects.requireNonNull(rasterImageIO2);
        rasterImageIO.writeImage(file, raster, envWanted, rasterImageIO2.new RasterImageIO.CellSizeXY(rLayer.getMetadata().getOriginalCellSize(), rLayer.getMetadata().getOriginalCellSize()), rLayer.getMetadata().getNoDataValue());
    }

    public static void saveTIF(File file, RasterImageLayer rLayer, Envelope envWanted, int band) throws NoninvertibleTransformException, TiffTags.TiffReadingException, Exception {
        BufferedImage bi = rLayer.getImage();
        int w = bi.getWidth();
        int h = bi.getHeight();
        for (int x = 0; x <= w; ++x) {
            for (int y = 0; y <= h; ++y) {
                int pixelCol = bi.getRGB(x, y);
                if (band == 0) {
                    bi.setRGB(x, y, pixelCol &= 0xFF0000);
                    continue;
                }
                if (band == 1) {
                    bi.setRGB(x, y, pixelCol &= 0xFF00);
                    continue;
                }
                if (band != 2) continue;
                bi.setRGB(x, y, pixelCol &= 0xFF);
            }
        }
        RasterImageIO rasterImageIO = new RasterImageIO();
        Raster raster = bi.getData();
        RasterImageIO rasterImageIO2 = rasterImageIO;
        Objects.requireNonNull(rasterImageIO2);
        rasterImageIO.writeImage(file, raster, envWanted, rasterImageIO2.new RasterImageIO.CellSizeXY(rLayer.getMetadata().getOriginalCellSize(), rLayer.getMetadata().getOriginalCellSize()), rLayer.getMetadata().getNoDataValue());
    }

    public static void saveImage(File file, String format, BufferedImage bufferedimage, Envelope envelope) throws IOException {
        ImageIO.write((RenderedImage)bufferedimage, format, file);
        WorldFileHandler worldFileHandler = new WorldFileHandler(file.getAbsolutePath(), false);
        worldFileHandler.writeWorldFile(envelope, bufferedimage.getWidth(), bufferedimage.getHeight());
    }

    public static void saveTIF_ImageIO(File file, Envelope envelope, PlanarImage planarimage) throws IOException {
        ImageIO.write((RenderedImage)planarimage, "tif", file);
        WorldFileHandler worldFileHandler = new WorldFileHandler(file.getAbsolutePath(), false);
        worldFileHandler.writeWorldFile(envelope, planarimage.getWidth(), planarimage.getHeight());
    }

    public static void saveASC(File outfile, PlugInContext context, RasterImageLayer rLayer) throws IOException {
        RasterImageIOUtils.saveASC(outfile, context, rLayer, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveASC(File file, PlugInContext context, RasterImageLayer rLayer, int band) throws IOException {
        try (OutputStream out = null;){
            OpenJUMPSextanteRasterLayer rstLayer = new OpenJUMPSextanteRasterLayer();
            rstLayer.create(rLayer);
            out = new FileOutputStream(file);
            cellFormat = NumberFormat.getNumberInstance();
            cellFormat.setMaximumFractionDigits(3);
            cellFormat.setMinimumFractionDigits(0);
            properties = new Properties();
            try {
                FileInputStream fis = new FileInputStream(propertiesFile);
                properties.load(fis);
                properties.getProperty(propertiesFile);
                fis.close();
            }
            catch (FileNotFoundException fis) {
            }
            catch (IOException e) {
                context.getWorkbenchFrame().warnUser(GenericNames.ERROR);
            }
            PrintStream o = new PrintStream(out);
            o.println("ncols " + rLayer.getOrigImageWidth());
            o.println("nrows " + rLayer.getOrigImageHeight());
            o.println("xllcorner " + rLayer.getActualImageEnvelope().getMinX());
            o.println("yllcorner " + rLayer.getActualImageEnvelope().getMinY());
            o.println("cellsize " + rstLayer.getLayerCellSize().x);
            String sNoDataVal = Double.toString(rstLayer.getNoDataValue());
            o.println("NODATA_value " + sNoDataVal);
            GridWrapperNotInterpolated gwrapper = new GridWrapperNotInterpolated(rstLayer, rstLayer.getLayerGridExtent());
            int nx = rstLayer.getLayerGridExtent().getNX();
            int ny = rstLayer.getLayerGridExtent().getNY();
            for (int y = 0; y < ny; ++y) {
                StringBuffer b = new StringBuffer();
                for (int x = 0; x < nx; ++x) {
                    double value = gwrapper.getCellValueAsDouble(x, y, band);
                    if (Double.isNaN(value)) {
                        value = defaultNoData;
                    }
                    if (Math.floor(value) == value) {
                        b.append((int)value + " ");
                        continue;
                    }
                    b.append(value + " ");
                }
                o.println(b);
            }
            o.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveHDR(File outFile, PlugInContext context, RasterImageLayer rLayer) throws IOException {
        try (OutputStream out = null;){
            OpenJUMPSextanteRasterLayer rstLayer = new OpenJUMPSextanteRasterLayer();
            rstLayer.create(rLayer);
            out = new FileOutputStream(outFile);
            NumberFormat cellFormat = NumberFormat.getNumberInstance();
            cellFormat.setMaximumFractionDigits(3);
            cellFormat.setMinimumFractionDigits(0);
            Properties properties = new Properties();
            try {
                FileInputStream fis = new FileInputStream(propertiesFile);
                properties.load(fis);
                properties.getProperty(propertiesFile);
                fis.close();
            }
            catch (FileNotFoundException fis) {
            }
            catch (IOException e) {
                context.getWorkbenchFrame().warnUser(GenericNames.ERROR);
            }
            PrintStream o = new PrintStream(out);
            o.println("ncols " + rLayer.getOrigImageWidth());
            o.println("nrows " + rLayer.getOrigImageHeight());
            o.println("xllcorner " + rLayer.getWholeImageEnvelope().getMinX());
            o.println("yllcorner " + rLayer.getWholeImageEnvelope().getMinY());
            o.println("cellsize " + rstLayer.getLayerCellSize().x);
            String sNoDataVal = Double.toString(rstLayer.getNoDataValue());
            o.println("NODATA_value " + sNoDataVal);
            o.println("byteorder LSBFIRST");
            o.close();
        }
    }

    public static void saveFLT(File outfile, PlugInContext context, RasterImageLayer rLayer) throws IOException {
        RasterImageIOUtils.saveFLT(outfile, context, rLayer, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveFLT(File outFile, PlugInContext context, RasterImageLayer rLayer, int band) throws IOException {
        try (FileOutputStream out = null;){
            OpenJUMPSextanteRasterLayer rstLayer = new OpenJUMPSextanteRasterLayer();
            rstLayer.create(rLayer);
            out = new FileOutputStream(outFile);
            NumberFormat cellFormat = NumberFormat.getNumberInstance();
            cellFormat.setMaximumFractionDigits(3);
            cellFormat.setMinimumFractionDigits(0);
            Properties properties = new Properties();
            try {
                FileInputStream fis = new FileInputStream(propertiesFile);
                properties.load(fis);
                properties.getProperty(propertiesFile);
                fis.close();
            }
            catch (FileNotFoundException fis) {
            }
            catch (IOException e) {
                context.getWorkbenchFrame().warnUser(GenericNames.ERROR);
            }
            FileChannel fileChannelOut = out.getChannel();
            GridWrapperNotInterpolated gwrapper = new GridWrapperNotInterpolated(rstLayer, rstLayer.getLayerGridExtent());
            int nx = rstLayer.getLayerGridExtent().getNX();
            int ny = rstLayer.getLayerGridExtent().getNY();
            ByteBuffer bb = ByteBuffer.allocateDirect(nx * 4);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            for (int y = 0; y < ny; ++y) {
                for (int x = 0; x < nx; ++x) {
                    float value = gwrapper.getCellValueAsFloat(x, y, band);
                    if (bb.hasRemaining()) {
                        bb.putFloat(value);
                        continue;
                    }
                    --x;
                    bb.compact();
                    fileChannelOut.write(bb);
                    bb.clear();
                }
            }
            bb.compact();
            fileChannelOut.write(bb);
            bb.clear();
        }
    }

    public static void saveSurferGRD(File outfile, PlugInContext context, RasterImageLayer rLayer) throws IOException {
        RasterImageIOUtils.saveSurferGRD(outfile, context, rLayer, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveSurferGRD(File outfile, PlugInContext context, RasterImageLayer rLayer, int band) throws IOException {
        try (OutputStream out = null;){
            OpenJUMPSextanteRasterLayer rstLayer = new OpenJUMPSextanteRasterLayer();
            rstLayer.create(rLayer);
            out = new FileOutputStream(outfile);
            cellFormat = NumberFormat.getNumberInstance();
            cellFormat.setMaximumFractionDigits(3);
            cellFormat.setMinimumFractionDigits(0);
            properties = new Properties();
            try {
                FileInputStream fis = new FileInputStream(propertiesFile);
                properties.load(fis);
                properties.getProperty(propertiesFile);
                fis.close();
            }
            catch (FileNotFoundException fis) {
            }
            catch (IOException e) {
                context.getWorkbenchFrame().warnUser(GenericNames.ERROR);
            }
            defaultNoData = rstLayer.getNoDataValue();
            Double xcMin = rLayer.getActualImageEnvelope().getMinX() + 0.5 * rstLayer.getLayerCellSize().x;
            Double ycMin = rLayer.getActualImageEnvelope().getMinY() + 0.5 * rstLayer.getLayerCellSize().y;
            Double xcMax = rLayer.getActualImageEnvelope().getMaxX() - 0.5 * rstLayer.getLayerCellSize().x;
            Double ycMax = rLayer.getActualImageEnvelope().getMaxY() - 0.5 * rstLayer.getLayerCellSize().y;
            PrintStream po = new PrintStream(out);
            po.println("DSAA");
            po.println(rLayer.getOrigImageWidth() + " " + rLayer.getOrigImageHeight());
            po.println(xcMin + " " + xcMax);
            po.println(ycMin + " " + ycMax);
            po.println("0 1");
            po.println(rstLayer.getMinValue() + " " + rstLayer.getMaxValue());
            GridWrapperNotInterpolated gwrapper = new GridWrapperNotInterpolated(rstLayer, rstLayer.getLayerGridExtent());
            int nx = rstLayer.getLayerGridExtent().getNX();
            int ny = rstLayer.getLayerGridExtent().getNY();
            double nodata = rstLayer.getNoDataValue();
            for (int y = ny; y >= 0; --y) {
                StringBuffer b = new StringBuffer();
                for (int x = 0; x < nx; ++x) {
                    double value = gwrapper.getCellValueAsDouble(x, y, band);
                    if (value == nodata) {
                        b.append("1.70141E+38 ");
                        continue;
                    }
                    if (Math.floor(value) == value) {
                        b.append((int)value + " ");
                        continue;
                    }
                    b.append(value + " ");
                }
                po.println(b);
            }
            po.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveXYZ(File outfile, PlugInContext context, RasterImageLayer rLayer) throws IOException {
        try (OutputStream out = null;){
            OpenJUMPSextanteRasterLayer rstLayer = new OpenJUMPSextanteRasterLayer();
            rstLayer.create(rLayer);
            int numBands = rLayer.getNumBands();
            out = new FileOutputStream(outfile);
            cellFormat = NumberFormat.getNumberInstance();
            cellFormat.setMaximumFractionDigits(3);
            cellFormat.setMinimumFractionDigits(0);
            properties = new Properties();
            try {
                FileInputStream fis = new FileInputStream(propertiesFile);
                properties.load(fis);
                properties.getProperty(propertiesFile);
                fis.close();
            }
            catch (FileNotFoundException fis) {
            }
            catch (IOException e) {
                context.getWorkbenchFrame().warnUser(GenericNames.ERROR);
            }
            PrintStream po = new PrintStream(out);
            po.append("coordinateX\tcoordinateY");
            for (int b = 0; b < numBands; ++b) {
                int n = b + 1;
                po.append("\tband" + n);
            }
            po.append("\n");
            GridWrapperNotInterpolated gwrapper = new GridWrapperNotInterpolated(rstLayer, rstLayer.getLayerGridExtent());
            int nx = rstLayer.getLayerGridExtent().getNX();
            int ny = rstLayer.getLayerGridExtent().getNY();
            for (int y = 0; y < ny; ++y) {
                StringBuffer b = new StringBuffer();
                for (int x = 0; x < nx; ++x) {
                    double value0 = gwrapper.getCellValueAsDouble(x, y, 0);
                    double value1 = gwrapper.getCellValueAsDouble(x, y, 1);
                    double value2 = gwrapper.getCellValueAsDouble(x, y, 2);
                    Point2D pt = rstLayer.getLayerGridExtent().getWorldCoordsFromGridCoords(x, y);
                    double Xf = pt.getX();
                    double Yf = pt.getY();
                    if (Double.isNaN(value0) || Double.isNaN(value1) || Double.isNaN(value2)) {
                        value0 = defaultNoData;
                        value1 = defaultNoData;
                        value2 = defaultNoData;
                    }
                    if (Math.floor(value0) == value0 || Math.floor(value1) == value1 || Math.floor(value2) == value2) {
                        b.append(Xf + "\t" + Yf + "\t" + value0 + "\t" + value1 + "\t" + value2 + "\n");
                        continue;
                    }
                    b.append(Xf + "\t" + Yf + "\t" + value0 + value1 + value2 + "\n");
                }
                po.println(b);
            }
            po.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveGrass(File file, PlugInContext context, RasterImageLayer rLayer, int band) throws IOException {
        try (OutputStream out = null;){
            OpenJUMPSextanteRasterLayer rstLayer = new OpenJUMPSextanteRasterLayer();
            rstLayer.create(rLayer);
            out = new FileOutputStream(file);
            cellFormat = NumberFormat.getNumberInstance();
            cellFormat.setMaximumFractionDigits(3);
            cellFormat.setMinimumFractionDigits(0);
            properties = new Properties();
            try {
                FileInputStream fis = new FileInputStream(propertiesFile);
                properties.load(fis);
                properties.getProperty(propertiesFile);
                fis.close();
            }
            catch (FileNotFoundException fis) {
            }
            catch (IOException e) {
                context.getWorkbenchFrame().warnUser(GenericNames.ERROR);
            }
            PrintStream o = new PrintStream(out);
            o.println("north: " + rLayer.getActualImageEnvelope().getMaxY());
            o.println("south: " + rLayer.getActualImageEnvelope().getMinY());
            o.println("east: " + rLayer.getActualImageEnvelope().getMinX());
            o.println("west: " + rLayer.getActualImageEnvelope().getMaxY());
            Raster r = rLayer.getRasterData(null);
            o.println("rows: " + r.getWidth());
            o.println("cols: " + r.getHeight());
            GridWrapperNotInterpolated gwrapper = new GridWrapperNotInterpolated(rstLayer, rstLayer.getLayerGridExtent());
            int nx = rstLayer.getLayerGridExtent().getNX();
            int ny = rstLayer.getLayerGridExtent().getNY();
            for (int y = 0; y < ny; ++y) {
                StringBuffer b = new StringBuffer();
                for (int x = 0; x < nx; ++x) {
                    double value = gwrapper.getCellValueAsDouble(x, y, band);
                    if (Double.isNaN(value)) {
                        value = -9999.0;
                        continue;
                    }
                    b.append(value + " ");
                }
                o.println(b);
            }
            o.close();
        }
    }

    public static void load(File file, PlugInContext context, String category) throws NoninvertibleTransformException, TiffTags.TiffReadingException, Exception {
        String extension = FileUtil.getExtension(file);
        if (extension.equals("tif")) {
            RasterImageIOUtils.loadTIF(file, context, category);
        } else if (extension.equals("asc")) {
            RasterImageIOUtils.loadASC(file, context, category);
        } else if (extension.equals("flt")) {
            RasterImageIOUtils.loadFLT(file, context, category);
        }
    }

    public static void loadTIF(File file, PlugInContext context, String category) throws Exception {
        RasterImageIO rasterImageIO = new RasterImageIO();
        Viewport viewport = context.getWorkbenchContext().getLayerViewPanel().getViewport();
        Resolution requestedRes = RasterImageIO.calcRequestedResolution(viewport);
        ImageAndMetadata imageAndMetadata = rasterImageIO.loadImage(file.getAbsolutePath(), null, viewport.getEnvelopeInModelCoordinates(), requestedRes);
        Point point = RasterImageIO.getImageDimensions(file.getAbsolutePath());
        Envelope env = RasterImageIO.getGeoReferencing(file.getAbsolutePath(), true, point);
        RasterImageLayer ril = new RasterImageLayer(file.getName(), context.getWorkbenchContext().getLayerManager(), file.getAbsolutePath(), imageAndMetadata.getImage(), env);
        try {
            category = ((Category)context.getLayerNamePanel().getSelectedCategories().toArray()[0]).getName();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        context.getLayerManager().addLayerable(category, ril);
    }

    public static void loadFLT(File file, PlugInContext context, String category) throws NoninvertibleTransformException, TiffTags.TiffReadingException, Exception {
        RasterImageIO rasterImageIO = new RasterImageIO();
        Viewport viewport = context.getWorkbenchContext().getLayerViewPanel().getViewport();
        Resolution requestedRes = RasterImageIO.calcRequestedResolution(viewport);
        ImageAndMetadata imageAndMetadata = rasterImageIO.loadImage(file.getAbsolutePath(), null, viewport.getEnvelopeInModelCoordinates(), requestedRes);
        GridFloat gf = new GridFloat(file.getAbsolutePath());
        Envelope imageEnvelope = new Envelope(gf.getXllCorner(), gf.getXllCorner() + (double)gf.getnCols() * gf.getCellSize(), gf.getYllCorner(), gf.getYllCorner() + (double)gf.getnRows() * gf.getCellSize());
        RasterImageLayer ril = new RasterImageLayer(file.getName(), context.getWorkbenchContext().getLayerManager(), file.getAbsolutePath(), imageAndMetadata.getImage(), imageEnvelope);
        try {
            category = ((Category)context.getLayerNamePanel().getSelectedCategories().toArray()[0]).getName();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        context.getLayerManager().addLayerable(category, ril);
    }

    public static void loadASC(File file, PlugInContext context, String category) throws Exception {
        RasterImageIO rasterImageIO = new RasterImageIO();
        Viewport viewport = context.getWorkbenchContext().getLayerViewPanel().getViewport();
        Resolution requestedRes = RasterImageIO.calcRequestedResolution(viewport);
        ImageAndMetadata imageAndMetadatar = rasterImageIO.loadImage(file.getAbsolutePath(), null, viewport.getEnvelopeInModelCoordinates(), requestedRes);
        GridAscii gf = new GridAscii(file.getAbsolutePath());
        Envelope imageEnvelope = new Envelope(gf.getXllCorner(), gf.getXllCorner() + (double)gf.getnCols() * gf.getCellSize(), gf.getYllCorner(), gf.getYllCorner() + (double)gf.getnRows() * gf.getCellSize());
        RasterImageLayer rasterlayer = new RasterImageLayer(file.getName(), context.getWorkbenchContext().getLayerManager(), file.getAbsolutePath(), imageAndMetadatar.getImage(), imageEnvelope);
        try {
            category = ((Category)context.getLayerNamePanel().getSelectedCategories().toArray()[0]).getName();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        context.getLayerManager().addLayerable(category, rasterlayer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveFLT_mask(File outFile, PlugInContext context, RasterImageLayer rLayer, int band, float mindata, float maxdata, float nodata) throws IOException {
        try (FileOutputStream out = null;){
            OpenJUMPSextanteRasterLayer rstLayer = new OpenJUMPSextanteRasterLayer();
            rstLayer.create(rLayer);
            out = new FileOutputStream(outFile);
            cellFormat = NumberFormat.getNumberInstance();
            cellFormat.setMaximumFractionDigits(3);
            cellFormat.setMinimumFractionDigits(0);
            properties = new Properties();
            try {
                FileInputStream fis = new FileInputStream(propertiesFile);
                properties.load(fis);
                properties.getProperty(propertiesFile);
                fis.close();
            }
            catch (FileNotFoundException fis) {
            }
            catch (IOException e) {
                context.getWorkbenchFrame().warnUser(GenericNames.ERROR);
            }
            FileChannel fileChannelOut = out.getChannel();
            GridWrapperNotInterpolated gwrapper = new GridWrapperNotInterpolated(rstLayer, rstLayer.getLayerGridExtent());
            int nx = rstLayer.getLayerGridExtent().getNX();
            int ny = rstLayer.getLayerGridExtent().getNY();
            ByteBuffer bb = ByteBuffer.allocateDirect(nx * 4);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            for (int y = 0; y < ny; ++y) {
                for (int x = 0; x < nx; ++x) {
                    float value = gwrapper.getCellValueAsFloat(x, y, band);
                    if (bb.hasRemaining()) {
                        if (value >= mindata && value <= maxdata) {
                            bb.putFloat(nodata);
                            continue;
                        }
                        bb.putFloat(value);
                        continue;
                    }
                    --x;
                    bb.compact();
                    fileChannelOut.write(bb);
                    bb.clear();
                }
            }
            bb.compact();
            fileChannelOut.write(bb);
            bb.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveFLT_extract(File outFile, PlugInContext context, RasterImageLayer rLayer, int band, float mindata, float maxdata, float nodata) throws IOException {
        try (FileOutputStream out = null;){
            OpenJUMPSextanteRasterLayer rstLayer = new OpenJUMPSextanteRasterLayer();
            rstLayer.create(rLayer);
            out = new FileOutputStream(outFile);
            cellFormat = NumberFormat.getNumberInstance();
            cellFormat.setMaximumFractionDigits(3);
            cellFormat.setMinimumFractionDigits(0);
            properties = new Properties();
            try {
                FileInputStream fis = new FileInputStream(propertiesFile);
                properties.load(fis);
                properties.getProperty(propertiesFile);
                fis.close();
            }
            catch (FileNotFoundException fis) {
            }
            catch (IOException e) {
                context.getWorkbenchFrame().warnUser(GenericNames.ERROR);
            }
            FileChannel fileChannelOut = out.getChannel();
            GridWrapperNotInterpolated gwrapper = new GridWrapperNotInterpolated(rstLayer, rstLayer.getLayerGridExtent());
            int nx = rstLayer.getLayerGridExtent().getNX();
            int ny = rstLayer.getLayerGridExtent().getNY();
            ByteBuffer bb = ByteBuffer.allocateDirect(nx * 4);
            bb.order(ByteOrder.LITTLE_ENDIAN);
            for (int y = 0; y < ny; ++y) {
                for (int x = 0; x < nx; ++x) {
                    float value = gwrapper.getCellValueAsFloat(x, y, band);
                    if (bb.hasRemaining()) {
                        if (value >= mindata && value <= maxdata) {
                            bb.putFloat(value);
                            continue;
                        }
                        bb.putFloat(nodata);
                        continue;
                    }
                    --x;
                    bb.compact();
                    fileChannelOut.write(bb);
                    bb.clear();
                }
            }
            bb.compact();
            fileChannelOut.write(bb);
            bb.clear();
        }
    }
}

