/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.ccordsys.srid;

import com.vividsolutions.jump.coordsys.CoordinateSystem;
import com.vividsolutions.jump.util.Block;
import com.vividsolutions.jump.workbench.model.CategoryEvent;
import com.vividsolutions.jump.workbench.model.FeatureEvent;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.LayerEvent;
import com.vividsolutions.jump.workbench.model.LayerListener;
import com.vividsolutions.jump.workbench.model.LayerManager;
import com.vividsolutions.jump.workbench.model.LayerManagerProxy;
import com.vividsolutions.jump.workbench.plugin.AbstractPlugIn;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import com.vividsolutions.jump.workbench.ui.WorkbenchFrame;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.JInternalFrame;
import org.openjump.core.ccordsys.srid.SRIDStyle;
import org.openjump.core.model.TaskEvent;
import org.openjump.core.model.TaskListener;

public class EnsureAllLayersHaveSRIDStylePlugIn
extends AbstractPlugIn {
    @Override
    public void initialize(PlugInContext context) throws Exception {
        super.initialize(context);
        this.initializeCurrentAndFutureInternalFrames(context.getWorkbenchFrame(), new Block(){
            private Collection<JInternalFrame> initializedFrames = new ArrayList<JInternalFrame>();

            @Override
            public Object yield(Object internalFrame) {
                if (internalFrame instanceof JInternalFrame && !this.initializedFrames.contains(internalFrame)) {
                    EnsureAllLayersHaveSRIDStylePlugIn.this.initialize((JInternalFrame)internalFrame);
                    this.initializedFrames.add((JInternalFrame)internalFrame);
                }
                return null;
            }
        });
    }

    private void initialize(JInternalFrame internalFrame) {
        if (!(internalFrame instanceof LayerManagerProxy)) {
            return;
        }
        this.initialize(((LayerManagerProxy)((Object)internalFrame)).getLayerManager());
    }

    private void initialize(LayerManager layerManager) {
        for (Layer layer : layerManager.getLayers()) {
            this.ensureHasSRIDStyle(layer);
        }
        LayerListener layerListener = new LayerListener(){

            @Override
            public void featuresChanged(FeatureEvent e) {
            }

            @Override
            public void layerChanged(LayerEvent e) {
                if (e.getLayerable() instanceof Layer) {
                    EnsureAllLayersHaveSRIDStylePlugIn.this.ensureHasSRIDStyle((Layer)e.getLayerable());
                }
            }

            @Override
            public void categoryChanged(CategoryEvent e) {
            }
        };
        layerManager.addLayerListener(layerListener);
    }

    private void ensureHasSRIDStyle(Layer layer) {
        if (layer.getStyle(SRIDStyle.class) != null) {
            return;
        }
        SRIDStyle sridStyle = new SRIDStyle();
        int srid = sridStyle.getSRID();
        CoordinateSystem cs = layer.getFeatureCollectionWrapper().getFeatureSchema().getCoordinateSystem();
        if (!cs.equals(CoordinateSystem.UNSPECIFIED)) {
            srid = cs.getEPSGCode();
        } else if (layer.getFeatureCollectionWrapper().size() > 0) {
            srid = layer.getFeatureCollectionWrapper().iterator().next().getGeometry().getSRID();
        }
        sridStyle.setSRID(srid);
        layer.addStyle(sridStyle);
    }

    private void initializeCurrentAndFutureInternalFrames(WorkbenchFrame workbenchFrame, Block block) {
        workbenchFrame.addTaskListener(new TaskListener(){

            @Override
            public void taskAdded(TaskEvent taskEvent) {
                EnsureAllLayersHaveSRIDStylePlugIn.this.initialize(taskEvent.getTask().getLayerManager());
            }

            @Override
            public void taskLoaded(TaskEvent taskEvent) {
            }
        });
        for (JInternalFrame internalFrame : workbenchFrame.getInternalFrames()) {
            block.yield(internalFrame);
        }
    }
}

