/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.attributeoperations.statistics;

import org.openjump.core.graph.pirolProject.PirolPoint;
import org.openjump.core.graph.pirolProject.ScaleChanger;

public class PunktScaler
implements ScaleChanger {
    protected int dimension = 0;
    protected double[] mins = null;
    protected double[] ranges = null;

    public PunktScaler(int dimension, double[] mins, double[] ranges) {
        this.dimension = dimension;
        this.mins = mins;
        this.ranges = ranges;
    }

    public PunktScaler(PirolPoint[] punktArray) {
        try {
            this.getValuesFromArray(punktArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void getValuesFromArray(PirolPoint[] array) throws Exception {
        if (array.length == 0) {
            return;
        }
        PirolPoint pkt = array[0];
        this.dimension = pkt.getDimension();
        this.mins = new double[this.dimension];
        this.ranges = new double[this.dimension];
        double[] maxs = new double[this.dimension];
        for (int dim = 0; dim < this.dimension; ++dim) {
            this.mins[dim] = Double.MAX_VALUE;
            this.ranges[dim] = 0.0;
            maxs[dim] = -1.7976931348623157E308;
        }
        for (int i = 0; i < array.length; ++i) {
            pkt = array[i];
            pkt.setScaler(this);
            for (int dim = 0; dim < this.dimension; ++dim) {
                double value = pkt.getCoordinate(dim);
                if (value < this.mins[dim]) {
                    this.mins[dim] = value;
                }
                if (!(value > maxs[dim])) continue;
                maxs[dim] = value;
            }
        }
        for (int dim = 0; dim < this.dimension; ++dim) {
            this.ranges[dim] = maxs[dim] - this.mins[dim];
        }
    }

    @Override
    public double scale(double value, int dimension) {
        if (dimension < this.dimension) {
            return (value - this.mins[dimension]) / this.ranges[dimension];
        }
        return Double.NaN;
    }

    @Override
    public double unScale(double value, int dimension) {
        if (dimension < this.dimension) {
            return value * this.ranges[dimension] + this.mins[dimension];
        }
        return Double.NaN;
    }
}

