/*
 * Decompiled with CFR 0.152.
 */
package org.openjump.core.apitools;

import com.vividsolutions.jump.feature.AttributeType;
import com.vividsolutions.jump.feature.BasicFeature;
import com.vividsolutions.jump.feature.Feature;
import com.vividsolutions.jump.feature.FeatureCollection;
import com.vividsolutions.jump.feature.FeatureDataset;
import com.vividsolutions.jump.feature.FeatureSchema;
import com.vividsolutions.jump.workbench.WorkbenchContext;
import com.vividsolutions.jump.workbench.model.Category;
import com.vividsolutions.jump.workbench.model.Layer;
import com.vividsolutions.jump.workbench.model.Layerable;
import com.vividsolutions.jump.workbench.model.StandardCategoryNames;
import com.vividsolutions.jump.workbench.plugin.PlugInContext;
import de.fho.jump.pirol.utilities.settings.PirolPlugInSettings;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.locationtech.jts.geom.Geometry;
import org.openjump.core.apitools.SelectionTools;
import org.openjump.core.apitools.ToolToMakeYourLifeEasier;
import org.openjump.core.apitools.objecttyperoles.FeatureCollectionRole;
import org.openjump.core.apitools.objecttyperoles.PirolFeatureCollection;
import org.openjump.core.apitools.objecttyperoles.RoleTriangularIrregularNet;

public class LayerTools
extends ToolToMakeYourLifeEasier {
    protected PlugInContext context;

    public LayerTools(PlugInContext context) {
        this.context = context;
    }

    public Layer[] getSelectedLayers() {
        return this.context.getSelectedLayers();
    }

    public List getSelectedFeatures() {
        return SelectionTools.getSelectedFeatures(this.context);
    }

    public Geometry getFenceGeometry() {
        return SelectionTools.getFenceGeometry(this.context);
    }

    public List getFeaturesInFence() {
        SelectionTools st = new SelectionTools(this.context);
        return st.getFeaturesInFence();
    }

    public Feature[] getFeaturesInFenceInLayer(Layer layer, Geometry fenceGeometry) {
        return SelectionTools.getFeaturesInFenceInLayer(layer, fenceGeometry);
    }

    public Feature[] getFeaturesInFenceInLayer(Feature[] featArray, Geometry fenceGeometry) {
        return SelectionTools.getFeaturesInFenceInLayer(featArray, fenceGeometry);
    }

    public int getNumSelectedLayers() {
        return LayerTools.getNumSelectedLayers(this.context);
    }

    public static int getNumSelectedLayers(PlugInContext context) {
        return context.getSelectedLayers().length;
    }

    public static Layer addStandardResultLayer(String title, FeatureCollection featCollection, PlugInContext context, FeatureCollectionRole role) {
        return LayerTools.addStandardResultLayer(title, featCollection, Color.yellow, context, role);
    }

    public static Layer addAndSelectStandardResultLayer(String title, FeatureCollection featCollection, Color color, PlugInContext context, FeatureCollectionRole role) {
        return LayerTools.addStandardResultLayer(title, featCollection, color, context, true, role);
    }

    public static Layer addAndSelectStandardResultLayer(String title, FeatureCollection featCollection, PlugInContext context, FeatureCollectionRole role) {
        return LayerTools.addStandardResultLayer(title, featCollection, Color.YELLOW, context, true, role);
    }

    public static Layer addStandardResultLayer(String title, FeatureCollection featCollection, Color color, PlugInContext context, FeatureCollectionRole role) {
        return LayerTools.addStandardResultLayer(title, featCollection, color, context, false, role);
    }

    public static Layer addStandardResultLayer(String title, FeatureCollection featCollection, Color color, PlugInContext context, boolean select, FeatureCollectionRole role) {
        if (featCollection == null || context == null) {
            return null;
        }
        Layer newLayer = null;
        if (FeatureCollection.class.isInstance(featCollection)) {
            newLayer = new Layer(title, color, new PirolFeatureCollection(featCollection, role), context.getLayerManager());
        } else {
            if (role != null) {
                ((PirolFeatureCollection)featCollection).addRole(role);
            }
            newLayer = new Layer(title, color, featCollection, context.getLayerManager());
        }
        context.getLayerManager().addLayer(StandardCategoryNames.RESULT, newLayer);
        if (select) {
            SelectionTools.selectLayer(context, newLayer);
        }
        return newLayer;
    }

    public Layer addStandardResultLayer(String title, FeatureCollection featCollection, FeatureCollectionRole role) {
        return LayerTools.addStandardResultLayer(title, featCollection, this.context, role);
    }

    public Map getLayer2FeatureMap(List features) {
        return LayerTools.getLayer2FeatureMap(features, this.context);
    }

    public static Layer putGeometryArrayIntoMap(Geometry[] geometryArray, PlugInContext context) {
        FeatureSchema fs = new FeatureSchema();
        fs.addAttribute("geometry", AttributeType.GEOMETRY);
        FeatureDataset fc = new FeatureDataset(fs);
        for (int i = 0; i < geometryArray.length; ++i) {
            BasicFeature f = new BasicFeature(fs);
            f.setGeometry(geometryArray[i]);
            fc.add(f);
        }
        return LayerTools.addStandardResultLayer("triangles", fc, context, new RoleTriangularIrregularNet());
    }

    public static Map<Layer, List<Feature>> getLayer2FeatureMap(List<Feature> features, PlugInContext context) {
        List<Layer> layers = context.getLayerManager().getVisibleLayers(false);
        HashMap<Layer, List<Feature>> layer2FeatList = new HashMap<Layer, List<Feature>>();
        for (Layer layer : layers) {
            List<Feature> layerFeats = layer.getFeatureCollectionWrapper().getUltimateWrappee().getFeatures();
            for (Feature feat : features) {
                if (!layerFeats.contains(feat)) continue;
                if (!layer2FeatList.containsKey(layer)) {
                    layer2FeatList.put(layer, new ArrayList());
                }
                ((List)layer2FeatList.get(layer)).add(feat);
            }
        }
        return layer2FeatList;
    }

    public Category getResultCategory() {
        return LayerTools.getResultCategory(this.context);
    }

    public static Category getResultCategory(PlugInContext context) {
        Category category = context.getLayerManager().getCategory(PirolPlugInSettings.resultLayerCategory());
        if (category == null) {
            context.getLayerManager().addCategory(PirolPlugInSettings.resultLayerCategory(), 0);
            category = context.getLayerManager().getCategory(PirolPlugInSettings.resultLayerCategory());
        }
        return category;
    }

    public static Layer[] getSelectedLayers(PlugInContext context, int num) {
        Layer[] selLayers = context.getSelectedLayers();
        if (selLayers.length == 0) {
            return null;
        }
        if (num <= 0) {
            return selLayers;
        }
        Layer[] result = new Layer[num];
        for (int i = 0; i < selLayers.length && i < result.length; ++i) {
            result[i] = selLayers[i];
        }
        return result;
    }

    public static Layer getSelectedLayer(PlugInContext context) {
        Layer[] selLayers = LayerTools.getSelectedLayers(context, 1);
        if (selLayers == null || selLayers.length == 0) {
            return null;
        }
        return selLayers[0];
    }

    public static Layerable getSelectedLayerable(PlugInContext context, Class layerableClass) {
        Collection<Layerable> selLayers = context.getLayerNamePanel().selectedNodes(layerableClass);
        if (selLayers == null || selLayers.size() == 0) {
            return null;
        }
        return selLayers.toArray(new Layerable[0])[0];
    }

    public static Layerable getSelectedLayerable(WorkbenchContext context, Class layerableClass) {
        Collection<Layerable> selLayers = context.getLayerableNamePanel().selectedNodes(layerableClass);
        if (selLayers == null || selLayers.size() == 0) {
            return null;
        }
        return selLayers.toArray(new Layerable[0])[0];
    }

    public static String getUniqueLayerName(PlugInContext context, String name) {
        return context.getLayerManager().uniqueLayerName(name);
    }
}

