/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.shapefile;

import com.vividsolutions.jump.I18N;
import com.vividsolutions.jump.io.EndianDataInputStream;
import com.vividsolutions.jump.io.EndianDataOutputStream;
import com.vividsolutions.jump.task.DummyTaskMonitor;
import com.vividsolutions.jump.task.TaskCancelledException;
import com.vividsolutions.jump.task.TaskMonitor;
import com.vividsolutions.jump.task.TaskMonitorSupport;
import com.vividsolutions.jump.task.TaskMonitorV2Util;
import com.vividsolutions.jump.util.Timer;
import com.vividsolutions.jump.workbench.Logger;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.geotools.shapefile.MultiLineHandler;
import org.geotools.shapefile.MultiPointHandler;
import org.geotools.shapefile.NullShapeHandler;
import org.geotools.shapefile.PointHandler;
import org.geotools.shapefile.PolygonHandler;
import org.geotools.shapefile.ShapeHandler;
import org.geotools.shapefile.ShapeTypeNotSupportedException;
import org.geotools.shapefile.ShapefileException;
import org.geotools.shapefile.ShapefileHeader;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class Shapefile
implements TaskMonitorSupport {
    static final int SHAPEFILE_ID = 9994;
    static final int VERSION = 1000;
    public static final int NULL = 0;
    public static final int POINT = 1;
    public static final int POINTZ = 11;
    public static final int POINTM = 21;
    public static final int ARC = 3;
    public static final int ARCM = 23;
    public static final int ARCZ = 13;
    public static final int POLYGON = 5;
    public static final int POLYGONM = 25;
    public static final int POLYGONZ = 15;
    public static final int MULTIPOINT = 8;
    public static final int MULTIPOINTM = 28;
    public static final int MULTIPOINTZ = 18;
    public static final int MULTIPATCH = 31;
    public static final int UNDEFINED = -1;
    private URL baseURL;
    private InputStream shpInputStream;
    private int errors;
    private TaskMonitor taskMonitor = new DummyTaskMonitor();

    public Shapefile(URL url) {
        this.baseURL = url;
    }

    public Shapefile(InputStream is) {
        this.shpInputStream = is;
    }

    public void close() {
        try {
            if (this.shpInputStream != null) {
                this.shpInputStream.close();
            }
        }
        catch (IOException ex) {
            Logger.error(ex);
        }
    }

    private EndianDataInputStream getInputStream() throws IOException {
        if (this.shpInputStream == null && this.baseURL != null) {
            try {
                URLConnection uc = this.baseURL.openConnection();
                this.shpInputStream = new BufferedInputStream(uc.getInputStream(), 16384);
            }
            catch (Exception e) {
                Logger.error(e);
            }
            if (this.shpInputStream == null) {
                throw new IOException("Couldn't make a connection to the URL: " + this.baseURL);
            }
        }
        return new EndianDataInputStream(this.shpInputStream);
    }

    private EndianDataOutputStream getOutputStream() throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(this.baseURL.getFile()));
        return new EndianDataOutputStream(out);
    }

    /*
     * Unable to fully structure code
     */
    public GeometryCollection read(GeometryFactory geometryFactory) throws Exception {
        list = new ArrayList<Geometry>();
        pos = 0;
        try {
            file = this.getInputStream();
            try {
                mainHeader = new ShapefileHeader(file);
                if (mainHeader.getVersion() != 1000) {
                    Logger.warn(String.format("Unknown shapefile version (%s) : try to read anyway", new Object[]{mainHeader.getVersion()}));
                }
                pos += 50;
                type = mainHeader.getShapeType();
                handler = Shapefile.getShapeHandler(type);
                if (handler == null) {
                    throw new ShapeTypeNotSupportedException("Unsuported shape type: " + type);
                }
                this.errors = 0;
                count = 1;
                r = new Reporter();
                while (true) lbl-1000:
                // 6 sources

                {
                    recordNumber = file.readIntBE();
                    pos += 2;
                    if (recordNumber != count) {
                        Logger.warn("wrong record number (" + recordNumber + ")");
                        continue;
                    }
                    contentLength = file.readIntBE();
                    pos += 2;
                    if (contentLength <= 0) {
                        Logger.warn("found a negative content length (" + contentLength + ")");
                        continue;
                    }
                    try {
                        body = handler.read(file, geometryFactory, contentLength);
                        pos += contentLength;
                        list.add(body);
                        r.report(++count);
                        if (this.getTaskMonitor().isCancelRequested()) {
                            throw new TaskCancelledException();
                        }
                        if (body.getUserData() == null) ** GOTO lbl-1000
                        ++this.errors;
                    }
                    catch (TaskCancelledException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        Logger.warn("Error processing record " + recordNumber + " : " + e.getMessage(), e);
                        ++this.errors;
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable var5_7) {
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (Throwable var6_13) {
                        var5_7.addSuppressed(var6_13);
                    }
                }
                throw var5_7;
            }
            ** GOTO lbl-1000
        }
        catch (EOFException var4_5) {
            return geometryFactory.createGeometryCollection(list.toArray(new Geometry[0]));
        }
    }

    public int getErrorNumber() {
        return this.errors;
    }

    public void write(GeometryCollection geometries, int ShapeFileDimension) throws Exception {
        try (EndianDataOutputStream file = this.getOutputStream();){
            ShapefileHeader mainHeader = new ShapefileHeader(geometries, ShapeFileDimension);
            mainHeader.write(file);
            int pos = 50;
            int numShapes = geometries.getNumGeometries();
            ShapeHandler handler = geometries.getNumGeometries() == 0 ? new PointHandler() : Shapefile.getShapeHandler(geometries.getGeometryN(0), ShapeFileDimension);
            for (int i = 0; i < numShapes; ++i) {
                Geometry body = geometries.getGeometryN(i);
                file.writeIntBE(i + 1);
                file.writeIntBE(handler.getLength(body));
                pos += 4;
                handler.write(body, file);
                pos += handler.getLength(body);
            }
            file.flush();
        }
    }

    public synchronized void writeIndex(GeometryCollection geometries, EndianDataOutputStream file, int ShapeFileDimension) throws Exception {
        int nrecords = geometries.getNumGeometries();
        ShapefileHeader mainHeader = new ShapefileHeader(geometries, ShapeFileDimension);
        ShapeHandler handler = geometries.getNumGeometries() == 0 ? new PointHandler() : Shapefile.getShapeHandler(geometries.getGeometryN(0), ShapeFileDimension);
        mainHeader.writeToIndex(file);
        int pos = 50;
        for (int i = 0; i < nrecords; ++i) {
            Geometry geom = geometries.getGeometryN(i);
            int len = handler.getLength(geom);
            file.writeIntBE(pos);
            file.writeIntBE(len);
            pos = pos + len + 4;
        }
        file.flush();
        file.close();
    }

    public static String getShapeTypeDescription(int index) {
        switch (index) {
            case 0: {
                return "Null Shape";
            }
            case 1: {
                return "Point";
            }
            case 11: {
                return "PointZ";
            }
            case 21: {
                return "PointM";
            }
            case 3: {
                return "PolyLine";
            }
            case 23: {
                return "PolyLineM";
            }
            case 13: {
                return "PolyLineZ";
            }
            case 5: {
                return "Polygon";
            }
            case 25: {
                return "PolygonM";
            }
            case 15: {
                return "PolygonZ";
            }
            case 8: {
                return "MultiPoint";
            }
            case 28: {
                return "MultiPointM";
            }
            case 18: {
                return "MultiPointZ";
            }
        }
        return "Undefined";
    }

    public static ShapeHandler getShapeHandler(Geometry geom, int ShapeFileDimension) throws Exception {
        return Shapefile.getShapeHandler(Shapefile.getShapeType(geom, ShapeFileDimension));
    }

    public static ShapeHandler getShapeHandler(int type) throws Exception {
        switch (type) {
            case 0: {
                return new NullShapeHandler();
            }
            case 1: {
                return new PointHandler();
            }
            case 11: {
                return new PointHandler(11);
            }
            case 21: {
                return new PointHandler(21);
            }
            case 5: {
                return new PolygonHandler();
            }
            case 25: {
                return new PolygonHandler(25);
            }
            case 15: {
                return new PolygonHandler(15);
            }
            case 3: {
                return new MultiLineHandler();
            }
            case 23: {
                return new MultiLineHandler(23);
            }
            case 13: {
                return new MultiLineHandler(13);
            }
            case 8: {
                return new MultiPointHandler();
            }
            case 28: {
                return new MultiPointHandler(28);
            }
            case 18: {
                return new MultiPointHandler(18);
            }
        }
        return null;
    }

    public static int getShapeType(Geometry geom, int ShapeFileDimension) throws ShapefileException {
        if (ShapeFileDimension != 2 && ShapeFileDimension != 3 && ShapeFileDimension != 4) {
            throw new ShapefileException("invalid ShapeFileDimension for getShapeType - expected 2,3,or 4 but got " + ShapeFileDimension + "  (2=x,y ; 3=x,y,m ; 4=x,y,z,m)");
        }
        if (geom instanceof Point) {
            switch (ShapeFileDimension) {
                case 2: {
                    return 1;
                }
                case 3: {
                    return 21;
                }
                case 4: {
                    return 11;
                }
            }
        }
        if (geom instanceof MultiPoint) {
            switch (ShapeFileDimension) {
                case 2: {
                    return 8;
                }
                case 3: {
                    return 28;
                }
                case 4: {
                    return 18;
                }
            }
        }
        if (geom instanceof Polygon || geom instanceof MultiPolygon) {
            switch (ShapeFileDimension) {
                case 2: {
                    return 5;
                }
                case 3: {
                    return 25;
                }
                case 4: {
                    return 15;
                }
            }
        }
        if (geom instanceof LineString || geom instanceof MultiLineString) {
            switch (ShapeFileDimension) {
                case 2: {
                    return 3;
                }
                case 3: {
                    return 23;
                }
                case 4: {
                    return 13;
                }
            }
        }
        if (geom instanceof GeometryCollection && geom.isEmpty()) {
            return 0;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public synchronized GeometryCollection readFromIndex(GeometryFactory geometryFactory, InputStream is) throws Exception {
        tmpShp = File.createTempFile("tmpshp", ".shp");
        list = new ArrayList<Geometry>();
        try {
            try {
                bis = new BufferedInputStream(this.shpInputStream, 4096);
                try {
                    bos = new BufferedOutputStream(new FileOutputStream(tmpShp), 4096);
                    try {
                        raf = new RandomAccessFile(tmpShp, "r");
                        try {
                            shx = new EndianDataInputStream(is);
                            try {
                                bytes = new byte[4096];
                                while (-1 != (nb = bis.read(bytes))) {
                                    bos.write(bytes, 0, nb);
                                }
                                bos.flush();
                                bytes = new byte[100];
                                bb = ByteBuffer.wrap(bytes);
                                raf.getChannel().read(bb);
                                shp = new EndianDataInputStream(new ByteArrayInputStream(bytes));
                                shpMainHeader = new ShapefileHeader(shp);
                                if (shpMainHeader.getVersion() != 1000) {
                                    Logger.warn(String.format("Unknown shp version (%s) : try to read anyway", new Object[]{shpMainHeader.getVersion()}));
                                }
                                if ((shxMainHeader = new ShapefileHeader(shx)).getVersion() != 1000) {
                                    Logger.warn(String.format("Unknown shx version (%s) : try to read anyway", new Object[]{shxMainHeader.getVersion()}));
                                }
                                if ((handler = Shapefile.getShapeHandler(type = shpMainHeader.getShapeType())) == null) {
                                    throw new ShapeTypeNotSupportedException("Unsupported shape type:" + type);
                                }
                                recordNumber = 0;
                                r = new Reporter();
                                while (true) lbl-1000:
                                // 4 sources

                                {
                                    offset = (long)shx.readIntBE() & 0xFFFFFFFFL;
                                    length = shx.readIntBE();
                                    ++recordNumber;
                                    try {
                                        bytes = new byte[length * 2];
                                        bb = ByteBuffer.wrap(bytes);
                                        raf.getChannel().read(bb, offset * 2L + 8L);
                                        shp = new EndianDataInputStream(new ByteArrayInputStream(bytes));
                                        body = handler.read(shp, geometryFactory, length);
                                        list.add(body);
                                        r.report(recordNumber);
                                        if (this.getTaskMonitor().isCancelRequested()) {
                                            throw new TaskCancelledException();
                                        }
                                        if (body.getUserData() == null) ** GOTO lbl-1000
                                        ++this.errors;
                                    }
                                    catch (TaskCancelledException e) {
                                        throw e;
                                    }
                                    catch (Exception e) {
                                        Logger.warn("Error processing record " + recordNumber + ": " + e.getMessage(), e);
                                        Logger.warn("an empty Geometry has been returned");
                                        list.add(handler.getEmptyGeometry(geometryFactory));
                                        ++this.errors;
                                        continue;
                                    }
                                    break;
                                }
                            }
                            catch (Throwable var9_18) {
                                try {
                                    shx.close();
                                }
                                catch (Throwable var10_16) {
                                    var9_18.addSuppressed(var10_16);
                                }
                                throw var9_18;
                            }
                            ** GOTO lbl-1000
                        }
                        catch (Throwable var8_13) {
                            try {
                                raf.close();
                            }
                            catch (Throwable var9_19) {
                                var8_13.addSuppressed(var9_19);
                            }
                            throw var8_13;
                        }
                    }
                    catch (Throwable var7_10) {
                        try {
                            bos.close();
                        }
                        catch (Throwable var8_14) {
                            var7_10.addSuppressed(var8_14);
                        }
                        throw var7_10;
                    }
                }
                catch (Throwable var6_8) {
                    try {
                        bis.close();
                    }
                    catch (Throwable var7_11) {
                        var6_8.addSuppressed(var7_11);
                    }
                    throw var6_8;
                }
            }
            catch (EOFException var5_6) {
                if (tmpShp.exists() && !tmpShp.delete()) {
                    Logger.warn(tmpShp + " could not be deleted");
                }
            }
        }
        catch (Throwable var24_33) {
            if (tmpShp.exists() && !tmpShp.delete()) {
                Logger.warn(tmpShp + " could not be deleted");
            }
            throw var24_33;
        }
        return geometryFactory.createGeometryCollection(list.toArray(new Geometry[0]));
    }

    @Override
    public void setTaskMonitor(TaskMonitor taskMonitor) {
        this.taskMonitor = taskMonitor;
    }

    @Override
    public TaskMonitor getTaskMonitor() {
        return this.taskMonitor;
    }

    private class Reporter {
        int totalCount = -1;
        long init = Timer.now();
        int sampleSize = -1;
        long samplePeriod = 500L;
        int lastUpdateCount = 0;
        long lastUpdateTime = this.init;

        public Reporter() {
        }

        public Reporter(int totalCount) {
            this.totalCount = totalCount;
        }

        public void report(int count) {
            if (this.sampleSize < 0 && this.init + this.samplePeriod <= Timer.now()) {
                this.sampleSize = count;
                this.print(count);
            } else if (this.sampleSize >= 0 && this.lastUpdateCount + this.sampleSize <= count) {
                long msSince = Timer.milliSecondsSince(this.lastUpdateTime);
                double factor = msSince > 0L ? (double)this.samplePeriod / (double)msSince : 2.0;
                int newSampleSize = (int)(factor * (double)this.sampleSize);
                this.sampleSize = newSampleSize > 0 ? newSampleSize : 1;
                this.print(count);
            }
        }

        private void print(int count) {
            this.lastUpdateTime = Timer.now();
            this.lastUpdateCount = count;
            if (this.totalCount >= 0) {
                TaskMonitorV2Util.report(Shapefile.this.getTaskMonitor(), I18N.getInstance().get("Reader.parsed-{0}-of-totally-{1}-features", String.format("%,10d", count), this.totalCount));
            } else {
                TaskMonitorV2Util.report(Shapefile.this.getTaskMonitor(), I18N.getInstance().get("Reader.parsed-{0}-features", String.format("%,10d", count)));
            }
        }
    }
}

