/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.wms;

import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.wms.MapLayer;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class MapStyle {
    private String name;
    private String title;
    private String urlLegend;
    private String formatLegend;
    private boolean selected;
    private Icon legendIcon;
    private MapLayer layer;
    private boolean loadedIcon;
    private int width;
    private int height;

    public MapStyle(String name, String title, String urlLegend, String formatLegend) {
        this.name = name;
        this.title = title;
        this.setUrlLegend(urlLegend);
        this.formatLegend = formatLegend;
        this.selected = false;
    }

    public MapStyle(String name, String title, String urlLegend, String formatLegend, int w, int h) {
        this.name = name;
        this.title = title;
        this.setUrlLegend(urlLegend);
        this.formatLegend = formatLegend;
        this.selected = false;
        this.width = w;
        this.height = h;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getUrlLegend() {
        return this.urlLegend;
    }

    public void setUrlLegend(String newURLLegend) {
        this.urlLegend = newURLLegend;
    }

    public String getFormatLegend() {
        return this.formatLegend;
    }

    public void setFormatLegend(String formatLegend) {
        this.formatLegend = formatLegend;
    }

    public String toString() {
        return this.name;
    }

    public Icon getLegendIcon() {
        if (!this.loadedIcon) {
            this.loadIconFromLegendURL();
        }
        return this.legendIcon;
    }

    private void loadIconFromLegendURL() {
        URL selectedUrl = null;
        try {
            selectedUrl = new URL(this.urlLegend);
        }
        catch (MalformedURLException e) {
            Logger.error(e);
        }
        if (selectedUrl != null) {
            try {
                BufferedImage image = ImageIO.read(selectedUrl);
                this.legendIcon = new ImageIcon(image);
                this.loadedIcon = true;
            }
            catch (IOException e) {
                Logger.error(e);
            }
        } else {
            this.loadedIcon = false;
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected, boolean check) {
        if (check) {
            if (this.selected && !selected && this.layer.getStyles().size() == 1) {
                return;
            }
            if (this.selected && !selected) {
                for (MapStyle style : this.layer.getStyles()) {
                    if (style.equals(this)) continue;
                    style.setSelected(true, false);
                }
            }
        }
        this.selected = selected;
    }

    public void fireStyleChanged() {
        this.layer.setSelectedStyle(this);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof MapStyle)) {
            return false;
        }
        return this.getName().equals(((MapStyle)other).getName());
    }

    public void setLayer(MapLayer layer) {
        this.layer = layer;
    }
}

