/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.wms;

import com.vividsolutions.jump.workbench.Logger;
import com.vividsolutions.wms.AbstractWMSRequest;
import com.vividsolutions.wms.BoundingBox;
import com.vividsolutions.wms.MapStyle;
import com.vividsolutions.wms.WMService;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.openjump.util.UriUtil;

public class MapRequest
extends AbstractWMSRequest {
    private int imgWidth = 100;
    private int imgHeight = 100;
    private List<String> layerNames = new ArrayList<String>();
    private BoundingBox bbox;
    private boolean transparent;
    private String format;
    private MapStyle style;
    private String moreParameters;
    private String apiKeyNameAndValue;

    public MapRequest(WMService service) {
        super(service);
        this.bbox = service.getCapabilities().getTopLayer().getBoundingBox();
        this.transparent = false;
        this.format = null;
    }

    public String getFormat() {
        return this.format;
    }

    public int getImageWidth() {
        return this.imgWidth;
    }

    public int getImageHeight() {
        return this.imgHeight;
    }

    public List<String> getLayerNames() {
        return Collections.unmodifiableList(this.layerNames);
    }

    public BoundingBox getBoundingBox() {
        return this.bbox;
    }

    public boolean getTransparent() {
        return this.transparent;
    }

    public void setFormat(String format) throws IllegalArgumentException {
        this.format = format;
    }

    public void setStyle(MapStyle style) {
        this.style = style;
    }

    public void setMoreParameters(String moreParameters) {
        this.moreParameters = moreParameters;
    }

    public void setApiKeyNameAndValue(String apiKeyNameAndValue) {
        this.apiKeyNameAndValue = apiKeyNameAndValue;
    }

    public void setImageWidth(int imageWidth) {
        this.imgWidth = imageWidth;
    }

    public void setImageHeight(int imageHeight) {
        this.imgHeight = imageHeight;
    }

    public void setImageSize(int imageWidth, int imageHeight) {
        this.imgWidth = imageWidth;
        this.imgHeight = imageHeight;
    }

    public void setLayerNames(List<String> layerNames) {
        this.layerNames = layerNames;
    }

    public void setBoundingBox(BoundingBox bbox) {
        this.bbox = bbox;
    }

    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
    }

    public static String listToString(List<String> list) {
        Iterator<String> it = list.iterator();
        StringBuilder buf = new StringBuilder();
        while (it.hasNext()) {
            String layer = it.next();
            buf.append(layer);
            if (!it.hasNext()) continue;
            buf.append(",");
        }
        return buf.toString();
    }

    @Override
    public URL getURL() throws MalformedURLException {
        String ver = "REQUEST=map&WMTVER=1.0";
        if ("1.1.0".equals(this.version)) {
            ver = "REQUEST=GetMap&SERVICE=WMS&VERSION=1.1.0";
        } else if ("1.1.1".equals(this.version)) {
            ver = "REQUEST=GetMap&SERVICE=WMS&VERSION=1.1.1";
        } else if ("1.3.0".equals(this.version)) {
            ver = "REQUEST=GetMap&SERVICE=WMS&VERSION=1.3.0";
        }
        StringBuilder urlBuf = new StringBuilder(UriUtil.urlMakeAppendSafe(this.service.getCapabilities().getGetMapURL()));
        urlBuf.append(ver + "&WIDTH=" + this.imgWidth + "&HEIGHT=" + this.imgHeight);
        urlBuf.append("&LAYERS=" + UriUtil.urlEncode(MapRequest.listToString(this.layerNames)));
        if (this.transparent) {
            urlBuf.append("&TRANSPARENT=TRUE");
        }
        if (this.format != null) {
            urlBuf.append("&FORMAT=" + UriUtil.urlEncode(this.format));
        }
        if (this.bbox != null) {
            urlBuf.append("&" + this.bbox.getBBox(this.version));
            if (this.bbox.getSRS() != null && !this.bbox.getSRS().equals("LatLon")) {
                if (this.version.compareTo("1.3.0") < 0) {
                    urlBuf.append("&SRS=" + this.bbox.getSRS());
                } else {
                    urlBuf.append("&CRS=" + this.bbox.getSRS());
                }
            }
        }
        if (this.style == null) {
            urlBuf.append("&STYLES=");
        } else {
            urlBuf.append("&STYLES=").append(UriUtil.urlEncode(this.style.getName()));
        }
        if (this.moreParameters != null && !this.moreParameters.isEmpty()) {
            if (!this.moreParameters.startsWith("&")) {
                urlBuf.append("&");
            }
            for (char c : this.moreParameters.toCharArray()) {
                if (c == '&' || c == '=') {
                    urlBuf.append(c);
                    continue;
                }
                urlBuf.append(UriUtil.urlEncode(String.valueOf(c)));
            }
        }
        if (this.apiKeyNameAndValue != null) {
            urlBuf.append("&").append(this.apiKeyNameAndValue);
        }
        Logger.trace(urlBuf.toString());
        return new URL(urlBuf.toString());
    }
}

