/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.wms;

import com.vividsolutions.wms.MapLayer;
import com.vividsolutions.wms.WMService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.openjump.util.UriUtil;

public class Capabilities {
    private final MapLayer topLayer;
    private final String title;
    private final List<String> mapFormats;
    private final WMService service;
    private final List<String> infoFormats;
    private String getMapURL;
    private String featureInfoURL;

    public Capabilities(WMService service, String title, MapLayer topLayer, Collection<String> mapFormats, Collection<String> infoFormats) {
        this.service = service;
        this.title = title;
        this.topLayer = topLayer;
        this.mapFormats = new ArrayList<String>(mapFormats);
        this.infoFormats = new ArrayList<String>(infoFormats);
        this.getMapURL = service.getServerUrl();
        this.featureInfoURL = service.getServerUrl();
    }

    public Capabilities(WMService service, String title, MapLayer topLayer, Collection<String> mapFormats, Collection<String> infoFormats, String getMapURL, String featureInfoURL) {
        this(service, title, topLayer, mapFormats, infoFormats);
        this.getMapURL = getMapURL;
        this.featureInfoURL = featureInfoURL;
    }

    public WMService getService() {
        return this.service;
    }

    public MapLayer getTopLayer() {
        return this.topLayer;
    }

    public MapLayer getMapLayerByName(String name) {
        return this.getMapLayerByName(this.topLayer, name);
    }

    private MapLayer getMapLayerByName(MapLayer mapLayer, String name) {
        String mapName = mapLayer.getName();
        if (mapName != null && mapName.equals(name)) {
            return mapLayer;
        }
        for (MapLayer layer : mapLayer.getSubLayerList()) {
            MapLayer r = this.getMapLayerByName(layer, name);
            if (r == null) continue;
            return r;
        }
        return null;
    }

    public String getTitle() {
        return this.title;
    }

    public String getGetMapURL() {
        return this.getMapURL;
    }

    public String getFeatureInfoURL() {
        String serviceUrl = this.service.getServerUrl();
        if (UriUtil.isURL(this.featureInfoURL) && UriUtil.urlGetUser(this.featureInfoURL).isEmpty() && UriUtil.urlGetHost(this.featureInfoURL).equals(UriUtil.urlGetHost(serviceUrl))) {
            return UriUtil.urlAddUserInfo(this.featureInfoURL, this.service.getServerUrlAsUrl().getUserInfo());
        }
        return UriUtil.isURL(this.featureInfoURL) ? this.featureInfoURL : serviceUrl;
    }

    public void setGetMapURL(String url) {
        this.getMapURL = url;
    }

    public String[] getMapFormats() {
        String[] formats = new String[this.mapFormats.size()];
        Iterator<String> it = this.mapFormats.iterator();
        int i = 0;
        while (it.hasNext()) {
            formats[i++] = it.next();
        }
        return formats;
    }

    public String getInfoFormat() {
        Iterator<String> it;
        String format = "text/plain";
        if (!this.infoFormats.contains(format) && (it = this.infoFormats.iterator()).hasNext()) {
            format = it.next();
        }
        return format;
    }
}

